
package org.autoplot;

import java.util.logging.Logger;
import javax.swing.JSpinner;
import org.autoplot.layout.LayoutConstants;

/**
 * Dialog asking for number of rows and columns of plots to add, and where
 * to put them.
 * @author jbf
 */
public class AddPlotsDialog extends javax.swing.JPanel {

    private static final Logger logger = org.das2.util.LoggerManager.getLogger("autoplot.gui");
    
    /** Creates new form AddPlotsDialog */
    public AddPlotsDialog() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        numberOfRowsSpinner = new javax.swing.JSpinner();
        numberOfColumnsSpinner = new javax.swing.JSpinner();
        jComboBox1 = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();

        jLabel1.setText("Number of plots per row:");

        jLabel2.setText("Number of rows:");

        numberOfRowsSpinner.setToolTipText("Number of rows to add.");
        numberOfRowsSpinner.setValue(1);

        numberOfColumnsSpinner.setToolTipText("Number of plots per row.");
        numberOfColumnsSpinner.setValue(1);

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "replace current", "above current", "below current", "to the left of current", "to the right of current", " " }));
        jComboBox1.setSelectedIndex(2);
        jComboBox1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBox1ItemStateChanged(evt);
            }
        });

        jLabel3.setText("Add plots:");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(layout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(jLabel3)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jComboBox1, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel1)
                            .add(jLabel2))
                        .add(41, 41, 41)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(numberOfColumnsSpinner)
                            .add(numberOfRowsSpinner, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 50, Short.MAX_VALUE))))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(numberOfRowsSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(numberOfColumnsSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBox1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBox1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBox1ItemStateChanged
        logger.finer("itemStateChanged");
    }//GEN-LAST:event_jComboBox1ItemStateChanged

    /**
     * return the direction, LayoutConstants.ABOVE, LayoutConstants.BELOW, or null for in-the-place-of.
     * @return
     */
    public Object getDirection() {
        switch (jComboBox1.getSelectedIndex()) {
            case 1:
                return LayoutConstants.ABOVE;
            case 2:
                return LayoutConstants.BELOW;
            case 3:
                return LayoutConstants.LEFT;
            case 4:
                return LayoutConstants.RIGHT;
            default:
                return null; // in the place of
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JComboBox jComboBox1;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JLabel jLabel3;
    public javax.swing.JSpinner numberOfColumnsSpinner;
    public javax.swing.JSpinner numberOfRowsSpinner;
    // End of variables declaration//GEN-END:variables


    public JSpinner getNumberOfColumnsSpinner() {
        return numberOfColumnsSpinner;
    }

    public JSpinner getNumberOfRowsSpinner() {
        return numberOfRowsSpinner;
    }



}
