/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.autoplot;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import org.autoplot.dom.Application;
import org.autoplot.dom.DomOps;

/**
 *
 * @author jbf
 */
public class FixLayoutPanel extends javax.swing.JPanel {

    /**
     * Creates new form FixLayoutPanel
     */
    public FixLayoutPanel() {
        initComponents();
    }

    public void setOptions( Map<String,String> options ) {
        for ( Entry<String,String> e: options.entrySet() ) {
            switch ( e.getKey() ) {
                case DomOps.OPTION_FIX_LAYOUT_HIDE_TITLES:
                    hideTitlesCheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
                case DomOps.OPTION_FIX_LAYOUT_HIDE_TIME_AXES:
                    hideTimeAxesCheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
                case DomOps.OPTION_FIX_LAYOUT_HIDE_Y_AXES:
                    hideYAxesCheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
                case DomOps.OPTION_FIX_LAYOUT_VERTICAL_SPACING:
                    verticalSpacingCheckBox.setSelected(true);
                    verticalSpacingComboBox.setSelectedItem(e.getValue());
                    break;
                case DomOps.OPTION_FIX_LAYOUT_MOVE_LEGENDS_TO_OUTSIDE_NE:
                    moveLegendsToOutsideNECheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
            }
        }
    }
    
    public Map<String,String> getOptions() {
        HashMap<String,String> result= new HashMap<>();
        if ( hideTitlesCheckBox.isSelected() ) {
            result.put( DomOps.OPTION_FIX_LAYOUT_HIDE_TITLES, "true" );
        }
        if ( hideTimeAxesCheckBox.isSelected() ) {
            result.put( DomOps.OPTION_FIX_LAYOUT_HIDE_TIME_AXES, "true" );
        }
        if ( hideYAxesCheckBox.isSelected() ) {
            result.put( DomOps.OPTION_FIX_LAYOUT_HIDE_Y_AXES, "true" );
        }
        if ( verticalSpacingCheckBox.isSelected() ) {
            result.put( DomOps.OPTION_FIX_LAYOUT_VERTICAL_SPACING, verticalSpacingComboBox.getSelectedItem().toString() );
            result.put( DomOps.OPTION_FIX_LAYOUT_HORIZONTAL_SPACING, verticalSpacingComboBox.getSelectedItem().toString() );
        }
        if ( moveLegendsToOutsideNECheckBox.isSelected() ) {
            result.put( DomOps.OPTION_FIX_LAYOUT_MOVE_LEGENDS_TO_OUTSIDE_NE, "true" );
        }
        return result;
    }
    
    Application dom0=null;
    Application dom=null;
    
    /**
     * as changes are made, show the result of the Fix Layout action.
     * @param dom 
     */
    public void setPreview( Application dom ) {
        this.dom= dom;
        this.dom0= (Application)dom.copy();
    }
    
    private void updatePreview() {
        if ( this.dom!=null ) {
            dom.syncTo(dom0);
            org.autoplot.dom.DomOps.fixLayout(dom,getOptions());
        }
    }
    
    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of
     * this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jLabel1 = new javax.swing.JLabel();
        verticalSpacingCheckBox = new javax.swing.JCheckBox();
        verticalSpacingComboBox = new javax.swing.JComboBox<>();
        moveLegendsToOutsideNECheckBox = new javax.swing.JCheckBox();
        hideTimeAxesCheckBox = new javax.swing.JCheckBox();
        hideTitlesCheckBox = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        hideYAxesCheckBox = new javax.swing.JCheckBox();

        jLabel1.setText("Fix Layout");

        verticalSpacingCheckBox.setText("Spacing between plots:");
        verticalSpacingCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                verticalSpacingCheckBoxActionPerformed(evt);
            }
        });

        verticalSpacingComboBox.setEditable(true);
        verticalSpacingComboBox.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "0.0em", "0.5em", "1.0em", "1.5em", "2.0em", "2.5em", "3.0em", "3.5em", "4.0em", " " }));
        verticalSpacingComboBox.setSelectedIndex(1);
        verticalSpacingComboBox.setToolTipText("");

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, verticalSpacingCheckBox, org.jdesktop.beansbinding.ELProperty.create("${selected}"), verticalSpacingComboBox, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        verticalSpacingComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                verticalSpacingComboBoxActionPerformed(evt);
            }
        });

        moveLegendsToOutsideNECheckBox.setText("Move legends to outside NE");
        moveLegendsToOutsideNECheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveLegendsToOutsideNECheckBoxActionPerformed(evt);
            }
        });

        hideTimeAxesCheckBox.setText("Hide time (X) axes");
        hideTimeAxesCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hideTimeAxesCheckBoxActionPerformed(evt);
            }
        });

        hideTitlesCheckBox.setText("Hide Titles");
        hideTitlesCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hideTitlesCheckBoxActionPerformed(evt);
            }
        });

        jLabel2.setText("<html>Fix Layout will try to recover empty spots and overlaps to make the layout easier to read.  You can also turn off titles and axis labels to recover more room.");
        jLabel2.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        hideYAxesCheckBox.setText("Hide Y axes");
        hideYAxesCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hideYAxesCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(0, 12, Short.MAX_VALUE)
                .addComponent(jLabel1)
                .addGap(329, 329, 329))
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(moveLegendsToOutsideNECheckBox)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(verticalSpacingCheckBox)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(verticalSpacingComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(hideTimeAxesCheckBox)
                                .addGap(18, 18, 18)
                                .addComponent(hideYAxesCheckBox))
                            .addComponent(hideTitlesCheckBox))
                        .addGap(0, 0, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(verticalSpacingCheckBox)
                    .addComponent(verticalSpacingComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(hideTitlesCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(hideTimeAxesCheckBox)
                    .addComponent(hideYAxesCheckBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(moveLegendsToOutsideNECheckBox)
                .addGap(0, 101, Short.MAX_VALUE))
        );

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

    private void verticalSpacingCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_verticalSpacingCheckBoxActionPerformed
        updatePreview();
    }//GEN-LAST:event_verticalSpacingCheckBoxActionPerformed

    private void hideTitlesCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hideTitlesCheckBoxActionPerformed
        updatePreview();
    }//GEN-LAST:event_hideTitlesCheckBoxActionPerformed

    private void hideTimeAxesCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hideTimeAxesCheckBoxActionPerformed
        updatePreview();
    }//GEN-LAST:event_hideTimeAxesCheckBoxActionPerformed

    private void moveLegendsToOutsideNECheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveLegendsToOutsideNECheckBoxActionPerformed
        updatePreview();
    }//GEN-LAST:event_moveLegendsToOutsideNECheckBoxActionPerformed

    private void verticalSpacingComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_verticalSpacingComboBoxActionPerformed
        updatePreview();
    }//GEN-LAST:event_verticalSpacingComboBoxActionPerformed

    private void hideYAxesCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hideYAxesCheckBoxActionPerformed
        updatePreview();
    }//GEN-LAST:event_hideYAxesCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox hideTimeAxesCheckBox;
    private javax.swing.JCheckBox hideTitlesCheckBox;
    private javax.swing.JCheckBox hideYAxesCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JCheckBox moveLegendsToOutsideNECheckBox;
    private javax.swing.JCheckBox verticalSpacingCheckBox;
    private javax.swing.JComboBox<String> verticalSpacingComboBox;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables
}
