
package org.autoplot;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.autoplot.datasource.URISplit;

/**
 * Dialog to swap one filename for another.  This uses the dataSetSelector
 * with data sources disabled, and only allows replacement with another file
 * having the same extension.
 * 
 * @see https://sourceforge.net/p/autoplot/bugs/2731/
 * 
 * @author jbf
 */
public class ReplaceFilePanel extends javax.swing.JPanel {

    /**
     * Creates new form ReplaceFilePanel
     */
    public ReplaceFilePanel() {
        initComponents();
        this.dataSetSelector1.setHidePlayButton(true);
        this.dataSetSelector1.setSuggestFiles(true);
        this.dataSetSelector1.setSuggestFsAgg(true);
        
    }

    /**
     * copy over recent URIs to the selector.  This must be called after setCurrentFile!
     * @param appModel 
     */
    public void setApplicationModel( ApplicationModel appModel ) {
        String ext= this.dataSetSelector1.getBrowseTypeExt();
        
        List<String> urls= AutoplotUtil.getUrls(appModel.getRecent());
        List<String> urls1= new ArrayList<String>();
        for ( String url: urls ) {
            URISplit split= URISplit.parse( url );
            if ( ext.equals(split.ext) ) {
                urls1.add( split.file );
            }
        }
        this.dataSetSelector1.setDisableDataSources(true);
        this.dataSetSelector1.setRecent(urls1);
        this.dataSetSelector1.setBrowseTypeExt(ext);
        this.dataSetSelector1.getValue();
    }
    
    public void setCurrentFile( String file ) {
        this.jLabel2.setText(file);
        URISplit split= URISplit.parse( file );
        this.dataSetSelector1.setValue(file);
        this.dataSetSelector1.setBrowseTypeExt( split.ext );
    }
    
    public String getSelectedFile() {
        return this.dataSetSelector1.getValue();
    }
    
    public static void main( String[] args ) {
        ReplaceFilePanel rfp= new ReplaceFilePanel();
        //rfp.setCurrentFile("vap+cdaweb:ds=MMS1_EDP_SLOW_L2_SCPOT&filter=mms&id=mms1_edp_scpot_slow_l2&timerange=2016-01-04+10:00+to+11:00");
        rfp.setCurrentFile("https://cdaweb.gsfc.nasa.gov/sp_phys/data/mms/mms1/edp/slow/l2/scpot/2016/01/mms1_edp_slow_l2_scpot_20160104000000_v2.7.0.cdf?mms1_edp_psp_slow_l2");
        JOptionPane.showMessageDialog( null, rfp );
        System.err.println(rfp.getSelectedFile());
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        dataSetSelector1 = new org.autoplot.datasource.DataSetSelector();

        jLabel1.setText("Replace references to the file:");

        jLabel2.setText("jLabel2");

        jLabel3.setText("With the new file name:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 470, Short.MAX_VALUE)
            .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(dataSetSelector1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addGap(18, 18, 18)
                .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dataSetSelector1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 169, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.autoplot.datasource.DataSetSelector dataSetSelector1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    // End of variables declaration//GEN-END:variables
}
