/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AddPlotElementDialog.java
 *
 * Created on Apr 6, 2009, 10:54:02 AM
 */

package org.autoplot;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceRegistry;

/**
 *
 * @author jbf
 */
public class TcaElementDialog extends javax.swing.JDialog {

    /** Creates new form AddPlotElementDialog */
    public TcaElementDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
        primaryDataSetSelector.setPlotItButtonVisible(false);
        primaryDataSetSelector.setPlayButton(false); // TODO: did I add the same control twice?
        DefaultComboBoxModel m= new DefaultComboBoxModel();
        m.addElement("Add from...");
        final List<String> ss= DataSetURI.getSortedDiscoverableExtentions();
        for ( String s: ss) {
            if ( !s.equals( "file:" ) ) {
                m.addElement( s.substring(1)+"..." );
            }
        }
        addTicksFromComboBox.setModel(m);
        addTicksFromComboBox.addActionListener( new ActionListener() { 
            @Override
            public void actionPerformed( ActionEvent e ) {
                String s= (String)addTicksFromComboBox.getSelectedItem();
                if ( s.endsWith("...") ) {
                    String ext= s;
                    addTicksFromComboBox.setSelectedIndex(0);
                    primaryDataSetSelector.setValue("vap+"+ext.substring(0,ext.length()-3)+":");
                    primaryDataSetSelector.browseSourceType();
                }
            }
        });
        org.autoplot.bookmarks.Util.loadRecent( "tcaRecent", primaryDataSetSelector, getDefault() );


    }

    private List<Bookmark> getDefault() {
        List<Bookmark> result= new ArrayList();
        result.add( new Bookmark.Item("vap+das2server:http://emfisis.physics.uiowa.edu/das/das2Server?dataset=rbsp/ephemerisA.dsdf&start_time=2012-12-29T00:00:00.000Z&end_time=2012-12-30T00:00:00.000Z&interval=60"));
        result.add( new Bookmark.Item("vap+das2server:http://emfisis.physics.uiowa.edu/das/das2Server?dataset=rbsp/ephemerisB.dsdf&start_time=2012-12-29T00:00:00.000Z&end_time=2012-12-30T00:00:00.000Z&interval=60"));
        return result;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        primaryDataSetSelector = new org.autoplot.datasource.DataSetSelector();
        plotButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        bookmarksButton = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        addTicksFromComboBox = new javax.swing.JComboBox<>();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        plotButton.setText("Ok");
        plotButton.setToolTipText("");
        plotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("Use the dataset to add additional labels to the X-axis:");

        bookmarksButton.setText("Bookmarks...");
        bookmarksButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bookmarksButtonActionPerformed(evt);
            }
        });

        jButton1.setText("Clear Additional Ticks");
        jButton1.setToolTipText("Remove the additional ticks.");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        addTicksFromComboBox.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(bookmarksButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(addTicksFromComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 237, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(jButton1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cancelButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotButton))
                    .add(primaryDataSetSelector, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 685, Short.MAX_VALUE)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 685, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .add(11, 11, 11)
                .add(primaryDataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(plotButton)
                    .add(cancelButton)
                    .add(bookmarksButton)
                    .add(jButton1)
                    .add(addTicksFromComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void plotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotButtonActionPerformed
        cancelled= false;
        setModifiers( evt.getModifiers() );
        setVisible(false);
}//GEN-LAST:event_plotButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false);
}//GEN-LAST:event_cancelButtonActionPerformed

    private void bookmarksButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bookmarksButtonActionPerformed
        BookmarksManager man= new BookmarksManager( (Frame)SwingUtilities.getWindowAncestor(this), true, "Ephemeris Bookmarks" );
        man.setHidePlotButtons(true);
        man.setPrefNode("tca","autoplot.default.tca.bookmarks", "http://autoplot.org/data/tca.demos.xml");
        //man.setPrefNode("tca");
        man.setVisible(true);
        Bookmark book= man.getSelectedBookmark();
        if ( book!=null && book instanceof Bookmark.Item ) {
            primaryDataSetSelector.setValue( ((Bookmark.Item)book).getUri() );
        }
    }//GEN-LAST:event_bookmarksButtonActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        cancelled= false;
        setModifiers(0);
        primaryDataSetSelector.setValue("");
        setVisible(false);
    }//GEN-LAST:event_jButton1ActionPerformed

    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";

    public int getModifiers() {
        return modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }


    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";

    public boolean isCancelled() {
        return cancelled;
    }

    /**
     * @return the primaryDataSetSelector
     */
    public org.autoplot.datasource.DataSetSelector getPrimaryDataSetSelector() {
        return primaryDataSetSelector;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> addTicksFromComboBox;
    private javax.swing.JButton bookmarksButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton plotButton;
    private org.autoplot.datasource.DataSetSelector primaryDataSetSelector;
    // End of variables declaration//GEN-END:variables

}
