/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * VapSchemeChooser.java
 *
 * Created on Jul 21, 2011, 3:52:03 PM
 */

package org.autoplot;

/**
 *
 * @author jbf
 */
public class VapSchemeChooser extends javax.swing.JPanel {

    /** Creates new form VapSchemeChooser */
    public VapSchemeChooser() {
        initComponents();
        if ( "true".equals(System.getProperty("allowEmbedData","true")) ) {
            embedDataCheckBox.setVisible(true);
        } else {
            embedDataCheckBox.setVisible(false);
        }
    }

    /**
     * return the scheme to target.
     * @return 
     */
    public String getScheme() {
        if ( currentVersionCB.isSelected() ) {
            return "";
        } else if ( v1_09CB.isSelected() ) {
            return "1.09";            
        } else {
            new Exception("Selected version not implemented").printStackTrace();
            return "1.08";
        }
    }

    /**
     * return true if the scientist wants to embed data within the vap.
     * @return 
     */
    public boolean isEmbedData() {
        return this.embedDataCheckBox.isSelected();
    }
    
    /**
     * return true if the scientist only wants the local data to be embedded.
     * @return 
     */
    public boolean isOnlyEmbedLocal() {
        return this.onlyEmbedLocalCB.isSelected();
    }
    
    /**
     * return true if the local references to be relative when possible.
     * @return 
     */
    public boolean isLocalPwdReferences() {
        return this.localPwdReferences.isSelected();
    }
            
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        buttonGroup1 = new javax.swing.ButtonGroup();
        currentVersionCB = new javax.swing.JRadioButton();
        embedDataCheckBox = new javax.swing.JCheckBox();
        v1_09CB = new javax.swing.JRadioButton();
        onlyEmbedLocalCB = new javax.swing.JCheckBox();
        localPwdReferences = new javax.swing.JCheckBox();

        buttonGroup1.add(currentVersionCB);
        currentVersionCB.setSelected(true);
        currentVersionCB.setText("Save as current version");
        currentVersionCB.setToolTipText("Save as v1.07 by default.");

        embedDataCheckBox.setText("Embed data within .vap.zip file");
        embedDataCheckBox.setToolTipText("Create zip file containing dom configuration in default.vap, as well as file resources used.");

        buttonGroup1.add(v1_09CB);
        v1_09CB.setText("v1.09 (Autoplot 2017)");

        onlyEmbedLocalCB.setText("Only embed local data");
        onlyEmbedLocalCB.setToolTipText("<html>Only embed data from file references, not data from http or ftp.");

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, embedDataCheckBox, org.jdesktop.beansbinding.ELProperty.create("${selected}"), onlyEmbedLocalCB, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        localPwdReferences.setText("Make local file references relative");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(21, 21, 21)
                        .add(onlyEmbedLocalCB))
                    .add(currentVersionCB)
                    .add(embedDataCheckBox)
                    .add(v1_09CB)
                    .add(localPwdReferences))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(13, 13, 13)
                .add(currentVersionCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(v1_09CB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 82, Short.MAX_VALUE)
                .add(localPwdReferences)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(embedDataCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(onlyEmbedLocalCB))
        );

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton currentVersionCB;
    private javax.swing.JCheckBox embedDataCheckBox;
    private javax.swing.JCheckBox localPwdReferences;
    private javax.swing.JCheckBox onlyEmbedLocalCB;
    private javax.swing.JRadioButton v1_09CB;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

}
