
package org.autoplot.renderer;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;

/**
 *
 * @author jbf
 */
public class DigitalStylePanel extends javax.swing.JPanel implements PlotStylePanel.StylePanel {

    EnumerationEditor ened;
    
    /**
     * Creates new form DigitalStylePanel
     */
    public DigitalStylePanel() {
        initComponents();
        //note the colorPanel must have its layout set to BorderLayout.
        colorEditor1.setValue(Color.BLACK);
        colorPanel.add( colorEditor1.getSmallEditor() );
        ened= new EnumerationEditor();
        ened.setValue( DigitalRenderer.Align.CENTER );
        alignPanel.add( ened.getCustomEditor() );
        ened.addPropertyChangeListener( new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                update();
            }
        });
        colorEditor1.addPropertyChangeListener( new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                update();
            }
        });
        fontSizeCB.setModel( new DefaultComboBoxModel<>( new String[] { "", "0.8em","1.2em","8pt" } ) );
        fontSizeCB.setSelectedItem("");
        validate();
    }

    Renderer renderer;
    BindingGroup elementBindingContext;
        
    private String control = "";

    public static final String PROP_CONTROL = "control";

    public String getControl() {
        return control;
    }


    /**
     * set the control string
     * @param control the control string, e.g. "levels=3,4,5&color=red"
     */
    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        updateGUI(renderer);
        firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String oldValue= this.control;
        Map<String,String> controls= new LinkedHashMap();
        controls.put( "fontSize", (String)fontSizeCB.getSelectedItem() );
        controls.put( "format", formatCB.getSelectedItem().toString().trim() );
        controls.put( Renderer.CONTROL_KEY_COLOR, Renderer.encodeColorControl( (Color)colorEditor1.getValue() ) );
        controls.put( "align", ened.getValue().toString() );
        controls.put( "fillLabel", fillLabelTF.getText() );
        String c= Renderer.formatControl(controls);
        this.control= c;
        firePropertyChange( Renderer.PROP_CONTROL, oldValue, c );
    }
    private void updateGUI( Renderer renderer ) {
        this.control= renderer.getControl();
        fontSizeCB.setSelectedItem( renderer.getControl( "fontSize", "" ) );
        colorEditor1.setValue( renderer.getColorControl( Renderer.CONTROL_KEY_COLOR, Color.BLACK ) );
        formatCB.setSelectedItem( renderer.getControl( "format", "" ) );
        try {
            ened.setValue( DigitalRenderer.Align.valueOf( renderer.getControl( "align", "CENTER" ) ) );
        } catch ( IllegalArgumentException ex ) {
        }
        fillLabelTF.setText( renderer.getControl( "fillLabel", "fill" ) );
    }
    
    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer= element.getController().getRenderer();
        updateGUI( renderer );
        
        BindingGroup bc = new BindingGroup();

        bc.addBinding( Bindings.createAutoBinding( AutoBinding.UpdateStrategy.READ_WRITE, 
                element, BeanProperty.create(  PlotElement.PROP_RENDERCONTROL ), 
                this, BeanProperty.create( Renderer.PROP_CONTROL ) ) );
        
        if ( elementBindingContext!=null ) {
            releaseElementBindings();
        }
        
        bc.bind();
        
        repaint();
        
        elementBindingContext= bc;

    }

    @Override
    public void releaseElementBindings() {
        if ( elementBindingContext!=null ) {
            elementBindingContext.unbind();
            elementBindingContext= null;
        }
        
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        colorEditor1 = new org.das2.components.propertyeditor.ColorEditor();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        colorPanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        alignPanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        fillLabelTF = new javax.swing.JTextField();
        formatCB = new javax.swing.JComboBox<>();
        fontSizeCB = new javax.swing.JComboBox<>();

        setBorder(javax.swing.BorderFactory.createTitledBorder("Digital"));

        jLabel1.setText("Font Size:");
        jLabel1.setToolTipText("Font size relative to the plot font size, like 0.5em means half of the plot's font size.");

        jLabel2.setText("Color:");

        colorPanel.setLayout(new java.awt.BorderLayout());

        jLabel3.setText("Format:");
        jLabel3.setToolTipText("Format specifier like %9.2f");

        jLabel4.setText("Align:");

        alignPanel.setLayout(new java.awt.BorderLayout());

        jLabel5.setText("Fill Label:");
        jLabel5.setToolTipText("Use this text to indicate a fill value");

        fillLabelTF.setText("fill");
        fillLabelTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fillLabelTFActionPerformed(evt);
            }
        });
        fillLabelTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                DigitalStylePanel.this.focusLost(evt);
            }
        });

        formatCB.setEditable(true);
        formatCB.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "%.2f", "%.1E", "%d", "%c", "%x", "%o" }));
        formatCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                formatCBActionPerformed(evt);
            }
        });

        fontSizeCB.setEditable(true);
        fontSizeCB.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "0.8em", "1.2em", "8pt" }));
        fontSizeCB.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                fontSizeCBFocusLost(evt);
            }
        });
        fontSizeCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontSizeCBActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel4)
                            .addComponent(jLabel3)
                            .addComponent(jLabel2))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(alignPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(4, 4, 4))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(colorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addComponent(fontSizeCB, 0, 146, Short.MAX_VALUE)
                            .addComponent(formatCB, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addGap(18, 18, 18)
                        .addComponent(fillLabelTF, javax.swing.GroupLayout.PREFERRED_SIZE, 76, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(2, 2, 2))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel2))
                    .addComponent(colorPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(35, 35, 35))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(fontSizeCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(formatCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(15, 15, 15)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addGap(8, 8, 8))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(alignPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(fillLabelTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addContainerGap(20, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void focusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_focusLost
        update();
    }//GEN-LAST:event_focusLost

    private void fillLabelTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fillLabelTFActionPerformed
        update();
    }//GEN-LAST:event_fillLabelTFActionPerformed

    private void formatCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_formatCBActionPerformed
        update();
    }//GEN-LAST:event_formatCBActionPerformed

    private void fontSizeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontSizeCBActionPerformed
        update();
    }//GEN-LAST:event_fontSizeCBActionPerformed

    private void fontSizeCBFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_fontSizeCBFocusLost
        update();
    }//GEN-LAST:event_fontSizeCBFocusLost


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel alignPanel;
    private org.das2.components.propertyeditor.ColorEditor colorEditor1;
    private javax.swing.JPanel colorPanel;
    private javax.swing.JTextField fillLabelTF;
    private javax.swing.JComboBox<String> fontSizeCB;
    private javax.swing.JComboBox<String> formatCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    // End of variables declaration//GEN-END:variables
}
