
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding.UpdateStrategy;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.autoplot.PlotStylePanel.StylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.PsymConnector;

/**
 *
 * @author faden@cottagesystems.com
 */
public class EventsStylePanel extends javax.swing.JPanel implements StylePanel {

    EnumerationEditor lineEditor;
     
    /**
     * Creates new form EventsStylePanel
     */
    public EventsStylePanel() {
        initComponents();
        colorEditor1= new ColorEditor();
        colorEditor1.setValue(Color.BLACK);
        colorPanel.add( colorEditor1.getSmallEditor() );
        colorEditor1.addPropertyChangeListener((PropertyChangeEvent evt) -> {
            update();
        });
        lineEditor = new EnumerationEditor();
        lineEditor.addPropertyChangeListener((PropertyChangeEvent evt) -> {
            update();
        });
        lineEditor.setValue( PsymConnector.SOLID );
        lineStylePanel.add(lineEditor.getCustomEditor(), BorderLayout.CENTER);
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        showLabelsCB = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        fontSizeTF = new javax.swing.JTextField();
        orbitModeCB = new javax.swing.JCheckBox();
        ganttModeCB = new javax.swing.JCheckBox();
        colorPanel = new javax.swing.JPanel();
        colorCB = new javax.swing.JCheckBox();
        jLabel10 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        lineStylePanel = new javax.swing.JPanel();
        lineThickComboBox = new javax.swing.JComboBox<>();
        opaqueCheckBox = new javax.swing.JCheckBox();

        setBorder(javax.swing.BorderFactory.createTitledBorder("Events Bar"));

        showLabelsCB.setText("Show Labels");
        showLabelsCB.setToolTipText("Show event labels along with bar.");
        showLabelsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showLabelsCBActionPerformed(evt);
            }
        });

        jLabel1.setText("Font Size:");
        jLabel1.setToolTipText("font size like \"16pt\" or where 0.5em is half the size of the parent font.");

        fontSizeTF.setText("1em");
        fontSizeTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                fontSizeTFFocusLost(evt);
            }
        });
        fontSizeTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontSizeTFActionPerformed(evt);
            }
        });

        orbitModeCB.setText("Orbit Mode");
        orbitModeCB.setToolTipText("Show the events in special orbit mode along the bottom with labels.");
        orbitModeCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                orbitModeCBActionPerformed(evt);
            }
        });

        ganttModeCB.setText("Gantt Mode");
        ganttModeCB.setToolTipText("Show events in a Gantt Chart, with instances enumerated along the vertical axis.\n");
        ganttModeCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ganttModeCBActionPerformed(evt);
            }
        });

        colorPanel.setLayout(new java.awt.BorderLayout());

        colorCB.setText("Color:");
        colorCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorCBActionPerformed(evt);
            }
        });

        jLabel10.setText("Line Style:");
        jLabel10.setToolTipText("style of the plot trace, or none");

        jLabel3.setText("Line Thickness:");
        jLabel3.setToolTipText("thickness of the plot trace");

        lineStylePanel.setLayout(new java.awt.BorderLayout());

        lineThickComboBox.setEditable(true);
        lineThickComboBox.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "", "1pt", "0.5em", "1%" }));
        lineThickComboBox.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                lineThickComboBoxFocusLost(evt);
            }
        });
        lineThickComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lineThickComboBoxActionPerformed(evt);
            }
        });

        opaqueCheckBox.setText("Opaque");
        opaqueCheckBox.setToolTipText("By default events are drawn with some transparency, this instead makes them opaque.");
        opaqueCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                opaqueCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(showLabelsCB)
                    .addComponent(orbitModeCB)
                    .addComponent(ganttModeCB)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(colorCB)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(colorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(fontSizeTF, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3)
                            .addComponent(jLabel10)
                            .addComponent(opaqueCheckBox))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lineStylePanel, javax.swing.GroupLayout.PREFERRED_SIZE, 125, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lineThickComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(123, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(showLabelsCB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(fontSizeTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(orbitModeCB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ganttModeCB)
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(colorPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(colorCB, javax.swing.GroupLayout.Alignment.TRAILING))
                .addGap(2, 2, 2)
                .addComponent(opaqueCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(lineStylePanel, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(9, 9, 9)
                        .addComponent(jLabel10)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(lineThickComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(30, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void showLabelsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showLabelsCBActionPerformed
        update();
    }//GEN-LAST:event_showLabelsCBActionPerformed

    private void fontSizeTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontSizeTFActionPerformed
        update();
    }//GEN-LAST:event_fontSizeTFActionPerformed

    private void fontSizeTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_fontSizeTFFocusLost
        update();
    }//GEN-LAST:event_fontSizeTFFocusLost

    private void orbitModeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_orbitModeCBActionPerformed
        if ( orbitModeCB.isSelected() ) ganttModeCB.setSelected(false);
        update();
    }//GEN-LAST:event_orbitModeCBActionPerformed

    private void ganttModeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ganttModeCBActionPerformed
        if ( ganttModeCB.isSelected() ) orbitModeCB.setSelected(false);
        update();
    }//GEN-LAST:event_ganttModeCBActionPerformed

    private void colorCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorCBActionPerformed
        update();
    }//GEN-LAST:event_colorCBActionPerformed

    private void lineThickComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineThickComboBoxActionPerformed
        update();
    }//GEN-LAST:event_lineThickComboBoxActionPerformed

    private void lineThickComboBoxFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_lineThickComboBoxFocusLost
        update();
    }//GEN-LAST:event_lineThickComboBoxFocusLost

    private void opaqueCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_opaqueCheckBoxActionPerformed
        update();
    }//GEN-LAST:event_opaqueCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox colorCB;
    private javax.swing.JPanel colorPanel;
    private javax.swing.JTextField fontSizeTF;
    private javax.swing.JCheckBox ganttModeCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel lineStylePanel;
    private javax.swing.JComboBox<String> lineThickComboBox;
    private javax.swing.JCheckBox opaqueCheckBox;
    private javax.swing.JCheckBox orbitModeCB;
    private javax.swing.JCheckBox showLabelsCB;
    // End of variables declaration//GEN-END:variables

    BindingGroup elementBindingContext;
    
    Renderer renderer;
    ColorEditor colorEditor1;
    
    private String control = "";

    public static final String PROP_CONTROL = "control";

    public String getControl() {
        return control;
    }

    /**
     * set the control string
     * @param control the control string, e.g. "levels=3,4,5&color=red"
     */
    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        updateGUI(renderer);
        firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String oldValue= this.control;
        Map<String,String> controls= new LinkedHashMap();
        controls.put( "fontSize", fontSizeTF.getText() );
        controls.put( "showLabels", Renderer.encodeBooleanControl( showLabelsCB.isSelected() ) );
        controls.put( "orbitMode", Renderer.encodeBooleanControl( orbitModeCB.isSelected() ) );
        controls.put( "ganttMode", Renderer.encodeBooleanControl( ganttModeCB.isSelected() ) );
        controls.put( Renderer.CONTROL_KEY_LINE_STYLE, Renderer.encodePlotSymbolConnectorControl( (PsymConnector) lineEditor.getCellEditorValue() ) );
        controls.put("lineThick", lineThickComboBox.getSelectedItem().toString() );
        if ( colorCB.isSelected() ) {
            controls.put( Renderer.CONTROL_KEY_COLOR, Renderer.encodeColorControl( (Color)colorEditor1.getValue() ) );
        }
        controls.put("opaque", Renderer.encodeBooleanControl( opaqueCheckBox.isSelected() ) );
        String c= Renderer.formatControl(controls);
        this.control= c;
        firePropertyChange( Renderer.PROP_CONTROL, oldValue, c );
    }
    
    private void updateGUI( Renderer renderer ) {
        this.control= renderer.getControl();
        fontSizeTF.setText( renderer.getControl("fontSize", "1em") );
        lineThickComboBox.setSelectedItem( renderer.getControl("lineThick","") );
        lineEditor.setAsText( renderer.getControl( Renderer.CONTROL_KEY_LINE_STYLE, lineEditor.getValue().toString() ) );
        showLabelsCB.setSelected( renderer.getBooleanControl("showLabels", false) );
        orbitModeCB.setSelected( renderer.getBooleanControl("orbitMode", false ) );
        ganttModeCB.setSelected( renderer.getBooleanControl("ganttMode", false ) );
        opaqueCheckBox.setSelected( renderer.getBooleanControl("opaque",false) );
        if ( renderer.hasControl( Renderer.CONTROL_KEY_COLOR ) ) {
            colorCB.setSelected(true);
            colorEditor1.setValue( renderer.getColorControl( Renderer.CONTROL_KEY_COLOR, Color.BLACK ) );
        }
    }
    

       
    @Override
    public void doElementBindings(PlotElement element) {
             this.renderer= element.getController().getRenderer();
        updateGUI( renderer );
        
        BindingGroup bc = new BindingGroup();

        bc.addBinding( Bindings.createAutoBinding( UpdateStrategy.READ_WRITE, 
                element, BeanProperty.create(  PlotElement.PROP_RENDERCONTROL ), 
                this, BeanProperty.create( Renderer.PROP_CONTROL ) ) );
        
        if ( elementBindingContext!=null ) {
            releaseElementBindings();
        }
        
        bc.bind();
        
        repaint();
        
        elementBindingContext= bc;

    }

    @Override
    public void releaseElementBindings() {
        if ( elementBindingContext!=null ) {
            elementBindingContext.unbind();
            elementBindingContext= null;
        }
    }

}
