/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.DasColorBar;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.AutoBinding.UpdateStrategy;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.autoplot.PlotStylePanel.StylePanel;
import org.autoplot.dom.PlotElement;

/**
 *
 * @author faden@cottagesystems.com
 */
public class PitchAngleDistributionStylePanel extends javax.swing.JPanel implements StylePanel {

    /**
     * Creates new form PitchAngleDistributionStylePanel
     */
    public PitchAngleDistributionStylePanel() {
        initComponents();
        edit = new EnumerationEditor();
        edit.setValue( DasColorBar.Type.GRAYSCALE );
        colortableTypePanel.add(edit.getCustomEditor(), BorderLayout.CENTER);
        
    }

    BindingGroup elementBindingContext;
    Renderer renderer;
    EnumerationEditor edit;
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        mirrorCB = new javax.swing.JCheckBox();
        originDL = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        drawPolarAxesCB = new javax.swing.JCheckBox();
        clockwiseCB = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        colortableTypePanel = new javax.swing.JPanel();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Pitch Angle Distribution"));

        mirrorCB.setText("Mirror");
        mirrorCB.setToolTipText("Mirror 0-180 deg to cover all angles");
        mirrorCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mirrorCBActionPerformed(evt);
            }
        });

        originDL.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "East", "South", "West", "North" }));
        originDL.setToolTipText("Direction of 0 degrees");
        originDL.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                originDLItemStateChanged(evt);
            }
        });

        jLabel1.setText("Angle Zero:");
        jLabel1.setToolTipText("The direction from the center of the origin of the angle.");

        drawPolarAxesCB.setText("Draw Polar Axes");
        drawPolarAxesCB.setToolTipText("Draw additional axes at 0,30,60,... degrees.");
        drawPolarAxesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                drawPolarAxesCBActionPerformed(evt);
            }
        });

        clockwiseCB.setText("Clockwise");
        clockwiseCB.setToolTipText("Angles increase in clockwise direction");
        clockwiseCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clockwiseCBActionPerformed(evt);
            }
        });

        jLabel4.setText("Colortable:");
        jLabel4.setToolTipText("Color table for spectrograms");

        colortableTypePanel.setLayout(new java.awt.BorderLayout());

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(colortableTypePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(mirrorCB)
                            .addComponent(drawPolarAxesCB)
                            .addComponent(clockwiseCB)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(originDL, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(0, 107, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(colortableTypePanel, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(mirrorCB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(originDL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(drawPolarAxesCB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(clockwiseCB)
                .addContainerGap(126, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void mirrorCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mirrorCBActionPerformed
        update();
    }//GEN-LAST:event_mirrorCBActionPerformed

    private void originDLItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_originDLItemStateChanged
        if ( evt.getStateChange()==ItemEvent.SELECTED ) {
            update();
        }
    }//GEN-LAST:event_originDLItemStateChanged

    private void drawPolarAxesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_drawPolarAxesCBActionPerformed
        update();
    }//GEN-LAST:event_drawPolarAxesCBActionPerformed

    private void clockwiseCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clockwiseCBActionPerformed
        update();
    }//GEN-LAST:event_clockwiseCBActionPerformed

    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox clockwiseCB;
    private javax.swing.JPanel colortableTypePanel;
    private javax.swing.JCheckBox drawPolarAxesCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox mirrorCB;
    private javax.swing.JComboBox originDL;
    // End of variables declaration//GEN-END:variables

     private void update() {
        String oldValue= this.control;
        Map<String,String> controls= new LinkedHashMap();
        controls.put( "mirror", Renderer.encodeBooleanControl( mirrorCB.isSelected() ) );
        controls.put( "drawPolarAxes", Renderer.encodeBooleanControl( drawPolarAxesCB.isSelected() ) );
        controls.put( "origin", originDL.getSelectedItem().toString().substring(0,1).toUpperCase() );
        controls.put( "clockwise", Renderer.encodeBooleanControl( clockwiseCB.isSelected() ) );
        String c= Renderer.formatControl(controls);
        this.control= c;
        firePropertyChange( Renderer.PROP_CONTROL, oldValue, c );
    }
     
    private void updateGUI( Renderer renderer ) {
        if ( renderer==null ) {
            return; // when I was working on Kris' stuff for AGU 2018
        }
        this.control= renderer.getControl();
        mirrorCB.setSelected( renderer.getBooleanControl( "mirror", false ) );
        drawPolarAxesCB.setSelected( renderer.getBooleanControl( "drawPolarAxes", false ) );
        String s= renderer.getControl("origin", "E" );
        if ( s.equals("E") ) {
            originDL.setSelectedItem("East");
        } else if ( s.equals("S") ) {
            originDL.setSelectedItem("South");   
        } else if ( s.equals("W") ) {
            originDL.setSelectedItem("West");   
        } else if ( s.equals("N") ) {
            originDL.setSelectedItem("North");   
        }
        clockwiseCB.setSelected( renderer.getBooleanControl("clockwise",false) );
    }
    
    private String control;

    public static final String PROP_CONTROL = "control";

    public String getControl() {
        return control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        updateGUI(renderer);
        firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    @Override
    public void doElementBindings(PlotElement element) {
             
        this.renderer= element.getController().getRenderer();
        updateGUI( renderer );
        
        BindingGroup bc = new BindingGroup();

        bc.addBinding( Bindings.createAutoBinding( AutoBinding.UpdateStrategy.READ_WRITE, 
                element, BeanProperty.create(  PlotElement.PROP_RENDERCONTROL ), 
                this, BeanProperty.create( Renderer.PROP_CONTROL ) ) );
        
        bc.addBinding(Bindings.createAutoBinding( UpdateStrategy.READ_WRITE, 
                element.getStyle(), BeanProperty.create( "colortable" ), edit, BeanProperty.create("value")));
        
        if ( elementBindingContext!=null ) {
            releaseElementBindings();
        }
        
        bc.bind();
        
        repaint();
        
        elementBindingContext= bc;

    }

    @Override
    public void releaseElementBindings() {
        if ( elementBindingContext!=null ) {
            elementBindingContext.unbind();
            elementBindingContext= null;
        }        
    }
}
