
package org.autoplot.scriptconsole;

import org.autoplot.AutoplotUI;

/**
 * little panel with "install in tools folder" prompt
 * @author jbf
 */
public class MakeToolPanel extends javax.swing.JPanel {

    /**
     * Creates new form MakeToolPanel
     * @param scriptOkay if true, indicate the scientist has run the script before, otherwise they should check for malicious code.
     */
    public MakeToolPanel(boolean scriptOkay) {
        initComponents();
        //Icon okay= new ImageIcon(MakeToolPanel.class.getResource("/resources/blue.gif"));
        //Icon prob= new ImageIcon(MakeToolPanel.class.getResource("/resources/red.gif"));
        if ( scriptOkay ) {
            trustedScriptLabel.setText("You have run this version of the script before.");
            //trustedScriptLabel.setIcon( okay );
        } else {
            trustedScriptLabel.setText("Make sure the script does not contain malicious code.");
            trustedScriptLabel.setIcon(AutoplotUI.WARNING_ICON);
            //trustedScriptLabel.setIcon( prob );
        }
    }

    /**
     * return true if the script should be added as a tool.
     * @return 
     */
    public boolean isInstall() {
        return toolsCB.isSelected();
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        toolsCB = new javax.swing.JCheckBox();
        trustedScriptLabel = new javax.swing.JLabel();

        toolsCB.setText("Add to Tools menu");
        toolsCB.setToolTipText("The script will be added to the Autoplot \"Tools\" menu");

        trustedScriptLabel.setText("Make sure the script does not contain malicious code.");
        trustedScriptLabel.setToolTipText("<html>Scripts are run with your privileges, so be careful <br>\nto make sure scripts are coming from a trusted source <br>\nand do not contain code that would harm your files.");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(toolsCB))
                    .addComponent(trustedScriptLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 455, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(toolsCB)
                .addGap(11, 11, 11)
                .addComponent(trustedScriptLabel)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox toolsCB;
    private javax.swing.JLabel trustedScriptLabel;
    // End of variables declaration//GEN-END:variables
}
