
package org.autoplot.util;

import java.awt.Component;
import java.text.ParseException;
import javax.swing.JOptionPane;
import org.das2.graph.DasDevicePosition;
import org.das2.util.StringSchemeEditor;

/**
 * for parsing layouts
 * @author jbf
 */
public class LayoutStringSchemeEditor extends javax.swing.JPanel implements StringSchemeEditor {

    /**
     * if true, edit both top and bottom with comma in between.
     */
    boolean both;
    
    /**
     * Creates new form LayoutStringSchemeEditor
     * @param both true, edit both top and bottom
     * @param orient "" "H" or "V" "R", "L", "T" "B" to indicate orientation
     */
    public LayoutStringSchemeEditor(boolean both, String orient) {
        initComponents();
        this.both= both;
        
        if ( !both ) {
            rightBottomPanel.setVisible(false);
            leftTopPositionLabel.setText("Position:");
        }

        if ( orient.length()==1 ) {
            switch (orient) {
                case "H":
                    leftTopPositionLabel.setText("Left Position");
                    rightBottomPositionLabel.setText("Right Position");
                    break;
                case "V":
                    leftTopPositionLabel.setText("Top Position");
                    rightBottomPositionLabel.setText("Bottom Position");
                    break;
                case "T":
                    leftTopPositionLabel.setText("Top Position");
                    break;
                case "B":
                    leftTopPositionLabel.setText("Bottom Position");
                    break;
                case "L":
                    leftTopPositionLabel.setText("Left Position");
                    break;
                case "R":
                    leftTopPositionLabel.setText("Right Position");
                    break;
                default:
                    break;
            }
        }        
        
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of
     * this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel15 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        rightBottomPanel = new javax.swing.JPanel();
        rightBottomPositionLabel = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        bottomRightPercent = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        bottomRightEms = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        bottomRightPx = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        leftTopPositionLabel = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        topLeftPercent = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        topLeftEms = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        topLeftPx = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();

        jLabel15.setText("<html>Das2 positions components using relative positions<br>with offsets in pixels or in ems (the font height).");

        jLabel16.setText("Layout String: ");

        jTextField1.setText("0%,100%+3em");
        jTextField1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextField1FocusLost(evt);
            }
        });

        rightBottomPositionLabel.setText("Right/Bottom Position:");

        jLabel11.setText("Relative to parent:");

        bottomRightPercent.setText("100");
        bottomRightPercent.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                bottomRightPercentFocusLost(evt);
            }
        });

        jLabel12.setText("%");

        jLabel13.setText("Shift additional em-height:");

        bottomRightEms.setText("3");
        bottomRightEms.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                bottomRightEmsFocusLost(evt);
            }
        });

        jLabel14.setText("em");

        jLabel9.setText("Shift additional pixels or points:");
        jLabel9.setToolTipText("Points and pixels are the same right now, but this may change and both are supported.");

        bottomRightPx.setText("0");
        bottomRightPx.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                bottomRightPxFocusLost(evt);
            }
        });

        jLabel10.setText("px");

        javax.swing.GroupLayout rightBottomPanelLayout = new javax.swing.GroupLayout(rightBottomPanel);
        rightBottomPanel.setLayout(rightBottomPanelLayout);
        rightBottomPanelLayout.setHorizontalGroup(
            rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(rightBottomPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(rightBottomPanelLayout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel11)
                            .addComponent(jLabel13)
                            .addComponent(jLabel9)
                            .addGroup(rightBottomPanelLayout.createSequentialGroup()
                                .addGap(12, 12, 12)
                                .addGroup(rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(rightBottomPanelLayout.createSequentialGroup()
                                        .addComponent(bottomRightPercent, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGap(4, 4, 4)
                                        .addComponent(jLabel12))
                                    .addGroup(rightBottomPanelLayout.createSequentialGroup()
                                        .addComponent(bottomRightEms, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jLabel14))
                                    .addGroup(rightBottomPanelLayout.createSequentialGroup()
                                        .addComponent(bottomRightPx, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jLabel10))))))
                    .addComponent(rightBottomPositionLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        rightBottomPanelLayout.setVerticalGroup(
            rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(rightBottomPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rightBottomPositionLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(bottomRightPercent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel12))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(bottomRightEms, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel14))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel9)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(rightBottomPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(bottomRightPx, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel10))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        leftTopPositionLabel.setText("Left/Top Position:");

        jLabel4.setText("%");

        topLeftPercent.setText("0");
        topLeftPercent.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                topLeftPercentFocusLost(evt);
            }
        });
        topLeftPercent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                topLeftPercentActionPerformed(evt);
            }
        });

        jLabel3.setText("Relative to parent:");

        jLabel5.setText("Shift additional em-height:");

        topLeftEms.setText("0");
        topLeftEms.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                topLeftEmsFocusLost(evt);
            }
        });
        topLeftEms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                topLeftEmsActionPerformed(evt);
            }
        });

        jLabel6.setText("em");

        topLeftPx.setText("0");
        topLeftPx.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                topLeftPxFocusLost(evt);
            }
        });

        jLabel7.setText("Shift additional pixels or points:");
        jLabel7.setToolTipText("Points and pixels are the same right now, but this may change and both are supported.");

        jLabel8.setText("px");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel3)
                                    .addComponent(jLabel5)
                                    .addGroup(jPanel2Layout.createSequentialGroup()
                                        .addGap(12, 12, 12)
                                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addComponent(topLeftEms, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(jLabel6))
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addComponent(topLeftPercent, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addGap(4, 4, 4)
                                                .addComponent(jLabel4))
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addComponent(topLeftPx, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(jLabel8)))))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 37, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLabel7, javax.swing.GroupLayout.Alignment.TRAILING)))
                    .addComponent(leftTopPositionLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {topLeftEms, topLeftPercent, topLeftPx});

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(leftTopPositionLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(topLeftPercent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addGap(12, 12, 12)
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(topLeftEms, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(topLeftPx, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8))
                .addContainerGap(24, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rightBottomPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel16)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 305, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel16)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addComponent(rightBottomPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(21, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void topLeftEmsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_topLeftEmsActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_topLeftEmsActionPerformed

    private void jTextField1FocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextField1FocusLost
        parseSpec();
    }//GEN-LAST:event_jTextField1FocusLost

    private void topLeftPercentFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_topLeftPercentFocusLost
        formatSpec();
    }//GEN-LAST:event_topLeftPercentFocusLost

    private void topLeftEmsFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_topLeftEmsFocusLost
        formatSpec();
    }//GEN-LAST:event_topLeftEmsFocusLost

    private void topLeftPxFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_topLeftPxFocusLost
        formatSpec();
    }//GEN-LAST:event_topLeftPxFocusLost

    private void bottomRightPercentFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_bottomRightPercentFocusLost
        formatSpec();
    }//GEN-LAST:event_bottomRightPercentFocusLost

    private void bottomRightEmsFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_bottomRightEmsFocusLost
        formatSpec();
    }//GEN-LAST:event_bottomRightEmsFocusLost

    private void bottomRightPxFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_bottomRightPxFocusLost
        formatSpec();
    }//GEN-LAST:event_bottomRightPxFocusLost

    private void topLeftPercentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_topLeftPercentActionPerformed
        formatSpec();
    }//GEN-LAST:event_topLeftPercentActionPerformed

    private void parseSpec() {
        String[] ss= jTextField1.getText().split(",");
        try {            
            double[] dd= DasDevicePosition.parseLayoutStr(ss[0]);
            if ( dd[0]!=0 || ( dd[1]==0 && dd[2]==0 ) ) {
                topLeftPercent.setText(String.format("%.2f",dd[0]*100));
            }
            if (dd[1]!=0 ) topLeftEms.setText(String.format("%.1f",dd[1]));
            if (dd[2]!=0 ) topLeftPx.setText(String.format("%d",(int)dd[2]));
        } catch (ParseException ex) {
            
        }
        if ( ss.length==2 ) {
            try {
                double[] dd= DasDevicePosition.parseLayoutStr(ss[1]);
                if ( dd[0]!=0 || ( dd[1]==0 && dd[2]==0 ) ) {
                    bottomRightPercent.setText(String.format("%.2f",dd[0]*100));
                }
                if (dd[1]!=0 ) bottomRightEms.setText(String.format("%.1f",dd[1]));
                if (dd[2]!=0 ) bottomRightPx.setText(String.format("%d",(int)dd[2]));
            } catch (ParseException ex) {

            }
        }
    }
    
    private double parseDouble( String spec, double deft ) {
        try {
            return Double.parseDouble( spec );
        } catch ( NumberFormatException ex ) {
            return deft;
        }
    }
    
    private void formatSpec() {
        double [] dd= new double[3];
        dd[0]= parseDouble( topLeftPercent.getText(), 0 )/100.; // Why oh why did I not have this as a percent???
        dd[1]= parseDouble( topLeftEms.getText(), 0 );
        dd[2]= parseDouble( topLeftPx.getText(), 0 );
        String s1= DasDevicePosition.formatLayoutStr( dd );
        if ( both ) {
            dd[0]= parseDouble( bottomRightPercent.getText(), 0 )/100;
            dd[1]= parseDouble( bottomRightEms.getText(), 0 );
            dd[2]= parseDouble( bottomRightPx.getText(), 0 );
            String s2= DasDevicePosition.formatLayoutStr( dd );
            jTextField1.setText( s1 + "," + s2 );
        } else {
            jTextField1.setText( s1 );
        }
    }
    
    @Override
    public void setValue(String v) {
        jTextField1.setText(v);
        parseSpec();
    }

    @Override
    public String getValue() {
        return jTextField1.getText();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setContext(Object o) {
        
    }


    public static void main (String[] args ) {
        LayoutStringSchemeEditor edit= new LayoutStringSchemeEditor(true, "");
        edit.setValue("0%+3em,100%-2em");
        JOptionPane.showMessageDialog( null, edit );
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField bottomRightEms;
    private javax.swing.JTextField bottomRightPercent;
    private javax.swing.JTextField bottomRightPx;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JLabel leftTopPositionLabel;
    private javax.swing.JPanel rightBottomPanel;
    private javax.swing.JLabel rightBottomPositionLabel;
    private javax.swing.JTextField topLeftEms;
    private javax.swing.JTextField topLeftPercent;
    private javax.swing.JTextField topLeftPx;
    // End of variables declaration//GEN-END:variables

    @Override
    public String getLabel() {
        return "Layout String Editor";
    }
}
