/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.parser.DASParser;
import opendap.dap.parser.ParseException;

public class MyDASParser {
    private DAS myDAS;

    public void parse(InputStream in) throws ParseException, DASException {
        DASParser p = new DASParser(in);
        this.myDAS = new DAS();
        p.Attributes(this.myDAS);
    }

    String[] getVariableNames() {
        Enumeration en = this.myDAS.getNames();
        ArrayList<String> result = new ArrayList<String>();
        while (en.hasMoreElements()) {
            result.add(((BaseType)en.nextElement()).getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public DAS getDAS() {
        return this.myDAS;
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("http://acdisc.gsfc.nasa.gov/opendap/HDF-EOS5/Aura_OMI_Level3/OMAEROe.003/2005/OMI-Aura_L3-OMAEROe_2005m0101_v003-2011m1109t081947.he5.dds?TerrainReflectivity");
        MyDASParser parser = new MyDASParser();
        try (InputStream in = url.openStream();){
            parser.parse(in);
        }
    }
}

