/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.binarydatasource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.util.monitor.ProgressMonitor;

public class BinaryDataSourceFormat
extends AbstractDataSourceFormat {
    private ByteBuffer formatRank2(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        String dep0Type;
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        String type = params.get("type");
        if (type == null) {
            type = "double";
        }
        if ((dep0Type = params.get("depend0Type")) == null) {
            dep0Type = "double";
        }
        int dep0Len = dep0 == null ? 0 : 1;
        int typeSize = BufferDataSet.byteCount((Object)type);
        int dep0TypeSize = BufferDataSet.byteCount((Object)dep0Type);
        int recSize = dep0Len * dep0TypeSize + data.length(0) * typeSize;
        int size = data.length() * recSize;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet((int)2, (int)recSize, (int)(dep0Len * dep0TypeSize), (int)data.length(), (int)data.length(0), (int)1, (int)1, (ByteBuffer)result, (Object)type);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        while (it.hasNext()) {
            it.next();
            it.putValue((WritableDataSet)ddata, it.getValue(data));
        }
        if (dep0 != null && dep0.rank() == 1) {
            BufferDataSet ddep0 = BufferDataSet.makeDataSet((int)1, (int)recSize, (int)0, (int)dep0.length(), (int)1, (int)1, (int)1, (ByteBuffer)result, (Object)dep0Type);
            it = new QubeDataSetIterator(dep0);
            while (it.hasNext()) {
                it.next();
                it.putValue((WritableDataSet)ddep0, it.getValue(dep0));
            }
        }
        return result;
    }

    private ByteBuffer formatRank1(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        String dep0Type;
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        String type = params.get("type");
        if (type == null) {
            type = "double";
        }
        if ((dep0Type = params.get("depend0Type")) == null) {
            dep0Type = "double";
        }
        int dep0Len = dep0 == null ? 0 : 1;
        int typeSize = BufferDataSet.byteCount((Object)type);
        int dep0TypeSize = BufferDataSet.byteCount((Object)dep0Type);
        int recSize = dep0Len * dep0TypeSize + typeSize;
        int size = data.length() * recSize;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet((int)1, (int)recSize, (int)(dep0Len * dep0TypeSize), (int)data.length(), (int)1, (int)1, (int)1, (ByteBuffer)result, (Object)type);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        while (it.hasNext()) {
            it.next();
            it.putValue((WritableDataSet)ddata, it.getValue(data));
        }
        if (dep0 != null) {
            BufferDataSet ddep0 = BufferDataSet.makeDataSet((int)1, (int)recSize, (int)0, (int)data.length(), (int)1, (int)1, (int)1, (ByteBuffer)result, (Object)dep0Type);
            it = new QubeDataSetIterator(dep0);
            while (it.hasNext()) {
                it.next();
                it.putValue((WritableDataSet)ddep0, it.getValue(dep0));
            }
        }
        return result;
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        ByteBuffer result;
        super.setUri(uri);
        super.maybeMkdirs();
        String doDep = this.getParam("doDep", "");
        if (doDep.length() > 0 && doDep.toUpperCase().charAt(0) == 'F') {
            MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable((QDataSet)data);
            mpds.putProperty("DEPEND_0", null);
            mpds.putProperty("DEPEND_1", null);
            mpds.putProperty("BUNDLE_1", null);
            data = mpds;
        }
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        switch (data.rank()) {
            case 2: {
                result = this.formatRank2(data, mon, params);
                break;
            }
            case 1: {
                result = this.formatRank1(data, mon, params);
                break;
            }
            default: {
                throw new IllegalArgumentException("rank not supported");
            }
        }
        File outFile = new File(split.resourceUri);
        try (WritableByteChannel channel = Channels.newChannel(new FileOutputStream(outFile));){
            channel.write(result);
        }
    }

    public boolean canFormat(QDataSet ds) {
        return ds.rank() < 3 && ds.rank() != 0 && !SemanticOps.isJoin((QDataSet)ds);
    }

    public String getDescription() {
        return "Binary Table";
    }
}

