/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.das2.util.Entities;
import org.das2.util.awt.PdfGraphicsOutput;

public class FontChooser
extends JPanel {
    private List<String> sizes = Arrays.asList("2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "30", "36", "48", "72");
    public FontCheck defaultFontCheck;
    private FontCheck fontCheck = this.defaultFontCheck = new FontCheck(){

        @Override
        public String checkFont(Font f) {
            String font = PdfGraphicsOutput.ttfFromNameInteractive(f);
            StringBuilder msg = new StringBuilder();
            if (font == "PleaseWait") {
                msg.append("Checking which fonts are embeddable...");
            } else if (font != null) {
                msg.append("PDF okay");
            } else {
                msg.append("Cannot be embedded in PDF");
            }
            char missingCharacter = '\u0000';
            Font t = FontChooser.this.getCurrentFont();
            if (t != null) {
                String text = FontChooser.this.getExampleText();
                for (int i = 0; missingCharacter == '\u0000' && i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\n' || t.canDisplay(c)) continue;
                    missingCharacter = c;
                }
            }
            if (missingCharacter != '\u0000') {
                msg.append(". Missing ").append(missingCharacter).append(" 0x").append(Integer.toHexString(missingCharacter)).append(".");
            }
            return msg.toString();
        }
    };
    private JCheckBox boldCheckBox;
    private JList<String> fontList;
    private JCheckBox italicCheckBox;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel messageLabel;
    private JTextArea sampleTextArea;
    private JList<String> sizesList;

    public FontChooser() {
        this.initComponents();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String item : this.sizes) {
            model.addElement(item);
        }
        this.sizesList.setModel(model);
        this.sizesList.setSelectedIndex(7);
        this.resetFonts();
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                FontChooser.this.sampleTextArea.setFont(FontChooser.this.getCurrentFont());
                if (FontChooser.this.fontCheck != null) {
                    FontChooser.this.updateFontCheck(FontChooser.this.getCurrentFont());
                }
            }
        });
    }

    private void resetFonts() {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String item : fonts) {
            model.addElement(item);
        }
        this.fontList.setModel(model);
        this.fontList.setSelectionMode(0);
    }

    public void setExampleText(String text) {
        this.sampleTextArea.setText(text);
    }

    public String getExampleText() {
        return this.sampleTextArea.getText();
    }

    private void updateFontCheck(Font font) {
        String s;
        String string = s = this.fontCheck == null ? null : this.fontCheck.checkFont(font);
        if (s == null) {
            Timer t = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontChooser.this.updateFontCheck(FontChooser.this.getCurrentFont());
                }
            });
            t.setRepeats(false);
            t.start();
            if (this.messageLabel != null) {
                this.messageLabel.setText("");
            }
        } else if (this.messageLabel != null) {
            this.messageLabel.setText(s);
        }
    }

    public Font getCurrentFont() {
        String fontFamily = this.fontList.getSelectedValue();
        int fontSize = Integer.parseInt(this.sizesList.getSelectedValue());
        int fontType = 0;
        if (this.boldCheckBox.isSelected()) {
            ++fontType;
        }
        if (this.italicCheckBox.isSelected()) {
            fontType += 2;
        }
        return new Font(fontFamily, fontType, fontSize);
    }

    private int roundFontSize(int size) {
        if (size <= 24) {
            size = (size + 1) / 2 * 2;
            return size;
        }
        for (int i = 0; i < this.sizesList.getModel().getSize(); ++i) {
            int ii = Integer.parseInt(this.sizesList.getModel().getElementAt(i));
            if (ii < size) continue;
            return ii;
        }
        return 72;
    }

    public void setCurrentFont(Font f) {
        this.boldCheckBox.setSelected(f.isBold());
        this.italicCheckBox.setSelected(f.isItalic());
        this.sizesList.setSelectedValue(String.valueOf(this.roundFontSize(f.getSize())), true);
        this.sizesList.getSelectedValue();
        this.fontList.setSelectedValue(f.getName(), true);
    }

    public void setFontCheck(FontCheck c) {
        this.fontCheck = c;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.fontList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.sizesList = new JList();
        this.boldCheckBox = new JCheckBox();
        this.italicCheckBox = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.sampleTextArea = new JTextArea();
        this.messageLabel = new JLabel();
        this.fontList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.fontList);
        this.sizesList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.sizesList.setSelectionMode(0);
        this.sizesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooser.this.sizesListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.sizesList);
        this.boldCheckBox.setText("Bold");
        this.boldCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.boldCheckBoxActionPerformed(evt);
            }
        });
        this.italicCheckBox.setText("Italic");
        this.italicCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.italicCheckBoxActionPerformed(evt);
            }
        });
        this.sampleTextArea.setColumns(20);
        this.sampleTextArea.setRows(5);
        this.sampleTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FontChooser.this.sampleTextAreaKeyTyped(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.sampleTextArea);
        this.messageLabel.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.boldCheckBox).addComponent(this.italicCheckBox)).addGap(15, 15, 15)).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2, -1, 204, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.boldCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.italicCheckBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel)));
    }

    private void sampleTextAreaKeyTyped(KeyEvent evt) {
        String raw = this.sampleTextArea.getText();
        String test = Entities.decodeEntities(raw);
        if (test.length() != raw.length()) {
            this.sampleTextArea.setText(test);
        }
        if (this.fontCheck != null) {
            this.fontCheck.checkFont(this.getCurrentFont());
        }
    }

    private void boldCheckBoxActionPerformed(ActionEvent evt) {
        this.updateFont();
    }

    private void italicCheckBoxActionPerformed(ActionEvent evt) {
        this.updateFont();
    }

    private void sizesListValueChanged(ListSelectionEvent evt) {
        this.updateFont();
    }

    private void updateFont() {
        Font f = this.getCurrentFont();
        this.sampleTextArea.setFont(f);
    }

    public static interface FontCheck {
        public String checkFont(Font var1);
    }
}

