/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.das2.util.ColorUtil;
import org.das2.util.DesktopColorChooserPanel;
import org.das2.util.LoggerManager;

public class NamedColorChooserPanel
extends AbstractColorChooserPanel {
    JList l;
    private boolean ignoreChanges = false;
    private static final Logger logger = LoggerManager.getLogger("das2.util");

    @Override
    public void updateChooser() {
        Color c = this.getColorFromModel();
        String s = ColorUtil.nameForColor(c);
        if (!s.startsWith("#")) {
            this.l.setSelectedValue(s, true);
        } else {
            this.l.clearSelection();
            this.l.repaint();
        }
    }

    private static void updateFavorites(String[] ss, JList myFavoritesList) {
        DefaultListModel<String> m2 = new DefaultListModel<String>();
        for (String s : ss) {
            m2.addElement(s);
        }
        myFavoritesList.setModel(m2);
    }

    @Override
    protected void buildChooser() {
        this.l = new JList();
        JList myFavoritesList = new JList();
        Map<String, Color> colors = ColorUtil.getNamedColors();
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (String s : colors.keySet()) {
            m.addElement(s);
        }
        this.l.setModel(m);
        ListCellRenderer r = new ListCellRenderer(){
            JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.label.setText(String.valueOf(value));
                Color cc = ColorUtil.decodeColor((String)value);
                this.label.setIcon(DesktopColorChooserPanel.colorIcon(cc, 24, 16));
                if (isSelected) {
                    this.label.setBackground(list.getSelectionBackground());
                    this.label.setForeground(list.getSelectionForeground());
                    this.label.setOpaque(true);
                } else {
                    this.label.setBackground(list.getBackground());
                    this.label.setForeground(list.getForeground());
                    this.label.setOpaque(false);
                }
                return this.label;
            }
        };
        this.l.setCellRenderer(r);
        this.l.setSelectionMode(0);
        this.l.addListSelectionListener(e -> {
            String colorName = (String)this.l.getSelectedValue();
            if (colorName == null) {
                return;
            }
            this.getColorSelectionModel().setSelectedColor(ColorUtil.decodeColor(colorName));
            if (!this.ignoreChanges) {
                Preferences prefs = Preferences.userNodeForPackage(this.getClass());
                String ps = prefs.get("namedPalette", "black,white,DodgerBlue");
                LinkedList<String> ss = new LinkedList<String>(Arrays.asList(ps.split(",")));
                ss.remove(colorName);
                ss.add(colorName);
                while (ss.remove("null")) {
                    logger.finer("removed null which got into history");
                }
                while (ss.size() > 6) {
                    ss.remove(0);
                }
                prefs.put("namedPalette", String.join((CharSequence)",", ss));
                NamedColorChooserPanel.updateFavorites(ss.toArray(new String[ss.size()]), myFavoritesList);
            }
        });
        this.setLayout(new BorderLayout());
        String ps = Preferences.userNodeForPackage(this.getClass()).get("namedPalette", "black,white,DodgerBlue");
        String[] ss = ps.split(",");
        NamedColorChooserPanel.updateFavorites(ss, myFavoritesList);
        myFavoritesList.setCellRenderer(r);
        myFavoritesList.addListSelectionListener(e -> {
            if (this.ignoreChanges) {
                return;
            }
            String colorName = String.valueOf(myFavoritesList.getSelectedValue());
            if (colorName == null) {
                return;
            }
            this.ignoreChanges = true;
            this.getColorSelectionModel().setSelectedColor(ColorUtil.decodeColor(colorName));
            this.ignoreChanges = false;
        });
        JScrollPane jsp2 = new JScrollPane(myFavoritesList, 20, 30);
        this.add((Component)jsp2, "East");
        JScrollPane jsp = new JScrollPane(this.l, 22, 30);
        this.add((Component)jsp, "Center");
        JButton findClose = new JButton("Find Close Color");
        findClose.setToolTipText("Find closest named color to the currently selected color");
        findClose.setAction(this.getFindCloseAction());
        this.add((Component)findClose, "South");
    }

    private Action getFindCloseAction() {
        return new AbstractAction("find close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map<String, Color> colors = ColorUtil.getNamedColors();
                Color selected = NamedColorChooserPanel.this.getColorFromModel();
                float[] hsv = new float[3];
                Color.RGBtoHSB(selected.getRed(), selected.getGreen(), selected.getBlue(), hsv);
                double distance = Double.MAX_VALUE;
                String bestName = "";
                for (Map.Entry<String, Color> color : colors.entrySet()) {
                    Color c = color.getValue();
                    float[] components = new float[3];
                    Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), components);
                    double dh = Math.abs(components[0] - hsv[0]);
                    if (dh > 0.5) {
                        dh = 1.0 - dh;
                    }
                    dh *= 3.0;
                    double dv = Math.abs(components[2] - hsv[2]);
                    double ds = Math.abs(components[1] - hsv[1]);
                    double d = Math.sqrt(dh * dh + ds * ds + dv * dv);
                    if (!(d < distance)) continue;
                    distance = d;
                    bestName = color.getKey();
                }
                NamedColorChooserPanel.this.getColorSelectionModel().setSelectedColor(colors.get(bestName));
            }
        };
    }

    @Override
    public String getDisplayName() {
        return "Named Colors";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

