/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.text.DecimalFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TimerConsoleFormatter
extends Formatter {
    long t0 = System.currentTimeMillis();
    DecimalFormat nf = new DecimalFormat("00000");
    String lastLoggerName;
    String resetMessage;
    private static final String SPACES = "                                  ";

    @Override
    public String format(LogRecord rec) {
        String message = rec.getMessage();
        if (message != null && this.resetMessage != null && message.contains(this.resetMessage)) {
            this.t0 = System.currentTimeMillis();
        }
        String source = "???";
        StackTraceElement[] st = new Throwable().getStackTrace();
        if (st.length > 8) {
            int idx;
            for (idx = 5; idx < 8 && st[idx].getClassName().contains("java.util.logging.Logger"); ++idx) {
            }
            source = String.valueOf(st[idx].getClassName());
            if (source.startsWith("org.das2") && (source = source.substring("org.das2".length())).length() < SPACES.length()) {
                source = SPACES.substring(source.length()) + source;
            }
        }
        long t = System.currentTimeMillis() - this.t0;
        String threadId = Thread.currentThread().getName();
        threadId = this.fixedColumn(threadId, 20);
        return this.nf.format(t) + ":" + this.fixedColumn(rec.getLoggerName(), 20) + ": " + source + ": " + threadId + ":" + rec.getLevel().getLocalizedName() + ": " + String.valueOf(message) + "\n";
    }

    public void setResetMessage(String msg) {
        this.resetMessage = msg;
    }

    private String fixedColumn(String threadId, int sp) {
        try {
            if (threadId.length() > sp) {
                threadId = threadId.substring(threadId.length() - sp, threadId.length());
            }
            if (threadId.length() < sp) {
                threadId = SPACES.substring(0, sp - threadId.length()) + threadId;
            }
            return threadId;
        }
        catch (StringIndexOutOfBoundsException ex) {
            return threadId;
        }
    }
}

