/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TimingConsoleFormatter
extends Formatter {
    long t0 = System.currentTimeMillis();
    boolean haveReportedTime = false;

    @Override
    public String format(LogRecord rec) {
        char c;
        long dt = System.currentTimeMillis() - this.t0;
        Object[] parms = rec.getParameters();
        String rm1 = rec.getMessage();
        String recMsg = rm1 != null ? (rm1.length() > 1 ? ((c = rm1.charAt(0)) == 'E' ? (rm1.equals("ENTRY {0}") ? "ENTRY " + rec.getSourceClassName() + "." + rec.getSourceMethodName() + " {0}" : (rm1.equals("ENTRY") ? "ENTRY " + rec.getSourceClassName() + "." + rec.getSourceMethodName() : rm1)) : (c == 'R' ? (rm1.equals("RETURN {0}") ? "RETURN " + rec.getSourceClassName() + "." + rec.getSourceMethodName() + " {0}" : (rm1.equals("RETURN") ? "RETURN " + rec.getSourceClassName() + "." + rec.getSourceMethodName() : rm1)) : rm1)) : rec.getMessage()) : null;
        if (parms != null && parms.length > 0) {
            try {
                recMsg = MessageFormat.format(recMsg, parms);
            }
            catch (NullPointerException ex) {
                recMsg = String.valueOf(rec.getMessage());
            }
        }
        if ((recMsg == null || recMsg.length() == 0) && rec.getThrown() != null) {
            recMsg = rec.getThrown().toString();
            rec.getThrown().printStackTrace();
        } else {
            boolean ex = false;
        }
        String st0 = "";
        if (!this.haveReportedTime) {
            st0 = "#logging started at " + new Date(this.t0).toGMTString() + "\n";
            this.haveReportedTime = true;
        }
        return String.format(Locale.US, "%s%9.3f %s: %s\n", st0, (double)dt / 1000.0, rec.getLoggerName(), recMsg);
    }
}

