/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class FTPFileSystem
extends WebFileSystem {
    FTPFileSystem(URI root) {
        super(root, FTPFileSystem.localRoot(root));
    }

    @Override
    public boolean isDirectory(String filename) {
        return filename.endsWith("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] parseLsl(String dir, File listing) throws IOException {
        FileInputStream in = new FileInputStream(listing);
        ArrayList<String> result = new ArrayList<String>(20);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(in));
            String aline = reader.readLine();
            boolean done = aline == null;
            String types = "d-";
            long bytesRead = 0L;
            long sumSize = 0L;
            while (!done) {
                bytesRead = bytesRead + (long)aline.length() + 1L;
                if ((aline = aline.trim()).length() == 0) {
                    done = true;
                    continue;
                }
                char type = aline.charAt(0);
                if (type != 't' || aline.indexOf("total") == 0) {
                    // empty if block
                }
                if (types.indexOf(type) != -1) {
                    int i = aline.lastIndexOf(32);
                    String name = aline.substring(i + 1);
                    boolean isFolder = type == 'd';
                    result.add(name + (isFolder ? "/" : ""));
                }
                done = (aline = reader.readLine()) == null;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] listDirectory(String directory) {
        directory = FTPFileSystem.toCanonicalFolderName(directory);
        try {
            File f = new File(this.localRoot, directory);
            try {
                FileSystemUtil.maybeMkdirs(f);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("unable to mkdirs " + f);
            }
            File listing = new File(this.localRoot, directory + ".listing");
            long ageMilliseconds = Integer.MAX_VALUE;
            if (listing.exists()) {
                ageMilliseconds = listing.lastModified() - System.currentTimeMillis();
            }
            if (this.offline) {
                if (listing.canRead()) {
                    return this.parseLsl(directory, listing);
                }
                return f.list();
            }
            if (!listing.canRead() || ageMilliseconds > 10000L) {
                this.downloadFile(directory, listing, this.getPartFile(listing), new NullProgressMonitor());
            }
            return this.parseLsl(directory, listing);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<String, String> downloadFile(String filename, File targetFile, File partFile, ProgressMonitor monitor) throws IOException {
        FileOutputStream out = null;
        InputStream is = null;
        try {
            filename = FTPFileSystem.toCanonicalFilename(filename);
            URL url = new URL(this.root + filename.substring(1));
            URLConnection urlc = url.openConnection();
            int expectedContentLength = urlc.getContentLength();
            monitor.setTaskSize(expectedContentLength);
            out = new FileOutputStream(partFile);
            loggerUrl.log(Level.FINE, "GET {0}", new Object[]{urlc.getURL()});
            is = urlc.getInputStream();
            monitor.started();
            long totalBytesRead = this.copyStream(is, out, monitor);
            if (totalBytesRead < (long)urlc.getContentLength()) {
                logger.log(Level.WARNING, "fewer bytes downloaded than expected: {0} of {1}", new Object[]{totalBytesRead, expectedContentLength});
            }
            monitor.finished();
            out.close();
            is.close();
            if (!partFile.renameTo(targetFile)) {
                throw new IllegalArgumentException("unable to rename " + partFile + " to " + targetFile);
            }
        }
        catch (IOException e) {
            if (out != null) {
                out.close();
            }
            if (is != null) {
                is.close();
            }
            if (partFile.exists() && !partFile.delete()) {
                throw new IllegalArgumentException("unable to delete " + partFile);
            }
            throw e;
        }
        return Collections.EMPTY_MAP;
    }
}

