/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.monitor.CancelledOperationException;

public final class HttpUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.http.util");
    protected static final Logger loggerUrl = LoggerManager.getLogger("das2.url");
    private static final Map<String, MetadataRecord> cache = Collections.synchronizedMap(new HashMap());

    public static void consumeStream(InputStream err) throws IOException {
        byte[] buf = new byte[8192];
        try {
            if (err != null) {
                int ret = 0;
                while ((ret = err.read(buf)) > 0) {
                }
            }
        }
        finally {
            if (err != null) {
                err.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMetadata(URL url, Map<String, String> props) throws IOException {
        MetadataRecord mr;
        long ageMillis = Long.MAX_VALUE;
        String surl = url.toString();
        Object object = cache;
        synchronized (object) {
            mr = cache.get(surl);
            if (mr != null) {
                ageMillis = System.currentTimeMillis() - mr.birthMilli;
            }
            if (mr != null && ageMillis < 10000L && mr.metadata != null) {
                logger.log(Level.FINE, "using cached metadata for {0}", url);
                return mr.metadata;
            }
            if (mr == null) {
                mr = new MetadataRecord();
                mr.birthMilli = System.currentTimeMillis();
                mr.metadata = null;
                cache.put(surl, mr);
            }
        }
        object = mr;
        synchronized (object) {
            HashMap<String, String> theResult;
            if (mr.metadata != null && (ageMillis = System.currentTimeMillis() - mr.birthMilli) < 10000L) {
                return mr.metadata;
            }
            logger.log(Level.FINE, "reading metadata for {0}", url);
            if (!url.getProtocol().equals("ftp")) {
                String cookie;
                HttpURLConnection connect = (HttpURLConnection)url.openConnection();
                connect.setConnectTimeout(5000);
                connect.setRequestMethod("HEAD");
                try {
                    String encode = KeyChain.getDefault().getUserInfoBase64Encoded(url);
                    if (encode != null) {
                        connect.setRequestProperty("Authorization", "Basic " + encode);
                    }
                }
                catch (CancelledOperationException ex) {
                    logger.log(Level.INFO, "user cancelled auth dialog");
                }
                if (props != null && (cookie = props.get("Cookie")) != null) {
                    connect.setRequestProperty("Cookie", cookie);
                }
                FileSystem.loggerUrl.log(Level.FINE, "HEAD to get metadata: {0}", new Object[]{url});
                connect.connect();
                int responseCode = connect.getResponseCode();
                if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    connect = (HttpURLConnection)HttpUtil.checkRedirect(connect);
                }
                boolean exists = connect.getResponseCode() != 404;
                HashMap<String, String> result = new HashMap<String, String>();
                Map<String, List<String>> fields = connect.getHeaderFields();
                for (Map.Entry<String, List<String>> e : fields.entrySet()) {
                    String key = e.getKey();
                    if (key == null) continue;
                    List<String> value = e.getValue();
                    result.put(key, value.get(0));
                }
                result.put("_ResponseCode", String.valueOf(responseCode));
                result.put("exist", String.valueOf(exists));
                result.put("LastModified", String.valueOf(connect.getLastModified()));
                result.put("ContentLength", String.valueOf(connect.getContentLength()));
                result.put("ContentType", connect.getContentType());
                result.put("ETag", connect.getHeaderField("ETag"));
                logger.log(Level.FINE, "URL: {0}", url);
                logger.log(Level.FINE, "ETag: {0}", connect.getHeaderField("ETag"));
                theResult = result;
            } else {
                HashMap<String, String> result = new HashMap<String, String>();
                URLConnection urlc = url.openConnection();
                try {
                    FileSystem.loggerUrl.log(Level.FINE, "FTP connection: {0}", new Object[]{url});
                    urlc.connect();
                    urlc.getInputStream().close();
                    result.put("exist", "true");
                }
                catch (IOException ex) {
                    result.put("exist", "false");
                }
                theResult = result;
            }
            mr.birthMilli = System.currentTimeMillis();
            mr.metadata = theResult;
            return theResult;
        }
    }

    public static void copyConnectProperties(HttpURLConnection urlc, HttpURLConnection newConnection) {
        String s = urlc.getHeaderField("Referer");
        if (s != null) {
            newConnection.addRequestProperty("Referer", s);
        }
        if ((s = urlc.getHeaderField("Cookie")) != null) {
            newConnection.addRequestProperty("Cookie", s);
        }
        if ((s = urlc.getHeaderField("Accept-Encoding")) != null) {
            newConnection.addRequestProperty("Accept-Encoding", s);
        }
        if ((s = urlc.getHeaderField("Authorization")) != null) {
            newConnection.addRequestProperty("Authorization", s);
        }
        try {
            String requestMethod = urlc.getRequestMethod();
            if (requestMethod != null) {
                newConnection.setRequestMethod(requestMethod);
            }
        }
        catch (ProtocolException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLConnection checkRedirect(URLConnection urlConnection) throws IOException {
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)urlConnection;
            huc.setInstanceFollowRedirects(true);
            huc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
            huc.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
            loggerUrl.log(Level.FINEST, "getResponseCode {0}", urlConnection.getURL());
            int responseCode = huc.getResponseCode();
            if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                String newUrl = huc.getHeaderField("Location");
                if (responseCode == 301) {
                    if ("true".equals(System.getProperty("log_redirects"))) {
                        File localCache = FileSystem.settings().getLocalCacheDir();
                        File redirectLog = new File(localCache, "redirect.log");
                        TimeZone tz = TimeZone.getTimeZone("UTC");
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
                        df.setTimeZone(tz);
                        String nowAsISO = df.format(new Date());
                        File file = redirectLog;
                        synchronized (file) {
                            try (BufferedWriter write = new BufferedWriter(new FileWriter(redirectLog, true));){
                                write.append(nowAsISO);
                                write.append(" ");
                                write.append(urlConnection.getURL().toExternalForm());
                                write.append(" ");
                                write.append(newUrl);
                                write.newLine();
                            }
                        }
                    }
                    logger.log(Level.INFO, "URL {0} permanently moved to {1}", new Object[]{urlConnection.getURL(), newUrl});
                } else {
                    loggerUrl.log(Level.FINE, "{0} redirect to {1}", new Object[]{responseCode, newUrl});
                }
                HttpURLConnection newUrlConnection = (HttpURLConnection)new URL(newUrl).openConnection();
                HttpUtil.copyConnectProperties(huc, newUrlConnection);
                newUrlConnection.addRequestProperty("Referer", urlConnection.getURL().toString());
                ((HttpURLConnection)urlConnection).disconnect();
                urlConnection = newUrlConnection;
            }
            return urlConnection;
        }
        return urlConnection;
    }

    private static class MetadataRecord {
        Map<String, String> metadata;
        long birthMilli;

        private MetadataRecord() {
        }
    }
}

