/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileObject;
import org.das2.util.filesystem.URIException;

public class LocalFileSystem
extends FileSystem {
    File localRoot;

    protected LocalFileSystem(URI root) throws FileSystem.FileSystemOfflineException, FileNotFoundException {
        super(root);
        if (!"file".equals(root.getScheme())) {
            throw new IllegalArgumentException("protocol not file: " + root);
        }
        String surl = root.getPath();
        if (surl == null) {
            throw new URIException("root contains no path: " + root);
        }
        if (!surl.endsWith("/")) {
            surl = surl + "/";
        }
        if (surl.startsWith("file://") && !surl.startsWith("file:///")) {
            throw new URIException("Local file URLs should start with file:/ or file:///, but not file:// " + surl);
        }
        String[] split = FileSystem.splitUrl(surl);
        this.localRoot = new File(split[2].substring(split[0].length()));
        if (!this.localRoot.exists()) {
            File[] roots = File.listRoots();
            if (Arrays.asList(roots).contains(this.localRoot)) {
                throw new FileSystem.FileSystemOfflineException();
            }
            throw new FileNotFoundException("local root does not exist: " + this.localRoot);
        }
        boolean b = new File("xxx").equals(new File("XXX"));
        this.properties.put("caseInsensitive", b);
    }

    @Override
    public boolean isDirectory(String filename) {
        return new File(this.localRoot, filename).isDirectory();
    }

    String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    @Override
    public String[] listDirectory(String directory) {
        File f = new File(this.localRoot, directory);
        if (!f.canRead() || f.getParentFile() != null && f.isHidden()) {
            throw new IllegalArgumentException("cannot read directory " + f);
        }
        File[] files = f.listFiles();
        if (files == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            if (file.isHidden()) continue;
            result.add(file.getName() + (file.isDirectory() ? "/" : ""));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] listDirectory(String directory, String regex) {
        File f = new File(this.localRoot, directory);
        Pattern pattern = Pattern.compile(regex);
        if (!f.canRead() || f.getParentFile() != null && f.isHidden()) {
            throw new IllegalArgumentException("cannot read directory " + f);
        }
        File[] files = f.listFiles((file, name) -> pattern.matcher(name).matches() && !file.isHidden());
        if (files == null) {
            throw new IllegalStateException("unable to list directory: " + f);
        }
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getName() + (files[i].isDirectory() ? "/" : "");
        }
        return result;
    }

    public String toString() {
        String s = String.valueOf(this.localRoot);
        if (!(s = s.replaceAll("\\\\", "/")).endsWith("/")) {
            s = s + "/";
        }
        return "lfs " + s;
    }

    @Override
    public FileObject getFileObject(String filename) {
        return new LocalFileObject(this, this.localRoot, filename);
    }

    @Override
    public File getLocalRoot() {
        return this.localRoot;
    }
}

