/*
 * Decompiled with CFR 0.152.
 */
package org.hapiserver;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.hapi.HapiDataSource;
import org.das2.util.filesystem.FileSystem;
import org.hapiserver.HapiClientIterator;
import org.hapiserver.HapiRecord;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HapiClient {
    private static final Logger LOGGER = Logger.getLogger("org.hapiserver");
    private static final Lock LOCK = new ReentrantLock();
    private static final int[][] DAYS_IN_MONTH = new int[][]{{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}, {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}};
    private static final int[][] DAY_OFFSET = new int[][]{{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365}, {0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366}};

    private HapiClient() {
    }

    protected static boolean useCache() {
        return "true".equals(System.getProperty("hapiServerCache", "false"));
    }

    protected static long cacheAgeLimitMillis() {
        return 3600000L;
    }

    public static String readFromFile(File f) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
            String line = in.readLine();
            while (line != null) {
                builder.append(line);
                builder.append("\n");
                line = in.readLine();
            }
        }
        if (builder.length() == 0) {
            throw new IOException("file is empty:" + f);
        }
        String result = builder.toString();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFromCachedURL(URL url, String type) throws IOException {
        String su;
        File f;
        String hapiCache = HapiDataSource.getHapiCache();
        String u = url.getProtocol() + "/" + url.getHost() + "/" + url.getPath();
        if (url.getQuery() != null) {
            Pattern p = Pattern.compile("id=(.+)");
            Matcher m = p.matcher(url.getQuery());
            if (!m.matches()) throw new IllegalArgumentException("query not supported, implementation error");
            u = u + "/" + m.group(1);
            if (type.length() > 0) {
                u = u + "." + type;
            }
        } else if (type.length() > 0) {
            u = u + "." + type;
        }
        if (!(f = new File(su = hapiCache + u)).exists()) return null;
        if (!f.canRead()) return null;
        if (System.currentTimeMillis() - f.lastModified() < HapiClient.cacheAgeLimitMillis() || FileSystem.settings().isOffline()) {
            LOGGER.log(Level.FINE, "read from hapi cache: {0}", url);
            return HapiClient.readFromFile(f);
        }
        LOGGER.log(Level.FINE, "old cache item will not be used: {0}", url);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeToCachedURL(URL url, String type, String data) throws IOException {
        String su;
        File f;
        String hapiCache = HapiDataSource.getHapiCache();
        String u = url.getProtocol() + "/" + url.getHost() + "/" + url.getPath();
        String q = url.getQuery();
        if (q != null) {
            Pattern p;
            Matcher m;
            if (q.contains("resolve_references=false&")) {
                q = q.replace("resolve_references=false&", "");
            }
            if (!(m = (p = Pattern.compile("id=(.+)")).matcher(q)).matches()) throw new IllegalArgumentException("query not supported, implementation error");
            u = u + "/" + m.group(1);
            if (type.length() > 0) {
                u = u + "." + type;
            }
        } else if (type.length() > 0) {
            u = u + "." + type;
        }
        if ((f = new File(su = hapiCache + u)).exists() && !f.delete()) {
            throw new IOException("unable to delete file " + f);
        }
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new IOException("unable to make parent directories");
        }
        if (f.exists()) throw new IOException("unable to write to file: " + f);
        LOGGER.log(Level.FINE, "write to hapi cache: {0}", url);
        try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
            w.write(data);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromURL(URL url, String type) throws IOException {
        String s;
        if (FileSystem.settings().isOffline() && (s = HapiClient.readFromCachedURL(url, type)) != null) {
            return s;
        }
        LOGGER.log(Level.FINE, "GET {0}", new Object[]{url});
        URLConnection urlc = url.openConnection();
        urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        urlc.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));){
            String line = in.readLine();
            while (line != null) {
                builder.append(line);
                builder.append("\n");
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            if (urlc instanceof HttpURLConnection) {
                StringBuilder builder2 = new StringBuilder();
                try (BufferedReader in2 = new BufferedReader(new InputStreamReader(((HttpURLConnection)urlc).getErrorStream()));){
                    String line = in2.readLine();
                    while (line != null) {
                        builder2.append(line);
                        builder2.append("\n");
                        line = in2.readLine();
                    }
                    String s2 = builder2.toString().trim();
                    if (type.equals("json") && s2.length() > 0 && s2.charAt(0) == '{') {
                        LOGGER.warning("incorrect error code returned, content is JSON");
                        String string = s2;
                        return string;
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.FINE, ex2.getMessage(), ex2);
                }
            }
            LOGGER.log(Level.FINE, ex.getMessage(), ex);
            LOCK.lock();
            try {
                if (!HapiClient.useCache()) throw ex;
                String s2 = HapiClient.readFromCachedURL(url, type);
                if (s2 != null) {
                    String string = s2;
                    return string;
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        if (builder.length() == 0) {
            throw new IOException("empty response from " + url);
        }
        String result = builder.toString();
        LOCK.lock();
        try {
            if (!HapiClient.useCache()) return result;
            HapiClient.writeToCachedURL(url, type, result);
            return result;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static JSONObject getCatalog(URL server) throws IOException, JSONException {
        if (EventQueue.isDispatchThread()) {
            LOGGER.warning("HAPI network call on event thread");
        }
        URL url = new URL(server, "catalog");
        String s = HapiClient.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        return o;
    }

    public static String[] getCatalogIdsArray(URL server) throws IOException, JSONException {
        JSONObject jo = HapiClient.getCatalog(server);
        JSONArray joa = jo.getJSONArray("catalog");
        String[] result = new String[joa.length()];
        for (int i = 0; i < joa.length(); ++i) {
            result[i] = joa.getJSONObject(i).getString("id");
        }
        return result;
    }

    public static JSONObject getInfo(URL server, String id) throws IOException, JSONException {
        URL url;
        if (EventQueue.isDispatchThread()) {
            LOGGER.warning("HAPI network call on event thread");
        }
        try {
            url = new URL(server, "info?id=" + id);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        String s = HapiClient.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        return o;
    }

    public static JSONObject getInfo(URL server, String id, String parameters) throws IOException, JSONException {
        URL url;
        if (EventQueue.isDispatchThread()) {
            LOGGER.warning("HAPI network call on event thread");
        }
        try {
            url = new URL(server, "info?id=" + id + "&parameters=" + parameters);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        String s = HapiClient.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        String[] ss = parameters.split(",", -2);
        JSONArray joa = o.getJSONArray("parameters");
        if (ss.length == joa.length() || ss.length == joa.length() - 1) {
            int ioff = joa.length() - ss.length;
            StringBuilder sb = new StringBuilder(joa.getJSONObject(ioff).getString("name"));
            for (int i = 1 + ioff; i < joa.length(); ++i) {
                sb.append(",").append(joa.getJSONObject(i).get("name"));
            }
            String sbs = sb.toString();
            if (!sbs.equals(parameters)) {
                throw new IllegalArgumentException("parameters must be requested in order, use instead " + sbs);
            }
        } else {
            throw new IllegalArgumentException("number of parameters in result doesn't jibe with request");
        }
        return o;
    }

    public static String[] getInfoParametersArray(URL server, String id) throws IOException, JSONException {
        JSONObject jo = HapiClient.getInfo(server, id);
        JSONArray joa = jo.getJSONArray("parameters");
        String[] result = new String[joa.length()];
        for (int i = 0; i < joa.length(); ++i) {
            result[i] = joa.getJSONObject(i).getString("name");
        }
        return result;
    }

    public static Iterator<HapiRecord> getDataCSV(URL server, String id, String startTime, String endTime) throws IOException, JSONException {
        JSONObject info = HapiClient.getInfo(server, id);
        URL dataURL = info.getString("HAPI").startsWith("3.") ? new URL(server, "data?id=" + id + "&start=" + startTime + "&stop=" + endTime) : new URL(server, "data?id=" + id + "&time.min=" + startTime + "&time.max=" + endTime);
        InputStream ins = dataURL.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        return new HapiClientIterator(info, reader);
    }

    public static Iterator<HapiRecord> getDataCSV(URL server, String id, String parameters, String startTime, String endTime) throws IOException, JSONException {
        JSONObject info = HapiClient.getInfo(server, id, parameters);
        URL dataURL = new URL(server, "data?id=" + id + "&parameters=" + parameters + "&time.min=" + startTime + "&time.max=" + endTime);
        InputStream ins = dataURL.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        return new HapiClientIterator(info, reader);
    }

    public static Iterator<HapiRecord> getData(URL server, String id, String startTime, String endTime) throws IOException, JSONException {
        return HapiClient.getDataCSV(server, id, startTime, endTime);
    }

    public static Iterator<HapiRecord> getData(URL server, String id, String parameters, String startTime, String endTime) throws IOException, JSONException {
        return HapiClient.getDataCSV(server, id, parameters, startTime, endTime);
    }

    public static long toMillisecondsSince1970(String time) {
        TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(time);
        Instant i = Instant.from(ta);
        Date d = Date.from(i);
        return d.getTime();
    }

    private static int parseInt(String s) {
        switch (s.length()) {
            case 2: {
                int result = 10 * (s.charAt(0) - 48) + (s.charAt(1) - 48);
                return result;
            }
            case 3: {
                int result = 100 * (s.charAt(0) - 48) + 10 * (s.charAt(1) - 48) + (s.charAt(2) - 48);
                return result;
            }
        }
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            result = 10 * result + (s.charAt(i) - 48);
        }
        return result;
    }

    private static boolean isLeapYear(int year) {
        if (year < 1800 || year > 2400) {
            throw new IllegalArgumentException("year must be between 1800 and 2400");
        }
        return year % 4 == 0 && (year % 400 == 0 || year % 100 != 0);
    }

    public static int dayOfYear(int year, int month, int day) {
        if (month == 1) {
            return day;
        }
        if (month < 1) {
            throw new IllegalArgumentException("month must be greater than 0.");
        }
        if (month > 12) {
            throw new IllegalArgumentException("month must be less than 12.");
        }
        int leap = HapiClient.isLeapYear(year) ? 1 : 0;
        return DAY_OFFSET[leap][month] + day;
    }

    private static void normalizeTime(int[] time) {
        if (time[3] == 24) {
            time[2] = time[2] + 1;
            time[3] = 0;
        }
        if (time[3] > 24) {
            throw new IllegalArgumentException("time[3] is greater than 24 (hours)");
        }
        if (time[1] > 12) {
            throw new IllegalArgumentException("time[1] is greater than 12 (months)");
        }
        int leap = HapiClient.isLeapYear(time[0]) ? 1 : 0;
        int d = DAYS_IN_MONTH[leap][time[1]];
        while (time[2] > d) {
            time[1] = time[1] + 1;
            time[2] = time[2] - d;
            d = DAYS_IN_MONTH[leap][time[1]];
            if (time[1] <= 12) continue;
            throw new IllegalArgumentException("time[2] is too big");
        }
    }

    public static int[] isoTimeToArray(String time) {
        int[] result;
        if (time.length() == 4) {
            result = new int[]{Integer.parseInt(time), 1, 1, 0, 0, 0, 0};
        } else {
            if (time.length() < 8) {
                throw new IllegalArgumentException("time must have 4 or greater than 7 elements");
            }
            if (time.charAt(8) == 'T') {
                result = new int[]{HapiClient.parseInt(time.substring(0, 4)), 1, HapiClient.parseInt(time.substring(5, 8)), 0, 0, 0, 0};
                time = time.substring(9);
            } else {
                result = new int[]{HapiClient.parseInt(time.substring(0, 4)), HapiClient.parseInt(time.substring(5, 7)), HapiClient.parseInt(time.substring(8, 10)), 0, 0, 0, 0};
                time = time.substring(11);
            }
            if (time.endsWith("Z")) {
                time = time.substring(0, time.length() - 1);
            }
            if (time.length() >= 2) {
                result[3] = HapiClient.parseInt(time.substring(0, 2));
            }
            if (time.length() >= 5) {
                result[4] = HapiClient.parseInt(time.substring(3, 5));
            }
            if (time.length() >= 8) {
                result[5] = HapiClient.parseInt(time.substring(6, 8));
            }
            if (time.length() > 9) {
                result[6] = (int)Math.pow(10.0, 18 - time.length()) * HapiClient.parseInt(time.substring(9));
            }
            HapiClient.normalizeTime(result);
        }
        return result;
    }
}

