/*
 * Decompiled with CFR 0.152.
 */
package org.hapiserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hapiserver.CSVHapiRecordConverter;
import org.hapiserver.HapiRecord;
import org.json.JSONException;
import org.json.JSONObject;

public class HapiClientIterator
implements Iterator<HapiRecord> {
    String nextLine;
    JSONObject info;
    BufferedReader reader;
    CSVHapiRecordConverter converter;

    public HapiClientIterator(JSONObject info, BufferedReader reader) throws IOException, JSONException {
        this.info = info;
        this.reader = reader;
        this.nextLine = this.reader.readLine();
        this.converter = new CSVHapiRecordConverter(info);
    }

    @Override
    public boolean hasNext() {
        boolean result = this.nextLine != null;
        return result;
    }

    @Override
    public HapiRecord next() {
        if (this.nextLine == null) {
            throw new NoSuchElementException("No more records");
        }
        HapiRecord result = this.converter.convert(this.nextLine);
        try {
            this.nextLine = this.reader.readLine();
            if (this.nextLine == null) {
                this.reader.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return result;
    }
}

