/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFHuffman;

public class CDFAHuffman
extends CDFHuffman {
    Tree tree = new Tree();

    public CDFAHuffman() {
        for (int i = 0; i < this.tree.nodes.length; ++i) {
            this.tree.nodes[i] = new Node();
        }
    }

    public byte[] compress(byte[] input, long iSize) {
        byte[] output = new byte[10 * (int)iSize];
        this.initializeTree();
        int i = 0;
        while ((long)i < iSize) {
            byte c = input[i];
            this.encodeSymbol(c);
            this.updateModel(c);
            ++i;
        }
        this.encodeSymbol(256);
        this.endOutputBitFile();
        byte[] noutput = new byte[this.oByteN];
        System.arraycopy(output, 0, noutput, 0, this.oByteN);
        return noutput;
    }

    @Override
    public byte[] decompress(byte[] input, int oSize) {
        int c;
        this.output = new byte[oSize];
        this.iByteN = 0;
        this.oByteN = 0;
        this.input = input;
        this.iSize = input.length;
        this.initializeTree();
        while ((c = this.decodeSymbol()) != 256) {
            if (c == -1) {
                return null;
            }
            this.output[this.oByteN] = (byte)c;
            ++this.oByteN;
            this.updateModel(c);
        }
        return this.output;
    }

    @Override
    void output_counts() {
        int first;
        int last = 0;
        for (first = 0; first < 255 && this.tnodes[first].count == 0; ++first) {
        }
        while (first < 256) {
            int next;
            last = first + 1;
            while (true) {
                if (last < 256 && this.tnodes[last].count != 0) {
                    ++last;
                    continue;
                }
                for (next = --last + 1; next < 256 && this.tnodes[next].count == 0; ++next) {
                }
                if (next > 255 || next - last > 3) break;
                last = next;
            }
            this.output[this.oByteN] = (byte)first;
            ++this.oByteN;
            this.output[this.oByteN] = (byte)last;
            ++this.oByteN;
            for (int i = first; i <= last; ++i) {
                this.output[this.oByteN] = (byte)this.tnodes[i].count;
                ++this.oByteN;
            }
            first = next;
        }
        this.output[this.oByteN] = 0;
        ++this.oByteN;
    }

    void endOutputBitFile() {
        if (this.bit_file.mask != 128) {
            this.output[this.oByteN] = (byte)this.bit_file.rack;
            ++this.oByteN;
        }
    }

    @Override
    void outputBits(long code, int count) {
        for (long mask = (long)(1 << count - 1); mask != 0L; mask >>= 1) {
            if ((mask & code) != 0L) {
                this.bit_file.rack |= this.bit_file.mask;
            }
            this.bit_file.mask = (short)(this.bit_file.mask >> 1);
            if (this.bit_file.mask != 0) continue;
            this.output[this.oByteN] = (byte)this.bit_file.rack;
            ++this.oByteN;
            this.bit_file.rack = 0;
            this.bit_file.mask = (short)128;
        }
    }

    @Override
    int inputBit() {
        if (this.bit_file.mask == 128) {
            this.bit_file.rack = this.input[this.iByteN] >= 0 ? this.input[this.iByteN] : 256 + this.input[this.iByteN];
            ++this.iByteN;
            if (this.bit_file.rack == -1) {
                return -1;
            }
        }
        int value = this.bit_file.rack & this.bit_file.mask;
        this.bit_file.mask = (short)(this.bit_file.mask >> 1);
        if (this.bit_file.mask == 0) {
            this.bit_file.mask = (short)128;
        }
        return value != 0 ? 1 : 0;
    }

    long inputBits(int bit_count) {
        long mask = 1L << bit_count - 1;
        long return_value = 0L;
        while (mask != 0L) {
            if (this.bit_file.mask == 128) {
                this.bit_file.rack = this.input[this.iByteN] >= 0 ? this.input[this.iByteN] : 256 + this.input[this.iByteN];
                ++this.iByteN;
                if (this.bit_file.rack == -1) {
                    return -1L;
                }
            }
            if ((this.bit_file.rack & this.bit_file.mask) != 0) {
                return_value |= mask;
            }
            mask >>= 1;
            this.bit_file.mask = (short)(this.bit_file.mask >> 1);
            if (this.bit_file.mask != 0) continue;
            this.bit_file.mask = (short)128;
        }
        return return_value;
    }

    void initializeTree() {
        this.tree.nodes[0].child = 1;
        this.tree.nodes[0].child_is_leaf = false;
        this.tree.nodes[0].weight = 2;
        this.tree.nodes[0].parent = -1;
        this.tree.nodes[1].child = 256;
        this.tree.nodes[1].child_is_leaf = true;
        this.tree.nodes[1].weight = 1;
        this.tree.nodes[1].parent = 0;
        this.tree.leaf[256] = 1;
        this.tree.nodes[2].child = 257;
        this.tree.nodes[2].child_is_leaf = true;
        this.tree.nodes[2].weight = 1;
        this.tree.nodes[2].parent = 0;
        this.tree.leaf[257] = 2;
        this.tree.next_free_node = 3;
        for (int i = 0; i < 256; ++i) {
            this.tree.leaf[i] = -1;
        }
    }

    void encodeSymbol(int c) {
        long code = 0L;
        long current_bit = 1L;
        int code_size = 0;
        int current_node = this.tree.leaf[c];
        if (current_node == -1) {
            current_node = this.tree.leaf[257];
        }
        while (current_node != 0) {
            if ((current_node & 1) == 0) {
                code |= current_bit;
            }
            current_bit <<= 1;
            ++code_size;
            current_node = this.tree.nodes[current_node].parent;
        }
        this.outputBits(code, code_size);
        if (this.tree.leaf[c] == -1) {
            this.outputBits(c, 8);
            this.add_new_node(c);
        }
    }

    int decodeSymbol() {
        int current_node = 0;
        while (!this.tree.nodes[current_node].child_is_leaf) {
            current_node = this.tree.nodes[current_node].child;
            int bit = this.inputBit();
            if (bit == -1) {
                return -1;
            }
            current_node += bit;
        }
        int c = this.tree.nodes[current_node].child;
        if (c == 257) {
            c = (int)this.inputBits(8);
            if (c == -1) {
                return -1;
            }
            this.add_new_node(c);
        }
        return c;
    }

    void updateModel(int c) {
        if (this.tree.nodes[0].weight == 32768) {
            this.rebuildTree();
        }
        int current_node = this.tree.leaf[c];
        while (current_node != -1) {
            int new_node;
            ++this.tree.nodes[current_node].weight;
            for (new_node = current_node; new_node > 0 && this.tree.nodes[new_node - 1].weight < this.tree.nodes[current_node].weight; --new_node) {
            }
            if (current_node != new_node) {
                this.swap_nodes(current_node, new_node);
                current_node = new_node;
            }
            current_node = this.tree.nodes[current_node].parent;
        }
    }

    void rebuildTree() {
        int k;
        int j;
        int i;
        for (i = j = this.tree.next_free_node - 1; i >= 0; --i) {
            if (!this.tree.nodes[i].child_is_leaf) continue;
            this.tree.nodes[j].parent = this.tree.nodes[i].parent;
            this.tree.nodes[j].child = this.tree.nodes[i].child;
            this.tree.nodes[j].child_is_leaf = this.tree.nodes[i].child_is_leaf;
            this.tree.nodes[j].weight = this.tree.nodes[i].weight;
            this.tree.nodes[j].weight = (this.tree.nodes[j].weight + 1) / 2;
            --j;
        }
        i = this.tree.next_free_node - 2;
        while (j >= 0) {
            k = i + 1;
            int weight = this.tree.nodes[j].weight = this.tree.nodes[i].weight + this.tree.nodes[k].weight;
            this.tree.nodes[j].child_is_leaf = false;
            k = j + 1;
            while (weight < this.tree.nodes[k].weight) {
                ++k;
            }
            --k;
            for (int ix = 0; ix < k - j; ++ix) {
                this.tree.nodes[j + ix].weight = this.tree.nodes[j + ix + 1].weight;
                this.tree.nodes[j + ix].parent = this.tree.nodes[j + ix + 1].parent;
                this.tree.nodes[j + ix].child_is_leaf = this.tree.nodes[j + ix + 1].child_is_leaf;
                this.tree.nodes[j + ix].child = this.tree.nodes[j + ix + 1].child;
            }
            this.tree.nodes[k].weight = weight;
            this.tree.nodes[k].child = i;
            this.tree.nodes[k].child_is_leaf = false;
            i -= 2;
            --j;
        }
        for (i = this.tree.next_free_node - 1; i >= 0; --i) {
            if (this.tree.nodes[i].child_is_leaf) {
                k = this.tree.nodes[i].child;
                this.tree.leaf[k] = i;
                continue;
            }
            k = this.tree.nodes[i].child;
            this.tree.nodes[k].parent = this.tree.nodes[k + 1].parent = i;
        }
    }

    void swap_nodes(int i, int j) {
        if (this.tree.nodes[i].child_is_leaf) {
            this.tree.leaf[this.tree.nodes[i].child] = j;
        } else {
            this.tree.nodes[this.tree.nodes[i].child].parent = j;
            this.tree.nodes[this.tree.nodes[i].child + 1].parent = j;
        }
        if (this.tree.nodes[j].child_is_leaf) {
            this.tree.leaf[this.tree.nodes[j].child] = i;
        } else {
            this.tree.nodes[this.tree.nodes[j].child].parent = i;
            this.tree.nodes[this.tree.nodes[j].child + 1].parent = i;
        }
        Node temp = new Node();
        temp.child = this.tree.nodes[i].child;
        temp.weight = this.tree.nodes[i].weight;
        temp.child_is_leaf = this.tree.nodes[i].child_is_leaf;
        this.tree.nodes[i].weight = this.tree.nodes[j].weight;
        this.tree.nodes[i].child = this.tree.nodes[j].child;
        this.tree.nodes[i].child_is_leaf = this.tree.nodes[j].child_is_leaf;
        this.tree.nodes[j].weight = temp.weight;
        this.tree.nodes[j].child = temp.child;
        this.tree.nodes[j].child_is_leaf = temp.child_is_leaf;
    }

    void add_new_node(int c) {
        int lightest_node = this.tree.next_free_node - 1;
        int new_node = this.tree.next_free_node;
        int zero_weight_node = this.tree.next_free_node + 1;
        this.tree.next_free_node += 2;
        this.tree.nodes[new_node].weight = this.tree.nodes[lightest_node].weight;
        this.tree.nodes[new_node].child = this.tree.nodes[lightest_node].child;
        this.tree.nodes[new_node].child_is_leaf = this.tree.nodes[lightest_node].child_is_leaf;
        this.tree.nodes[new_node].parent = lightest_node;
        this.tree.leaf[this.tree.nodes[new_node].child] = new_node;
        this.tree.nodes[lightest_node].child = new_node;
        this.tree.nodes[lightest_node].child_is_leaf = false;
        this.tree.nodes[zero_weight_node].child = c;
        this.tree.nodes[zero_weight_node].child_is_leaf = true;
        this.tree.nodes[zero_weight_node].weight = 0;
        this.tree.nodes[zero_weight_node].parent = lightest_node;
        this.tree.leaf[c] = zero_weight_node;
    }

    class Tree {
        int[] leaf = new int[258];
        int next_free_node;
        Node[] nodes = new Node[515];

        Tree() {
        }
    }

    class Node {
        int weight;
        int parent;
        boolean child_is_leaf;
        int child;

        Node() {
        }
    }

    class Tree_Node {
        int count;
        int saved_count;
        int child_0;
        int child_1;

        Tree_Node() {
        }
    }
}

