/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.DataContainer;
import gov.nasa.gsfc.spdf.cdfj.GenericReader;
import gov.nasa.gsfc.spdf.cdfj.GenericWriter;
import gov.nasa.gsfc.spdf.cdfj.ReaderFactory;
import gov.nasa.gsfc.spdf.cdfj.SelectedVariableCollection;
import gov.nasa.gsfc.spdf.cdfj.SparseRecordOption;
import gov.nasa.gsfc.spdf.cdfj.SupportedTypes;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import gov.nasa.gsfc.spdf.cdfj.VariableDataBuffer;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CDFWriter
extends GenericWriter {
    Hashtable variableMap = new Hashtable();
    Hashtable gamap = new Hashtable();
    SelectedVariableCollection vcol = new Selector();
    static final Logger anonymousLogger = Logger.getAnonymousLogger();
    static Logger logger = Logger.getLogger("cdfj.cdfwriter");
    static List<String> doNotCheckListGlobal = new ArrayList<String>();

    public CDFWriter(boolean targetMajority) {
        super(targetMajority);
    }

    public CDFWriter(GenericReader cdf) throws CDFException.WriterError, CDFException.ReaderError {
        super(cdf.rowMajority());
        try {
            this._addCDF(cdf);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(String fname) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader cdf = this.getFileReader(fname);
        try {
            this._addCDF(cdf);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(String[] files) throws CDFException.WriterError, CDFException.ReaderError {
        this(files[0]);
        for (int i = 1; i < files.length; ++i) {
            this.addCDF(files[i]);
        }
    }

    public CDFWriter(URL url) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader cdf = null;
        try {
            cdf = new GenericReader(url);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        try {
            this._addCDF(cdf);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(URL[] urls) throws CDFException.WriterError, CDFException.ReaderError {
        this(urls[0]);
        for (int i = 1; i < urls.length; ++i) {
            this.addCDF(urls[i]);
        }
    }

    public CDFWriter(String fname, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader cdf = this.getFileReader(fname);
        try {
            this._addCDF(cdf, this.variableNames(cdf, col));
        }
        catch (CDFException.ReaderError | CDFException.WriterError th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(String[] files, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        this(files[0], col);
        for (int i = 1; i < files.length; ++i) {
            this.addCDF(files[i]);
        }
    }

    public CDFWriter(URL url, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader cdf = null;
        try {
            cdf = new GenericReader(url);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        try {
            this._addCDF(cdf, this.variableNames(cdf, col));
        }
        catch (CDFException.ReaderError | CDFException.WriterError th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(URL[] urls, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        this(urls[0], col);
        for (int i = 1; i < urls.length; ++i) {
            this.addCDF(urls[i]);
        }
    }

    String[] variableNames(GenericReader cdf, SelectedVariableCollection col) throws CDFException.ReaderError {
        String[] vnames;
        if (col == null) {
            for (String vname : vnames = cdf.getVariableNames()) {
                this.vcol.add(vname, cdf.isCompressed(vname), this.sparseRecordOption(cdf, vname));
            }
        } else {
            vnames = this.getSelected(cdf, col);
        }
        return vnames;
    }

    public CDFWriter(String fname, boolean targetMajority) throws CDFException.WriterError, CDFException.ReaderError {
        super(targetMajority);
        GenericReader cdf = this.getFileReader(fname);
        try {
            this._addCDF(cdf);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    GenericReader getFileReader(String fname) throws CDFException.ReaderError {
        GenericReader cdf = null;
        File file = new File(fname);
        if (!file.exists()) {
            throw new CDFException.ReaderError("file " + fname + " does not exist.");
        }
        try {
            long size = file.length();
            if (size > Integer.MAX_VALUE) {
                cdf = ReaderFactory.getReader(fname);
            } else {
                if (this.isWindows()) {
                    return ReaderFactory.getReader(fname, true);
                }
                cdf = new GenericReader(fname);
            }
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        return cdf;
    }

    public CDFWriter(String[] files, boolean targetMajority) throws CDFException.WriterError, CDFException.ReaderError {
        this(files[0], targetMajority);
        for (int i = 1; i < files.length; ++i) {
            this.addCDF(files[i]);
        }
    }

    public CDFWriter(URL url, boolean targetMajority) throws CDFException.WriterError, CDFException.ReaderError {
        super(targetMajority);
        GenericReader cdf = null;
        try {
            cdf = new GenericReader(url);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        try {
            this._addCDF(cdf);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(URL[] urls, boolean targetMajority) throws CDFException.WriterError, CDFException.ReaderError {
        this(urls[0], targetMajority);
        for (int i = 1; i < urls.length; ++i) {
            this.addCDF(urls[i]);
        }
    }

    public CDFWriter(String fname, boolean targetMajority, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        super(targetMajority);
        GenericReader cdf = this.getFileReader(fname);
        try {
            this._addCDF(cdf, this.variableNames(cdf, col));
        }
        catch (CDFException.ReaderError | CDFException.WriterError th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(String[] files, boolean targetMajority, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        this(files[0], targetMajority, col);
        for (int i = 1; i < files.length; ++i) {
            this.addCDF(files[i]);
        }
    }

    public CDFWriter(URL url, boolean targetMajority, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        super(targetMajority);
        GenericReader cdf = null;
        try {
            cdf = new GenericReader(url);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        try {
            this._addCDF(cdf, this.variableNames(cdf, col));
        }
        catch (CDFException.ReaderError | CDFException.WriterError th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public CDFWriter(URL[] urls, boolean targetMajority, SelectedVariableCollection col) throws CDFException.WriterError, CDFException.ReaderError {
        this(urls[0], targetMajority, col);
        for (int i = 1; i < urls.length; ++i) {
            this.addCDF(urls[i]);
        }
    }

    public void addCDF(String fname) throws CDFException.WriterError, CDFException.ReaderError {
        GenericReader cdf = this.getFileReader(fname);
        this.addCDF(cdf);
    }

    public void addCDF(URL url) throws CDFException.WriterError, CDFException.ReaderError {
        GenericReader cdf = null;
        try {
            cdf = new GenericReader(url);
        }
        catch (CDFException.ReaderError th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
        this.addCDF(cdf);
    }

    private void _addCDF(GenericReader cdf, String[] vnames) throws CDFException.WriterError, CDFException.ReaderError {
        this.checkLastLeapSecondId(cdf);
        this.copyGlobalAttributes(cdf);
        this.addGlobalAttributeEntry("cdfj_source", cdf.getSource());
        for (String vn : vnames) {
            this.copyVariableAttributes(cdf, vn);
        }
        for (String vname : vnames) {
            String tvar;
            if (!cdf.recordVariance(vname) || cdf.isTimeType(vname)) continue;
            try {
                tvar = cdf.getTimeVariableName(vname);
            }
            catch (Throwable th) {
                tvar = null;
            }
            if (tvar == null) continue;
            DataContainer dc = (DataContainer)this.dataContainers.get(vname);
            if (cdf.getNumberOfValues(vname) != cdf.getNumberOfValues(tvar)) continue;
            dc.setTimeContainer((DataContainer)this.dataContainers.get(tvar));
        }
        for (String vname : vnames) {
            if (cdf.getNumberOfValues(vname) == 0) {
                ((DataContainer)this.dataContainers.get(vname)).addPhantomEntry();
            } else {
                this.copyVariableData(cdf, vname);
            }
            this.vcol.add(vname, cdf.isCompressed(vname), this.sparseRecordOption(cdf, vname));
        }
    }

    private void _addCDF(GenericReader cdf) throws Throwable {
        String[] vnames;
        for (String vname : vnames = cdf.getVariableNames()) {
            this.vcol.add(vname, cdf.isCompressed(vname));
        }
        this._addCDF(cdf, vnames);
    }

    void copyGlobalAttributes(GenericReader cdf) throws CDFException.ReaderError, CDFException.WriterError {
        String[] gan;
        for (String gan1 : gan = cdf.globalAttributeNames()) {
            Vector<AttributeEntry> entries = null;
            try {
                entries = cdf.getAttributeEntries(gan1);
            }
            catch (CDFException.ReaderError th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
            this.gamap.put(gan1, entries);
            for (int e = 0; e < entries.size(); ++e) {
                AttributeEntry entry = entries.get(e);
                this.addGlobalAttributeEntry(gan1, SupportedTypes.cdfType(entry.getType()), entry.getValue());
            }
        }
    }

    void copyVariableAttributes(GenericReader cdf, String vn) throws CDFException.ReaderError, CDFException.WriterError {
        String[] anames;
        boolean compressed = this.vcol.isCompressed(vn);
        SparseRecordOption sro = this.vcol.getSparseRecordOption(vn);
        CDFDataType ctype = SupportedTypes.cdfType(cdf.getType(vn));
        Hashtable<String, Object> vmap = new Hashtable<String, Object>();
        vmap.put("ctype", ctype);
        vmap.put("compressed", compressed);
        vmap.put("dimensions", cdf.getDimensions(vn));
        vmap.put("varys", cdf.getVarys(vn));
        vmap.put("variance", cdf.recordVariance(vn));
        vmap.put("padValue", cdf.getPadValue(vn, true));
        vmap.put("numberOfElements", cdf.getNumberOfElements(vn));
        int[] dims = cdf.getDimensions(vn);
        boolean[] varys = cdf.getVarys(vn);
        if (ctype == CDFDataType.EPOCH16) {
            dims = new int[]{};
            varys = new boolean[]{};
        }
        try {
            this.defineVariable(vn, ctype, dims, varys, cdf.recordVariance(vn), compressed, cdf.getPadValue(vn, true), cdf.getNumberOfElements(vn), sro);
        }
        catch (CDFException.ReaderError | CDFException.WriterError ex) {
            ex.printStackTrace();
            throw new CDFException.WriterError("Failed to define " + vn);
        }
        Hashtable<String, Vector<AttributeEntry>> amap = new Hashtable<String, Vector<AttributeEntry>>();
        for (String aname : anames = cdf.variableAttributeNames(vn)) {
            Vector<AttributeEntry> entries = null;
            try {
                entries = cdf.getAttributeEntries(vn, aname);
            }
            catch (CDFException.ReaderError th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
            amap.put(aname, entries);
            AttributeEntry entry = entries.get(0);
            ctype = SupportedTypes.cdfType(entry.getType());
            this.setVariableAttributeEntry(vn, aname, ctype, entry.getValue());
            for (int e = 1; e < entries.size(); ++e) {
                entry = entries.get(e);
                ctype = SupportedTypes.cdfType(cdf.getType(vn));
                this.addVariableAttributeEntry(vn, aname, ctype, entry.getValue());
            }
        }
        vmap.put("amap", amap);
        this.variableMap.put(vn, vmap);
    }

    void copyVariableData(GenericReader cdf, String vn) throws CDFException.ReaderError, CDFException.WriterError {
        if (cdf.getByteOrder() == ByteOrder.LITTLE_ENDIAN && cdf.rowMajority() == this.rowMajority) {
            VariableDataBuffer[] dbufs = null;
            try {
                Variable var = cdf.thisCDF.getVariable(vn);
                dbufs = var.getDataBuffers(true);
            }
            catch (Throwable th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
            for (VariableDataBuffer dbuf : dbufs) {
                ByteBuffer b = dbuf.getBuffer();
                this.addBuffer(vn, dbuf);
            }
        } else {
            VDataContainer _container = null;
            try {
                _container = this.getContainer(cdf, vn);
            }
            catch (Throwable th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
            _container.run();
            int[] rr = new int[]{0, cdf.getNumberOfValues(vn) - 1, 1};
            DataContainer container = (DataContainer)this.dataContainers.get(vn);
            if (container != null) {
                int _last = container.getLastRecord();
                System.out.println("last: " + _last);
                if (_last >= 0) {
                    rr[0] = rr[0] + ++_last;
                    rr[1] = rr[1] + _last;
                }
            }
            System.out.println("rr: " + rr[0] + "," + rr[1]);
            if (cdf.rowMajority() == this.rowMajority) {
                this.addData(vn, (Object)_container.getBuffer(), rr);
            } else {
                this.addOneD(vn, _container.asOneDArray(!this.rowMajority), rr, true);
            }
        }
    }

    public void addCDF(GenericReader cdf) throws CDFException.ReaderError, CDFException.WriterError {
        String[] vnames;
        this.checkLastLeapSecondId(cdf);
        this.checkGlobalAttributes(cdf);
        List timeVariableList = this.getTimeVariableList(cdf);
        for (String vn : vnames = this.vcol.getNames()) {
            Hashtable vmap = (Hashtable)this.variableMap.get(vn);
            if (!((Boolean)vmap.get("variance")).booleanValue()) continue;
            if (timeVariableList.contains(vn)) {
                DataContainer dc = (DataContainer)this.dataContainers.get(vn);
                if (cdf.getNumberOfValues(vn) > 0) {
                    Object firstTime;
                    try {
                        firstTime = cdf.isCompatible(vn, Double.TYPE) ? cdf.getOneDArray(vn, "double", new int[]{0, 0}, true, !this.rowMajority) : cdf.getOneDArray(vn, "long", new int[]{0, 0}, true, !this.rowMajority);
                    }
                    catch (CDFException.ReaderError th) {
                        throw new CDFException.WriterError(th.getMessage());
                    }
                    if (!dc.timeOrderOK(firstTime)) {
                        throw new CDFException.WriterError("Time Backup -Time of first record for variable " + vn + " of CDF " + cdf.thisCDF.getSource().getName() + " starts before the end of previous CDF");
                    }
                }
            }
            if (cdf.getNumberOfValues(vn) <= 0) continue;
            this.copyVariableData(cdf, vn);
        }
    }

    List getTimeVariableList(GenericReader cdf) {
        String[] vnames;
        ArrayList<String> list = new ArrayList<String>();
        for (String vname : vnames = this.vcol.getNames()) {
            String tvar;
            try {
                tvar = cdf.getTimeVariableName(vname);
            }
            catch (Throwable th) {
                tvar = null;
            }
            if (tvar == null) continue;
            list.add(tvar);
        }
        return list;
    }

    void checkGlobalAttributes(GenericReader cdf) throws CDFException.ReaderError, CDFException.WriterError {
        String[] gan;
        for (String gan1 : gan = cdf.globalAttributeNames()) {
            Vector _entries = (Vector)this.gamap.get(gan1);
            Vector<AttributeEntry> entries = null;
            try {
                entries = cdf.getAttributeEntries(gan1);
            }
            catch (CDFException.ReaderError th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
            for (int e = 0; e < entries.size(); ++e) {
                AttributeEntry _entry;
                AttributeEntry entry = entries.get(e);
                boolean found = false;
                for (int b = 0; b < _entries.size() && !(found = (_entry = (AttributeEntry)_entries.get(b)).isSameAs(entry)); ++b) {
                }
                if (found || doNotCheckListGlobal.contains(gan1)) continue;
                logger.log(Level.FINE, "Global attribute entry for attribute {0} not in base, or differs from the value in base.", gan1);
            }
        }
    }

    void updateVariableAttributes(GenericReader cdf, String vn) throws Throwable {
        String[] anames = cdf.variableAttributeNames(vn);
        Hashtable vmap = (Hashtable)this.variableMap.get(vn);
        this.validateVariableProperties(cdf, vn);
        Hashtable amap = (Hashtable)vmap.get("amap");
        for (String aname : anames) {
            Vector<AttributeEntry> entries = cdf.getAttributeEntries(vn, aname);
            Vector _entries = (Vector)amap.get(aname);
            for (int e = 0; e < entries.size(); ++e) {
                AttributeEntry _entry;
                AttributeEntry entry = entries.get(e);
                boolean found = false;
                for (int b = 0; b < _entries.size() && !(found |= (_entry = (AttributeEntry)_entries.get(b)).isSameAs(entry)); ++b) {
                }
                if (found) continue;
                logger.log(Level.FINE, "Attribute entry for attribute {0} for variable {1} not in base.", new Object[]{aname, vn});
            }
        }
    }

    void validateVariableProperties(GenericReader cdf, String vn) throws Throwable {
        boolean failed;
        Hashtable vmap = (Hashtable)this.variableMap.get(vn);
        boolean compressed = cdf.isCompressed(vn);
        boolean bl = failed = (CDFDataType)vmap.get("ctype") != SupportedTypes.cdfType(cdf.getType(vn));
        if (!failed) {
            boolean bl2 = failed = !Arrays.equals((int[])vmap.get("dimensions"), cdf.getDimensions(vn));
        }
        if (!failed) {
            boolean bl3 = failed = !Arrays.equals((boolean[])vmap.get("varys"), cdf.getVarys(vn));
        }
        if (!failed) {
            boolean bl4 = failed = ((Boolean)vmap.get("variance")).booleanValue() != cdf.recordVariance(vn);
        }
        if (!failed) {
            boolean bl5 = failed = ((Integer)vmap.get("numberOfElements")).intValue() != cdf.getNumberOfElements(vn);
        }
        if (failed) {
            throw new Throwable("Properties of variable " + vn + "do not match.");
        }
    }

    boolean isTimeType(int type) {
        boolean isTimeType = CDFTimeType.EPOCH.getValue() == type;
        isTimeType |= CDFTimeType.EPOCH16.getValue() == type;
        return isTimeType |= CDFTimeType.TT2000.getValue() == type;
    }

    String[] getSelected(GenericReader cdf, SelectedVariableCollection col) throws CDFException.ReaderError {
        String[] sorted = null;
        Vector<String> selected = new Vector<String>();
        int n = 0;
        String[] names = col.getNames();
        while (n < names.length) {
            String name = names[n];
            logger.log(Level.FINE, "requested: {0}", name);
            if (!this.hasVariable(cdf, name)) {
                logger.log(Level.FINE, "{0} not found in original. ignoring.", name);
                ++n;
                continue;
            }
            if (!selected.contains(name)) {
                selected.add(name);
                this.vcol.add(name, col.isCompressed(name), col.getSparseRecordOption(name));
            }
            Vector depends = CDFWriter.getDependent(cdf, name);
            for (int i = 0; i < depends.size(); ++i) {
                String dvar = (String)depends.get(i);
                if (selected.contains(dvar)) continue;
                selected.add(dvar);
                boolean compressed = cdf.isCompressed(dvar);
                SparseRecordOption sro = this.sparseRecordOption(cdf, name);
                if (col.hasVariable(dvar)) {
                    compressed = col.isCompressed(dvar);
                    sro = col.getSparseRecordOption(name);
                }
                this.vcol.add(dvar, compressed, sro);
                logger.log(Level.FINE, "added: {0}", depends.get(i));
            }
            ++n;
        }
        if (selected.size() == 0) {
            logger.fine("No valid variables selected.");
            return new String[0];
        }
        sorted = new String[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            sorted[i] = (String)selected.get(i);
        }
        return sorted;
    }

    static Vector getDependent(GenericReader cdf, String vname) throws CDFException.ReaderError {
        String[] anames = cdf.variableAttributeNames(vname);
        Vector dependent = new Vector();
        if (anames == null) {
            return dependent;
        }
        for (String aname : anames) {
            if (!aname.startsWith("DEPEND_")) continue;
            dependent.add(((Vector)cdf.getAttribute(vname, aname)).get(0));
        }
        return dependent;
    }

    public CDFDataType getVariableType(String name) {
        Hashtable o = (Hashtable)this.variableMap.get(name);
        if (o != null) {
            CDFDataType t = (CDFDataType)o.get("ctype");
            if (t == null) {
                throw new IllegalArgumentException("internal error, expected to see type for: " + name);
            }
            return t;
        }
        throw new IllegalArgumentException("variable with the name does not exist: " + name);
    }

    public static SelectedVariableCollection selectorInstance() {
        return new Selector();
    }

    boolean hasVariable(GenericReader cdf, String vname) {
        String[] vnames;
        for (String vname1 : vnames = cdf.getVariableNames()) {
            if (!vname.equals(vname1)) continue;
            return true;
        }
        return false;
    }

    String getTimeVariableName(GenericReader cdf, String vname) {
        String tvar;
        try {
            tvar = cdf.getTimeVariableName(vname);
        }
        catch (Throwable th) {
            logger.fine(th.toString());
            tvar = null;
        }
        return tvar;
    }

    VDataContainer getContainer(GenericReader rdr, String varName) throws Throwable {
        VDataContainer container = null;
        CDFDataType ctype = SupportedTypes.cdfType(rdr.getType(varName));
        Variable var = rdr.thisCDF.getVariable(varName);
        ByteOrder order = ByteOrder.LITTLE_ENDIAN;
        if (ctype == CDFDataType.INT1 || ctype == CDFDataType.UINT1) {
            container = var.getByteContainer(null);
        }
        if (ctype == CDFDataType.INT2) {
            container = var.getShortContainer(null, true, order);
        }
        if (ctype == CDFDataType.INT4) {
            container = var.getIntContainer(null, true, order);
        }
        if (ctype == CDFDataType.UINT2) {
            container = var.getShortContainer(null, false, order);
        }
        if (ctype == CDFDataType.UINT4) {
            container = var.getIntContainer(null, false, order);
        }
        if (ctype == CDFDataType.FLOAT) {
            container = var.getFloatContainer(null, true, order);
        }
        if (ctype == CDFDataType.DOUBLE || ctype == CDFDataType.EPOCH || ctype == CDFDataType.EPOCH16) {
            container = var.getDoubleContainer(null, true, order);
        }
        if (ctype == CDFDataType.TT2000 || ctype == CDFDataType.INT8) {
            container = var.getLongContainer(null, order);
        }
        if (ctype == CDFDataType.CHAR) {
            container = var.getStringContainer(null);
        }
        return container;
    }

    public void setLogger(Logger _logger) {
        if (_logger == null) {
            return;
        }
        logger = _logger;
    }

    public static void setLoggerLevel(Level newLevel) {
        if (logger == anonymousLogger) {
            logger.setLevel(newLevel);
        }
    }

    public static void addToDoNotCheckList(String aname) {
        if (doNotCheckListGlobal.contains(aname)) {
            return;
        }
        doNotCheckListGlobal.add(aname);
    }

    public static void removeFromDoNotCheckList(String aname) {
        if (!doNotCheckListGlobal.contains(aname)) {
            return;
        }
        doNotCheckListGlobal.remove(aname);
    }

    public String[] attributesInDoNotCheckList() {
        String[] sa = new String[doNotCheckListGlobal.size()];
        doNotCheckListGlobal.toArray(sa);
        return sa;
    }

    SparseRecordOption sparseRecordOption(GenericReader cdf, String vname) throws CDFException.ReaderError {
        if (cdf.missingRecordValueIsPad(vname)) {
            return SparseRecordOption.PADDED;
        }
        if (cdf.missingRecordValueIsPrevious(vname)) {
            return SparseRecordOption.PREVIOUS;
        }
        return SparseRecordOption.NONE;
    }

    void checkLastLeapSecondId(GenericReader cdf) throws CDFException.WriterError {
        if (this.lastLeapSecondId == -1) {
            this.lastLeapSecondId = cdf.getLastLeapSecondId();
        } else if (this.lastLeapSecondId != cdf.getLastLeapSecondId()) {
            throw new CDFException.WriterError("LastLeapSecondId " + cdf.getLastLeapSecondId() + " does not match previously found " + this.lastLeapSecondId);
        }
    }

    static {
        doNotCheckListGlobal.add("Logical_file_id");
        doNotCheckListGlobal.add("Generation_date");
        doNotCheckListGlobal.add("Software_version");
    }

    static class Selector
    implements SelectedVariableCollection {
        HashMap<String, Boolean> map = new HashMap();
        HashMap<String, SparseRecordOption> smap = new HashMap();

        Selector() {
        }

        @Override
        public void add(String vname, boolean compression) {
            this.map.put(vname, compression);
        }

        @Override
        public void add(String vname, boolean compression, SparseRecordOption opt) {
            this.add(vname, compression);
            this.smap.put(vname, opt);
        }

        @Override
        public boolean isCompressed(String name) {
            return this.map.get(name);
        }

        @Override
        public SparseRecordOption getSparseRecordOption(String name) {
            if (this.smap.get(name) == null) {
                return SparseRecordOption.PADDED;
            }
            return this.smap.get(name);
        }

        @Override
        public String[] getNames() {
            String[] names = new String[this.map.size()];
            Set<String> set = this.map.keySet();
            set.toArray(names);
            return names;
        }

        @Override
        public boolean hasVariable(String name) {
            return this.map.get(name) != null;
        }
    }
}

