/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;

public class StringArray
extends AArray {
    public StringArray(Object o) throws Throwable {
        super(o);
    }

    public StringArray(Object o, boolean majority) throws Throwable {
        super(o, majority);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                String[] _s1 = (String[])this.o;
                return (String[])this.o;
            }
            case 2: {
                return (String[][])this.o;
            }
            case 3: {
                return (String[][][])this.o;
            }
            case 4: {
                return (String[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> cl, int size) throws Throwable {
        if (cl != String.class) {
            throw new Throwable("Valid for String type only");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        ByteBuffer buf = this.allocate(size);
        int[] _dim = this.aa.getDimensions();
        switch (this.dim) {
            case 1: {
                String[] _s1 = (String[])this.o;
                this.addString(buf, _s1, size);
                buf.flip();
                return buf;
            }
            case 2: {
                String[][] _s2 = (String[][])this.o;
                for (int i = 0; i < _dim[0]; ++i) {
                    this.addString(buf, _s2[i], size);
                }
                buf.flip();
                return buf;
            }
            case 3: {
                String[][][] _s3 = (String[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int j = 0; j < _dim[1]; ++j) {
                            this.addString(buf, _s3[i][j], size);
                        }
                    }
                } else {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int k = 0; k < _dim[2]; ++k) {
                            for (int j = 0; j < _dim[1]; ++j) {
                                this.addString(buf, _s3[i][j][k], size);
                            }
                        }
                    }
                }
                buf.flip();
                return buf;
            }
            case 4: {
                String[][][][] _s4 = (String[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int j = 0; j < _dim[1]; ++j) {
                            for (int k = 0; k < _dim[2]; ++k) {
                                this.addString(buf, _s4[i][j][k], size);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int l = 0; l < _dim[3]; ++l) {
                            for (int k = 0; k < _dim[2]; ++k) {
                                for (int j = 0; j < _dim[1]; ++j) {
                                    this.addString(buf, _s4[i][j][k][l], size);
                                }
                            }
                        }
                    }
                }
                buf.flip();
                return buf;
            }
        }
        return null;
    }

    void addString(ByteBuffer buf, String[] sa, int max) throws Throwable {
        for (String sa1 : sa) {
            this.addString(buf, sa1, max);
        }
    }

    void addString(ByteBuffer buf, String s, int max) throws Throwable {
        int len = s.length();
        if (len > max) {
            throw new Throwable("String " + s + " is longer than the specified max " + max);
        }
        byte[] _bar = s.getBytes();
        buf.put(_bar);
        for (int f = 0; f < max - _bar.length; ++f) {
            buf.put((byte)32);
        }
    }
}

