/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFDataType;

public class SupportedTypes {
    static final CDFDataType[] supportedTypes = new CDFDataType[53];

    public static CDFDataType cdfType(int type) {
        if (type < 0 || type > supportedTypes.length - 1) {
            return null;
        }
        return supportedTypes[type];
    }

    static {
        for (int i = 0; i < supportedTypes.length; ++i) {
            SupportedTypes.supportedTypes[i] = null;
        }
        SupportedTypes.supportedTypes[1] = CDFDataType.INT1;
        SupportedTypes.supportedTypes[11] = CDFDataType.UINT1;
        SupportedTypes.supportedTypes[2] = CDFDataType.INT2;
        SupportedTypes.supportedTypes[12] = CDFDataType.UINT2;
        SupportedTypes.supportedTypes[4] = CDFDataType.INT4;
        SupportedTypes.supportedTypes[14] = CDFDataType.UINT4;
        SupportedTypes.supportedTypes[8] = CDFDataType.INT8;
        SupportedTypes.supportedTypes[33] = CDFDataType.TT2000;
        SupportedTypes.supportedTypes[21] = CDFDataType.FLOAT;
        SupportedTypes.supportedTypes[44] = CDFDataType.FLOAT;
        SupportedTypes.supportedTypes[22] = CDFDataType.DOUBLE;
        SupportedTypes.supportedTypes[45] = CDFDataType.DOUBLE;
        SupportedTypes.supportedTypes[31] = CDFDataType.EPOCH;
        SupportedTypes.supportedTypes[32] = CDFDataType.EPOCH16;
        SupportedTypes.supportedTypes[41] = CDFDataType.INT1;
        SupportedTypes.supportedTypes[51] = CDFDataType.CHAR;
        SupportedTypes.supportedTypes[52] = CDFDataType.CHAR;
    }
}

