/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.util.Hashtable;
import java.util.Set;

public final class TimePrecision {
    public static final TimePrecision MILLISECOND = new TimePrecision(0);
    public static final TimePrecision MICROSECOND = new TimePrecision(1);
    public static final TimePrecision NANOSECOND = new TimePrecision(2);
    public static final TimePrecision PICOSECOND = new TimePrecision(3);
    static Hashtable<String, TimePrecision> ht = new Hashtable();
    static final int MIN_LENGTH = 3;
    int precision;

    private TimePrecision(int precision) {
        this.precision = precision;
    }

    public int getValue() {
        return this.precision;
    }

    public static TimePrecision getPrecision(String s) {
        String _s = s.toLowerCase();
        int len = _s.length();
        if (len < 3) {
            return null;
        }
        Set<String> keys = ht.keySet();
        for (String k : keys) {
            if (!k.substring(0, len).equals(_s)) continue;
            return ht.get(k);
        }
        return null;
    }

    static {
        ht.put("millisecond", MILLISECOND);
        ht.put("microsecond", MICROSECOND);
        ht.put("nanosecond", NANOSECOND);
        ht.put("picosecond", PICOSECOND);
    }
}

