/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFWriter;
import gov.nasa.gsfc.spdf.cdfj.ReaderFactory;
import gov.nasa.gsfc.spdf.cdfj.SupportedTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CdfDataSourceFormat
implements DataSourceFormat {
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();
    Map<String, QDataSet> namesRev = new HashMap<String, QDataSet>();
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.cdf");

    public boolean streamData(Map<String, String> params, Iterator<QDataSet> data, OutputStream out) throws Exception {
        return false;
    }

    private synchronized String nameFor(QDataSet dep0) {
        String name = this.names.get(dep0);
        if (name != null) {
            return name;
        }
        logger.log(Level.FINE, "new variable: {0}", dep0);
        name = (String)dep0.property("NAME");
        if (this.namesRev.containsKey(name)) {
            int i = 1;
            while (this.namesRev.containsKey(name + "_" + i)) {
                ++i;
            }
            name = name + "_" + i;
        }
        Units units = (Units)dep0.property("UNITS");
        if (name == null) {
            name = units != null && UnitsUtil.isTimeLocation((Units)units) ? "Epoch" : "Variable_" + this.namesRev.size();
        }
        this.names.put(dep0, name);
        this.namesRev.put(name, dep0);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        mon.started();
        try {
            block99: {
                block98: {
                    block97: {
                        split = URISplit.parse((String)uri);
                        params = URISplit.parseParams((String)split.params);
                        ffile = new File(split.resourceUri.getPath());
                        append = "T".equals(params.get("append"));
                        insert = "T".equals(params.get("insert"));
                        useRowMajority = "row".equals(params.get("majority"));
                        if (!append && !insert) {
                            CdfDataSourceFormat.logger.log(Level.FINE, "create CDF file {0}", ffile);
                            CdfDataSourceFormat.logger.log(Level.FINE, "call cdf= new CDFWriter( false )");
                            cdf = new CDFWriter(useRowMajority);
                        } else if (insert) {
                            name = (String)data.property("NAME");
                            if (name == null) {
                                name = (String)params.get("arg_0");
                            }
                            if (name == null) {
                                throw new IllegalArgumentException("dataset must have name found within CDF file.");
                            }
                            itype = 21;
                            var14_18 = type = CdfUtil.getStringDataType(itype);
                            var15_23 = -1;
                            switch (var14_18.hashCode()) {
                                case -1176241328: {
                                    if (!var14_18.equals("CDF_CHAR")) break;
                                    var15_23 = 0;
                                    break;
                                }
                                case -2089979488: {
                                    if (!var14_18.equals("CDF_REAL8")) break;
                                    var15_23 = 1;
                                    break;
                                }
                                case -755840693: {
                                    if (!var14_18.equals("CDF_DOUBLE")) break;
                                    var15_23 = 2;
                                    break;
                                }
                                case -2100840062: {
                                    if (!var14_18.equals("CDF_FLOAT")) break;
                                    var15_23 = 3;
                                    break;
                                }
                                case -2089979492: {
                                    if (!var14_18.equals("CDF_REAL4")) break;
                                    var15_23 = 4;
                                    break;
                                }
                                case -2087077027: {
                                    if (!var14_18.equals("CDF_UINT1")) break;
                                    var15_23 = 5;
                                }
                            }
                            switch (var15_23) {
                                case 0: {
                                    type = "string";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    type = "double";
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    type = "float";
                                    break;
                                }
                                case 5: {
                                    type = "short";
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported type: " + type + ", must be CHAR, REAL8, REAL4, DOUBLE, FLOAT, or UINT1.");
                                }
                            }
                            params.put("type", type);
                            read = ReaderFactory.getReader(ffile.toString());
                            CdfDataSourceFormat.logger.log(Level.FINE, "call cdf= new CDFWriter( {0}, false )", ffile.toString());
                            cdf = new CDFWriter(ffile.toString(), read.rowMajority());
                        } else {
                            read = ReaderFactory.getReader(ffile.toString());
                            for (String n : read.getVariableNames()) {
                                this.namesRev.put(n, null);
                            }
                            CdfDataSourceFormat.logger.log(Level.FINE, "call cdf= new CDFWriter( {0}, false )", ffile.toString());
                            cdf = new CDFWriter(ffile.toString(), read.rowMajority());
                        }
                        name1 = (String)params.get("arg_0");
                        if (name1 != null) {
                            this.names.put(data, name1);
                            this.namesRev.put(name1, data);
                        }
                        CdfDataSourceFormat.logger.log(Level.FINE, "handling {0}", this.nameFor(data));
                        dep0 = (QDataSet)data.property("DEPEND_0");
                        dep0name = null;
                        if (insert) {
                            dep0 = null;
                        }
                        if (dep0 != null) {
                            if (!append) {
                                dep0name = name = this.nameFor(dep0);
                                params1 = new HashMap<String, String>();
                                params1.put("timeType", (String)params.get("timeType"));
                                CdfDataSourceFormat.addVariableRankN(cdf, dep0, name, true, params1, mon.getSubtaskMonitor("dep0"));
                            } else {
                                name = (String)dep0.property("NAME");
                                if (!this.namesRev.containsKey(name)) {
                                    dep0name = name = this.nameFor(dep0);
                                    params1 = new HashMap<String, String>();
                                    params1.put("timeType", (String)params.get("timeType"));
                                    try {
                                        CdfDataSourceFormat.addVariableRankN(cdf, dep0, name, true, params1, mon.getSubtaskMonitor("dep0"));
                                    }
                                    catch (Exception e) {
                                        CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                                    }
                                } else {
                                    dep0name = name;
                                }
                            }
                        }
                        dep1 = (QDataSet)data.property("DEPEND_1");
                        if (insert) {
                            dep1 = null;
                        }
                        if (dep1 != null) {
                            if (!append) {
                                name = this.nameFor(dep1);
                                if (dep1.rank() == 1) {
                                    CdfDataSourceFormat.addVariableRank1NoVary(cdf, dep1, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("dep1"));
                                } else {
                                    CdfDataSourceFormat.addVariableRankN(cdf, dep1, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("dep1"));
                                }
                            } else {
                                name = (String)dep1.property("NAME");
                                if (!this.namesRev.containsKey(name)) {
                                    name = this.nameFor(dep1);
                                    params1 = new HashMap<String, String>();
                                    try {
                                        if (dep1.rank() == 1) {
                                            CdfDataSourceFormat.addVariableRank1NoVary(cdf, dep1, name, true, params1, mon.getSubtaskMonitor("dep1"));
                                            break block97;
                                        }
                                        CdfDataSourceFormat.addVariableRankN(cdf, dep1, name, true, params1, mon.getSubtaskMonitor("dep1"));
                                    }
                                    catch (Exception e) {
                                        CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                                    }
                                } else {
                                    this.names.put(dep1, name);
                                }
                            }
                        }
                    }
                    dep2 = (QDataSet)data.property("DEPEND_2");
                    if (insert) {
                        dep2 = null;
                    }
                    if (dep2 != null) {
                        if (!append) {
                            name = this.nameFor(dep2);
                            if (dep2.rank() == 1) {
                                CdfDataSourceFormat.addVariableRank1NoVary(cdf, dep2, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("dep2"));
                            } else {
                                CdfDataSourceFormat.addVariableRankN(cdf, dep2, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("dep2"));
                            }
                        } else {
                            name = (String)dep2.property("NAME");
                            if (!this.namesRev.containsKey(name)) {
                                name = this.nameFor(dep2);
                                params1 = new HashMap<String, String>();
                                try {
                                    if (dep2.rank() == 1) {
                                        CdfDataSourceFormat.addVariableRank1NoVary(cdf, dep2, name, true, params1, mon.getSubtaskMonitor("dep2"));
                                        break block98;
                                    }
                                    CdfDataSourceFormat.addVariableRankN(cdf, dep2, name, true, params1, mon.getSubtaskMonitor("dep2"));
                                }
                                catch (Exception e) {
                                    CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                                }
                            } else {
                                this.names.put(dep2, name);
                            }
                        }
                    }
                }
                dep3 = (QDataSet)data.property("DEPEND_3");
                if (insert) {
                    dep3 = null;
                }
                if (dep3 != null) {
                    if (!append) {
                        name = this.nameFor(dep3);
                        if (dep3.rank() == 1) {
                            CdfDataSourceFormat.addVariableRank1NoVary(cdf, dep3, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("dep3"));
                        } else {
                            CdfDataSourceFormat.addVariableRankN(cdf, dep3, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("dep3"));
                        }
                    } else {
                        name = (String)dep2.property("NAME");
                        if (!this.namesRev.containsKey(name)) {
                            name = this.nameFor(dep3);
                            params1 = new HashMap<String, String>();
                            try {
                                if (dep3.rank() == 1) {
                                    CdfDataSourceFormat.addVariableRank1NoVary(cdf, dep3, name, true, params1, mon.getSubtaskMonitor("dep3"));
                                    break block99;
                                }
                                CdfDataSourceFormat.addVariableRankN(cdf, dep3, name, true, params1, mon.getSubtaskMonitor("dep3"));
                            }
                            catch (Exception e) {
                                CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                            }
                        } else {
                            this.names.put(dep3, name);
                        }
                    }
                }
            }
            if ((bds = (QDataSet)data.property("BUNDLE_1")) != null && !insert) {
                if (!append && data.rank() == 2) {
                    if (dep1 == null) {
                        CdfDataSourceFormat.logger.fine("writing bundled datasets to CDF separately.");
                    } else {
                        name = this.nameFor(bds);
                        if (bds.rank() == 1 || bds.rank() == 2 && Schemes.isBundleDescriptor((QDataSet)bds)) {
                            CdfDataSourceFormat.addVariableRank1NoVary(cdf, bds, name, true, new HashMap<String, String>(), mon.getSubtaskMonitor("bundle1"));
                        }
                    }
                } else {
                    name = this.nameFor(bds);
                    params1 = new HashMap<String, String>();
                    try {
                        CdfDataSourceFormat.addVariableRank1NoVary(cdf, bds, name, true, params1, mon.getSubtaskMonitor("bundle1"));
                    }
                    catch (Exception e) {
                        CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                    }
                }
            }
            if (bds != null && dep1 == null && "T".equals(params.get("bundle"))) {
                for (i = 0; i < bds.length(); ++i) {
                    data1 = Ops.unbundle((QDataSet)data, (int)i);
                    CdfDataSourceFormat.addVariableRankN(cdf, data1, this.nameFor(data1), false, params, mon.getSubtaskMonitor("bundle"));
                    if (dep0 == null) continue;
                    cdf.addVariableAttributeEntry(this.nameFor(data1), "DEPEND_0", CDFDataType.CHAR, dep0name);
                }
            } else if (data.rank() == 3 && data.property("BUNDLE_2") != null && "T".equals(params.get("bundle"))) {
                n = data.length(0, 0);
                for (i = 0; i < n; ++i) {
                    data1 = Ops.slice2((QDataSet)data, (int)i);
                    CdfDataSourceFormat.addVariableRankN(cdf, data1, this.nameFor(data1), false, params, mon.getSubtaskMonitor("rank3"));
                    if (dep0 == null) continue;
                    cdf.addVariableAttributeEntry(this.nameFor(data1), "DEPEND_0", CDFDataType.CHAR, dep0name);
                }
            } else {
                CdfDataSourceFormat.addVariableRankN(cdf, data, this.nameFor(data), false, params, mon.getSubtaskMonitor("bundle1"));
                try {
                    if (dep0 != null) {
                        cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_0", CDFDataType.CHAR, dep0name);
                    }
                    if (dep1 != null) {
                        cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_1", CDFDataType.CHAR, this.nameFor(dep1));
                    }
                    if (dep2 != null) {
                        cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_2", CDFDataType.CHAR, this.nameFor(dep2));
                    }
                    if (dep3 != null) {
                        cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_3", CDFDataType.CHAR, this.nameFor(dep3));
                    }
                    if (bds == null) ** GOTO lbl236
                    cdf.addVariableAttributeEntry(this.nameFor(data), "LABL_PTR_1", CDFDataType.CHAR, this.nameFor(bds));
                }
                catch (CDFException.WriterError ex) {
                    CdfDataSourceFormat.logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
lbl236:
            // 5 sources

            mon.setProgressMessage("writing file");
            if (!append && !insert) {
                if (ffile.exists()) {
                    CdfDataSource.cdfCacheReset();
                    tempFile = File.createTempFile("deleteme", ".cdf");
                    if (!ffile.renameTo(tempFile)) {
                        if (!ffile.delete()) {
                            CdfDataSourceFormat.logger.log(Level.WARNING, "file {0} cannot be deleted", ffile);
                        } else if (ffile.exists()) {
                            CdfDataSourceFormat.logger.log(Level.WARNING, "file {0} cannot be renamed", ffile);
                        }
                    }
                    CdfDataSourceFormat.write(cdf, ffile.toString());
                    if (tempFile.exists() && !tempFile.delete()) {
                        CdfDataSourceFormat.logger.log(Level.WARNING, "file {0} cannot be deleted", tempFile);
                    }
                } else {
                    CdfDataSourceFormat.write(cdf, ffile.toString());
                }
            } else if (insert) {
                CdfDataSource.cdfCacheReset();
                cdf.write(ffile.toString());
            } else {
                CdfDataSourceFormat.write(cdf, ffile.toString());
            }
        }
        finally {
            mon.finished();
        }
    }

    private static void addVariableRank1NoVary(CDFWriter cdf, QDataSet ds, String name, boolean isSupport, Map<String, String> params, ProgressMonitor mon) throws Exception {
        Units units = (Units)ds.property("UNITS");
        CDFDataType type = CDFDataType.DOUBLE;
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            type = CDFDataType.EPOCH;
            uc = units.getConverter((Units)Units.cdfEpoch);
        }
        if (ds.rank() == 1) {
            Object array = CdfDataSourceFormat.datasetToArray(ds, uc, type, mon);
            logger.log(Level.FINE, "call cdf.addNRVVariable( {0},{1},{2})", new Object[]{name, CdfDataSourceFormat.logName(type), CdfDataSourceFormat.logName(new int[]{ds.length()}), CdfDataSourceFormat.logName(array)});
            cdf.addNRVVariable(name, type, new int[]{ds.length()}, array);
        } else if (Schemes.isBundleDescriptor((QDataSet)ds)) {
            String[] array = new String[ds.length()];
            String[] ss = DataSetOps.bundleNames((QDataSet)ds);
            int dim = 0;
            for (int i = 0; i < ds.length(); ++i) {
                String s = (String)ds.property("LABEL", i);
                if (s == null) {
                    s = (String)ds.property("NAME", i);
                }
                if (s == null) {
                    s = ss[i];
                }
                array[i] = s;
                int l = s.length();
                dim = dim < l ? l : dim;
            }
            logger.log(Level.FINE, "call cdf.addNRVVariable( {0},{1},{2})", new Object[]{name, CdfDataSourceFormat.logName(type), CdfDataSourceFormat.logName(new int[]{ds.length()}), CdfDataSourceFormat.logName(array)});
            cdf.addNRVVariable(name, CDFDataType.CHAR, new int[]{ds.length()}, dim, array);
        } else {
            throw new IllegalArgumentException("not supported!");
        }
        CdfDataSourceFormat.copyMetadata(cdf, units, name, type, isSupport, ds);
    }

    private static int encodeUINT4(double d) {
        return (int)(d > 2.147483648E9 ? d - 4.294967296E9 : d);
    }

    private static short encodeUINT2(double d) {
        return (short)(d > 32768.0 ? d - 65536.0 : d);
    }

    private static byte encodeUINT1(double d) {
        return (byte)(d > 128.0 ? d - 256.0 : d);
    }

    private static ByteBuffer doIt1Nio(QDataSet ds, UnitsConverter uc, CDFDataType type) {
        ByteBuffer export;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        if (type == CDFDataType.DOUBLE || type == CDFDataType.EPOCH) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putDouble(uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.TT2000) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putLong((long)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.FLOAT) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putFloat((float)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.INT4) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putInt((int)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.INT2) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 2);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putShort((short)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.INT1) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 1);
            while (iter.hasNext()) {
                iter.next();
                buf.put((byte)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.UINT4) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putInt(CdfDataSourceFormat.encodeUINT4(uc.convert(iter.getValue(ds))));
            }
            export = buf;
        } else if (type == CDFDataType.UINT2) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 2);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putShort(CdfDataSourceFormat.encodeUINT2(uc.convert(iter.getValue(ds))));
            }
            export = buf;
        } else if (type == CDFDataType.UINT1) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 1);
            while (iter.hasNext()) {
                iter.next();
                buf.put(CdfDataSourceFormat.encodeUINT1(uc.convert(iter.getValue(ds))));
            }
            export = buf;
        } else if (type == CDFDataType.CHAR) {
            int maxLenth = 1;
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * maxLenth);
            for (int i = 0; i < ds.length(); ++i) {
                buf.put((byte)ds.slice(i).svalue().charAt(0));
            }
            export = buf;
        } else {
            throw new IllegalArgumentException("not supported: " + type);
        }
        export.flip();
        return export;
    }

    private static ByteBuffer dataSetToNioArray(QDataSet ds, UnitsConverter uc, CDFDataType type, ProgressMonitor mon) {
        switch (ds.rank()) {
            case 1: {
                return CdfDataSourceFormat.doIt1Nio(ds, uc, type);
            }
            case 2: {
                throw new UnsupportedOperationException("not implemented");
            }
            case 3: {
                throw new UnsupportedOperationException("not implemented");
            }
            case 4: {
                throw new UnsupportedOperationException("not implemented");
            }
        }
        throw new IllegalArgumentException("rank 0 not supported");
    }

    private static Object doIt1(QDataSet ds, UnitsConverter uc, CDFDataType type) {
        Object[] export;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        if (type == CDFDataType.DOUBLE || type == CDFDataType.EPOCH) {
            double[] dexport = new double[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == CDFDataType.TT2000) {
            long[] dexport = new long[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = (long)uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == CDFDataType.FLOAT) {
            float[] fexport = new float[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                fexport[i++] = (float)uc.convert(iter.getValue(ds));
            }
            export = fexport;
        } else if (type == CDFDataType.INT4) {
            int[] bexport = new int[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (int)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.INT2) {
            short[] bexport = new short[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.INT1) {
            byte[] bexport = new byte[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (byte)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.CHAR) {
            String[] s = new String[ds.length()];
            for (int i = 0; i < ds.length(); ++i) {
                s[i] = ds.slice(i).svalue();
            }
            export = s;
        } else if (type == CDFDataType.UINT1) {
            short[] bexport = new short[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.UINT2) {
            int[] bexport = new int[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.UINT4) {
            long[] bexport = new long[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else {
            throw new IllegalArgumentException("not supported: " + type);
        }
        return export;
    }

    private static Object doIt2(QDataSet ds, UnitsConverter uc, CDFDataType type, ProgressMonitor mon) {
        Object[] export;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        iter.setMonitor(mon);
        int elements = ds.length() * ds.length(0);
        if (type == CDFDataType.DOUBLE || type == CDFDataType.EPOCH) {
            double[] dexport = new double[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == CDFDataType.TT2000) {
            long[] dexport = new long[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = (long)uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == CDFDataType.FLOAT) {
            float[] fexport = new float[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                fexport[i++] = (float)uc.convert(iter.getValue(ds));
            }
            export = fexport;
        } else if (type == CDFDataType.INT4) {
            int[] bexport = new int[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (int)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.INT2) {
            short[] bexport = new short[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.INT1) {
            byte[] bexport = new byte[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (byte)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.CHAR) {
            String[] s = new String[elements];
            for (int i = 0; i < ds.length(); ++i) {
                s[i] = ds.slice(i).svalue();
            }
            export = s;
        } else if (type == CDFDataType.UINT1) {
            short[] bexport = new short[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.UINT2) {
            int[] bexport = new int[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.UINT4) {
            long[] bexport = new long[elements];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else {
            throw new IllegalArgumentException("not supported: " + type);
        }
        return export;
    }

    public static Object datasetToArray(QDataSet ds, UnitsConverter uc, int itype, ProgressMonitor mon) {
        CDFDataType type = SupportedTypes.cdfType(itype);
        return CdfDataSourceFormat.datasetToArray(ds, uc, type, mon);
    }

    public static Object datasetToArray(QDataSet ds, UnitsConverter uc, CDFDataType type, ProgressMonitor mon) {
        if (uc == null) {
            uc = UnitsConverter.IDENTITY;
        }
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        switch (ds.rank()) {
            case 1: {
                return CdfDataSourceFormat.doIt1(ds, uc, type);
            }
            case 2: {
                Object oexport;
                if (type == CDFDataType.DOUBLE) {
                    oexport = new double[ds.length()][];
                } else if (type == CDFDataType.TT2000) {
                    oexport = new long[ds.length()][];
                } else if (type == CDFDataType.FLOAT) {
                    oexport = new float[ds.length()][];
                } else if (type == CDFDataType.INT4) {
                    oexport = new int[ds.length()][];
                } else if (type == CDFDataType.INT2) {
                    oexport = new short[ds.length()][];
                } else if (type == CDFDataType.INT1) {
                    oexport = new byte[ds.length()][];
                } else if (type == CDFDataType.CHAR) {
                    oexport = new String[ds.length()][];
                } else if (type == CDFDataType.UINT4) {
                    oexport = new long[ds.length()][];
                } else if (type == CDFDataType.UINT2) {
                    oexport = new int[ds.length()][];
                } else if (type == CDFDataType.UINT1) {
                    oexport = new short[ds.length()][];
                } else {
                    throw new IllegalArgumentException("type not supported: " + type);
                }
                mon.setTaskSize((long)ds.length());
                mon.started();
                for (int i = 0; i < ds.length(); ++i) {
                    mon.setTaskProgress((long)i);
                    Array.set(oexport, i, CdfDataSourceFormat.datasetToArray(ds.slice(i), uc, type, null));
                }
                mon.finished();
                return oexport;
            }
            case 3: {
                Object oexport;
                if (type == CDFDataType.DOUBLE) {
                    oexport = new double[ds.length()][][];
                } else if (type == CDFDataType.TT2000) {
                    oexport = new long[ds.length()][][];
                } else if (type == CDFDataType.FLOAT) {
                    oexport = new float[ds.length()][][];
                } else if (type == CDFDataType.INT4) {
                    oexport = new int[ds.length()][][];
                } else if (type == CDFDataType.INT2) {
                    oexport = new short[ds.length()][][];
                } else if (type == CDFDataType.INT1) {
                    oexport = new byte[ds.length()][][];
                } else {
                    throw new IllegalArgumentException("type not supported" + type);
                }
                mon.setTaskSize((long)ds.length());
                mon.started();
                for (int i = 0; i < ds.length(); ++i) {
                    mon.setTaskProgress((long)i);
                    Array.set(oexport, i, CdfDataSourceFormat.datasetToArray(ds.slice(i), uc, type, null));
                }
                mon.finished();
                return oexport;
            }
            case 4: {
                Object oexport;
                if (type == CDFDataType.DOUBLE) {
                    oexport = new double[ds.length()][][][];
                } else if (type == CDFDataType.TT2000) {
                    oexport = new long[ds.length()][][][];
                } else if (type == CDFDataType.FLOAT) {
                    oexport = new float[ds.length()][][][];
                } else if (type == CDFDataType.INT4) {
                    oexport = new int[ds.length()][][][];
                } else if (type == CDFDataType.INT2) {
                    oexport = new short[ds.length()][][][];
                } else if (type == CDFDataType.INT1) {
                    oexport = new byte[ds.length()][][][];
                } else {
                    throw new IllegalArgumentException("type not supported" + type);
                }
                mon.setTaskSize((long)ds.length());
                mon.started();
                for (int i = 0; i < ds.length(); ++i) {
                    mon.setTaskProgress((long)i);
                    Array.set(oexport, i, CdfDataSourceFormat.datasetToArray(ds.slice(i), uc, type, null));
                }
                mon.finished();
                return oexport;
            }
        }
        throw new IllegalArgumentException("rank 0 not supported");
    }

    private static void addVariableRankN(CDFWriter cdf, QDataSet ds, String name, boolean isSupport, Map<String, String> params, ProgressMonitor mon) throws Exception {
        boolean insert;
        Units units = (Units)ds.property("UNITS");
        CDFDataType type = CDFDataType.DOUBLE;
        String sinsert = params.get("insert");
        boolean bl = insert = sinsert != null && sinsert.startsWith("T");
        if (insert) {
            type = cdf.getVariableType(name);
        } else {
            String t = params.get("type");
            if (t != null) {
                switch (t) {
                    case "float": {
                        type = CDFDataType.FLOAT;
                        break;
                    }
                    case "byte": {
                        type = CDFDataType.INT1;
                        break;
                    }
                    case "int1": {
                        type = CDFDataType.INT1;
                        break;
                    }
                    case "int2": {
                        type = CDFDataType.INT2;
                        break;
                    }
                    case "int4": {
                        type = CDFDataType.INT4;
                        break;
                    }
                    case "uint1": {
                        type = CDFDataType.UINT1;
                        break;
                    }
                    case "uint2": {
                        type = CDFDataType.UINT2;
                        break;
                    }
                    case "uint4": {
                        type = CDFDataType.UINT4;
                        break;
                    }
                    case "double": {
                        type = CDFDataType.DOUBLE;
                        break;
                    }
                    case "string": {
                        type = CDFDataType.CHAR;
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "unsupported type, using double: {0}", t);
                        break;
                    }
                }
            } else {
                type = ds.rank() < 3 ? CDFDataType.DOUBLE : CDFDataType.FLOAT;
            }
        }
        boolean compressed = "T".equals(params.get("compressed"));
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            boolean tt2000;
            boolean bl2 = tt2000 = !"epoch".equals(params.get("timeType"));
            if (tt2000) {
                type = CDFDataType.TT2000;
                uc = units.getConverter((Units)Units.cdfTT2000);
                units = Units.cdfTT2000;
            } else {
                type = CDFDataType.EPOCH;
                uc = units.getConverter((Units)Units.cdfEpoch);
                units = Units.cdfEpoch;
            }
        }
        if (ds.rank() == 0) {
            throw new IllegalArgumentException("rank 0 data not supported");
        }
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("high rank data not supported");
        }
        if (compressed) {
            if (ds.rank() == 1) {
                logger.log(Level.FINE, "call cdf.defineCompressedVariable( {0}, {1}, {2} )", new Object[]{name, CdfDataSourceFormat.logName(type), CdfDataSourceFormat.logName(new int[0])});
                cdf.defineCompressedVariable(name, type, new int[0]);
                CdfDataSourceFormat.addData(cdf, name, CdfDataSourceFormat.dataSetToNioArray(ds, uc, type, mon));
            } else {
                switch (ds.rank()) {
                    case 2: {
                        CdfDataSourceFormat.defineCompressedVariable(cdf, name, type, new int[]{ds.length(0)});
                        break;
                    }
                    case 3: {
                        CdfDataSourceFormat.defineCompressedVariable(cdf, name, type, new int[]{ds.length(0), ds.length(0, 0)});
                        break;
                    }
                    case 4: {
                        CdfDataSourceFormat.defineCompressedVariable(cdf, name, type, new int[]{ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)});
                        break;
                    }
                }
                Object o = CdfDataSourceFormat.datasetToArray(ds, uc, type, mon);
                CdfDataSourceFormat.addData(cdf, name, o);
            }
        } else if (ds.rank() == 1) {
            if (!insert) {
                CdfDataSourceFormat.defineVariable(cdf, name, type, new int[0]);
                CdfDataSourceFormat.addData(cdf, name, CdfDataSourceFormat.dataSetToNioArray(ds, uc, type, mon));
            } else {
                CdfDataSourceFormat.addData(cdf, name, CdfDataSourceFormat.doIt1(ds, uc, type));
            }
        } else {
            if (!insert) {
                switch (ds.rank()) {
                    case 2: {
                        CdfDataSourceFormat.defineVariable(cdf, name, type, new int[]{ds.length(0)});
                        break;
                    }
                    case 3: {
                        CdfDataSourceFormat.defineVariable(cdf, name, type, new int[]{ds.length(0), ds.length(0, 0)});
                        break;
                    }
                    case 4: {
                        CdfDataSourceFormat.defineVariable(cdf, name, type, new int[]{ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)});
                        break;
                    }
                }
            }
            CdfDataSourceFormat.addData(cdf, name, CdfDataSourceFormat.datasetToArray(ds, uc, type, mon));
        }
        if (!insert) {
            CdfDataSourceFormat.copyMetadata(cdf, units, name, type, isSupport, ds);
        }
    }

    private static String logName(Object o) {
        if (o.getClass().isArray()) {
            StringBuilder s = new StringBuilder(o.getClass().getComponentType().toString() + "[");
            s.append(Array.getLength(o));
            if (Array.getLength(o) > 0) {
                o = Array.get(o, 0);
                while (o.getClass().isArray()) {
                    s.append(",").append(Array.getLength(o));
                    o = Array.get(o, 0);
                }
            }
            s.append("]");
            return s.toString();
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof CDFDataType) {
            return "CDFDataType=" + ((CDFDataType)o).getValue();
        }
        return o.toString();
    }

    private static void write(CDFWriter cdf, String name) throws IOException {
        logger.log(Level.FINE, "call cdf.write({0})", new Object[]{CdfDataSourceFormat.logName(name)});
        try {
            CdfDataSource.cdfCacheReset();
            cdf.write(name);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "first attempt to write \"{0}\" fails, try again for good measure", name);
            CdfDataSource.cdfCacheReset();
            System.gc();
            try {
                Thread.sleep(1000L);
                System.gc();
                Thread.sleep(1000L);
                System.gc();
            }
            catch (InterruptedException ex1) {
                logger.log(Level.SEVERE, null, ex1);
            }
            cdf.write(name);
        }
    }

    private static void defineCompressedVariable(CDFWriter cdf, String name, CDFDataType type, int[] dims) throws Exception {
        logger.log(Level.FINE, "call cdf.defineCompressedVariable({0},{1},{2})", new Object[]{CdfDataSourceFormat.logName(name), CdfDataSourceFormat.logName(type), CdfDataSourceFormat.logName(dims)});
        cdf.defineCompressedVariable(name, type, dims);
    }

    private static void defineVariable(CDFWriter cdf, String name, CDFDataType type, int[] dims) throws Exception {
        logger.log(Level.FINE, "call cdf.defineVariable({0},{1},{2})", new Object[]{CdfDataSourceFormat.logName(name), CdfDataSourceFormat.logName(type), CdfDataSourceFormat.logName(dims)});
        cdf.defineVariable(name, type, dims);
    }

    private static void addData(CDFWriter cdf, String name, Object d) throws Exception {
        logger.log(Level.FINE, "call cdf.addData({0},{1})", new Object[]{CdfDataSourceFormat.logName(name), CdfDataSourceFormat.logName(d)});
        cdf.addData(name, d);
    }

    private static void addVariableAttributeEntry(CDFWriter cdf, String varName, String attrName, CDFDataType type, Object o) throws CDFException.WriterError {
        logger.log(Level.FINE, "call cdf.addVariableAttributeEntry( {0}, {1}, {2}, {3} )", new Object[]{CdfDataSourceFormat.logName(varName), CdfDataSourceFormat.logName(attrName), CdfDataSourceFormat.logName(type), CdfDataSourceFormat.logName(o)});
        if (type == CDFDataType.CHAR && o.toString().length() == 0) {
            o = " ";
        }
        cdf.addVariableAttributeEntry(varName, attrName, type, o);
    }

    private static void copyMetadata(CDFWriter cdf, Units units, String name, CDFDataType type, boolean isSupport, QDataSet ds) throws Exception {
        String displayType;
        String format;
        String scaleTyp;
        Number fillval;
        String description;
        String title;
        if (units != null) {
            if (units == Units.cdfEpoch) {
                CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "UNITS", CDFDataType.CHAR, "ms");
            } else if (units == Units.cdfTT2000) {
                CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "UNITS", CDFDataType.CHAR, "ns");
            } else {
                CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "UNITS", CDFDataType.CHAR, units.toString());
            }
        } else {
            CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "UNITS", CDFDataType.CHAR, " ");
        }
        String label = (String)ds.property("LABEL");
        if (label != null && label.length() > 0) {
            if (units != null && label.endsWith("(" + units + ")")) {
                label = label.substring(0, label.length() - units.toString().length() - 2);
            }
            CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "LABLAXIS", CDFDataType.CHAR, label);
        }
        if ((title = (String)ds.property("TITLE")) != null && title.length() > 0) {
            CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "CATDESC", CDFDataType.CHAR, title);
        }
        if ((description = (String)ds.property("DESCRIPTION")) != null && description.length() > 0) {
            CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "VAR_NOTES", CDFDataType.CHAR, description);
        }
        Number vmax = (Number)ds.property("VALID_MAX");
        Number vmin = (Number)ds.property("VALID_MIN");
        if ((vmax != null || vmin != null) && units != Units.cdfEpoch) {
            if (units == Units.cdfTT2000) {
                if (vmax != null && vmin != null) {
                    cdf.addVariableAttributeEntry(name, "VALIDMIN", CDFDataType.TT2000, new long[]{vmin.longValue()});
                    cdf.addVariableAttributeEntry(name, "VALIDMAX", CDFDataType.TT2000, new long[]{vmax.longValue()});
                }
            } else {
                if (vmax == null) {
                    vmax = 1.0E38;
                }
                if (vmin == null) {
                    vmin = -1.0E38;
                }
                cdf.addVariableAttributeEntry(name, "VALIDMIN", type, new double[]{vmin.doubleValue()});
                cdf.addVariableAttributeEntry(name, "VALIDMAX", type, new double[]{vmax.doubleValue()});
            }
        }
        if ((fillval = (Number)ds.property("FILL_VALUE")) != null && units != Units.cdfEpoch) {
            if (units == Units.cdfTT2000) {
                cdf.addVariableAttributeEntry(name, "FILLVAL", CDFDataType.TT2000, new long[]{fillval.longValue()});
            } else {
                cdf.addVariableAttributeEntry(name, "FILLVAL", type, new double[]{fillval.doubleValue()});
            }
        }
        Number smax = (Number)ds.property("TYPICAL_MAX");
        Number smin = (Number)ds.property("TYPICAL_MIN");
        if ((smax != null || smin != null) && units != Units.cdfEpoch) {
            if (units == Units.cdfTT2000) {
                if (smax == null) {
                    smax = Units.cdfTT2000.parse("1958-01-01T00:00").doubleValue((Units)Units.cdfTT2000);
                }
                if (smin == null) {
                    smin = Units.cdfTT2000.parse("2058-01-01T00:00").doubleValue((Units)Units.cdfTT2000);
                }
                cdf.addVariableAttributeEntry(name, "SCALEMIN", CDFDataType.TT2000, new long[]{smin.longValue()});
                cdf.addVariableAttributeEntry(name, "SCALEMAX", CDFDataType.TT2000, new long[]{smax.longValue()});
            } else {
                if (smax == null) {
                    smax = 1.0E38;
                }
                if (smin == null) {
                    smin = -1.0E38;
                }
                cdf.addVariableAttributeEntry(name, "SCALEMIN", type, new double[]{smin.doubleValue()});
                cdf.addVariableAttributeEntry(name, "SCALEMAX", type, new double[]{smax.doubleValue()});
            }
        }
        if ((scaleTyp = (String)ds.property("SCALE_TYPE")) != null) {
            CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "SCALETYP", CDFDataType.CHAR, scaleTyp);
        }
        if ((format = (String)ds.property("FORMAT")) != null && format.trim().length() > 0) {
            CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "FORMAT", CDFDataType.CHAR, format);
        }
        if ((displayType = (String)ds.property("RENDER_TYPE")) == null || displayType.length() == 0) {
            displayType = DataSourceUtil.guessRenderType((QDataSet)ds);
        }
        switch (displayType) {
            case "nnSpectrogram": 
            case "spectrogram": {
                displayType = "spectrogram";
                break;
            }
            case "image": {
                displayType = "image";
                break;
            }
            case "series": 
            case "scatter": 
            case "hugeScatter": {
                displayType = "time_series";
                break;
            }
        }
        CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "DISPLAY_TYPE", CDFDataType.CHAR, displayType);
        CdfDataSourceFormat.addVariableAttributeEntry(cdf, name, "VAR_TYPE", CDFDataType.CHAR, isSupport ? "support_data" : "data");
    }

    public boolean canFormat(QDataSet ds) {
        return ds.rank() != 0 && !SemanticOps.isJoin((QDataSet)ds);
    }

    public String getDescription() {
        return "NASA Common Data Format";
    }
}

