/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import java.lang.reflect.Array;
import java.util.logging.Logger;
import org.autoplot.cdf.TrDDataSet;
import org.autoplot.cdf.TrFDataSet;
import org.autoplot.cdf.TrLDataSet;
import org.das2.qds.AbstractDataSet;

public abstract class TrArrayDataSet
extends AbstractDataSet {
    protected static final Logger logger = Logger.getLogger("apdss.cdfj");
    float fill = Float.NaN;
    double dfill = Double.NaN;

    public static TrArrayDataSet wrap(Object array, int[] qube, boolean copy) {
        Object arr;
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("input must be an array");
        }
        Class<?> c = array.getClass().getComponentType();
        if (c.isArray()) {
            throw new IllegalArgumentException("input must be 1-D array");
        }
        if (copy) {
            arr = Array.newInstance(c, Array.getLength(array));
            System.arraycopy(array, 0, arr, 0, Array.getLength(array));
        } else {
            arr = array;
        }
        if (c == Double.TYPE) {
            return TrDDataSet.wrap((double[])arr, qube);
        }
        if (c == Float.TYPE) {
            return TrFDataSet.wrap((float[])arr, qube);
        }
        if (c == Long.TYPE) {
            return TrLDataSet.wrap((long[])arr, qube);
        }
        throw new IllegalArgumentException("component type not supported: " + c);
    }

    public Class getComponentType() {
        return this.getBack().getClass().getComponentType();
    }

    protected abstract Object getBack();

    public int jvmMemory() {
        int sizePer;
        Class component = this.getComponentType();
        if (component == Double.TYPE) {
            sizePer = 8;
        } else if (component == Float.TYPE) {
            sizePer = 4;
        } else if (component == Long.TYPE) {
            sizePer = 8;
        } else if (component == Integer.TYPE) {
            sizePer = 4;
        } else if (component == Short.TYPE) {
            sizePer = 2;
        } else if (component == Byte.TYPE) {
            sizePer = 1;
        } else {
            throw new IllegalArgumentException("not supported " + component);
        }
        return Array.getLength(this.getBack()) * sizePer;
    }

    protected void checkFill() {
        Number f = (Number)this.properties.get("FILL_VALUE");
        if (f != null) {
            this.fill = f.floatValue();
            this.dfill = f.doubleValue();
        } else {
            this.fill = Float.NaN;
            this.dfill = Double.NaN;
        }
    }
}

