/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qstream.QdsToD2sStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class QdsToDas23
extends QdsToD2sStream {
    private static final Logger log = LoggerManager.getLogger((String)"qstream");
    public static final String OFFSET_1 = "OFFSET_1";
    public static final String OFFSET_2 = "OFFSET_2";
    public static final String OFFSET_3 = "OFFSET_3";
    public static final String REFERENCE = "REFERENCE";
    public static final String AXIS = "AXIS";
    public static final double DEF_SEQ_JITTER = 0.001;
    static final String[] aStdPlaneProps = new String[]{"BIN_MIN", "BIN_MAX", "BIN_MINUS", "BIN_PLUS", "DELTA_MINUS", "DELTA_PLUS", "WEIGHTS"};

    public QdsToDas23() {
    }

    public QdsToDas23(int genSigDigits, int fracSecDigits) {
        super(genSigDigits, fracSecDigits);
    }

    @Override
    public boolean canWrite(QDataSet qds) {
        if (SemanticOps.isJoin((QDataSet)qds)) {
            for (int i = 0; i < qds.length(); ++i) {
                if (this._canWriteNonJoin((QDataSet)DataSetOps.slice0((QDataSet)qds, (int)i))) continue;
                return false;
            }
            return true;
        }
        return this._canWriteNonJoin(qds);
    }

    @Override
    public boolean write(QDataSet qds, OutputStream os) throws IOException {
        int iPktId;
        String sPktHdr;
        QdsToD2sStream.PacketXferInfo pi;
        if (!this.canWrite(qds)) {
            return false;
        }
        ArrayList<String> lHdrsToSend = new ArrayList<String>();
        Document doc = this._makeStreamHdr(qds);
        if (doc == null) {
            return false;
        }
        lHdrsToSend.add(QdsToDas23.xmlDocToStr(doc));
        Element elStreamProps = null;
        Element elStream = doc.getDocumentElement();
        NodeList nl = elStream.getElementsByTagName("properties");
        if (nl != null && nl.getLength() > 0) {
            elStreamProps = (Element)nl.item(0);
        }
        ArrayList<QdsToD2sStream.PacketXferInfo> lPi = new ArrayList<QdsToD2sStream.PacketXferInfo>();
        double rMaxSeqJitter = 0.001;
        List<QDataSet> lDs = this._maybeCollapseSeprableJoin(qds);
        qds = lDs.get(0);
        QDataSet dsRef = null;
        if (lDs.size() > 1) {
            dsRef = lDs.get(1);
            rMaxSeqJitter = 0.05;
        }
        if (SemanticOps.isJoin((QDataSet)qds)) {
            for (int i = 0; i < qds.length(); ++i) {
                MutablePropertyDataSet ds = DataSetOps.slice0((QDataSet)qds, (int)i);
                pi = this._makePktXferInfo((QDataSet)ds, null, elStreamProps, rMaxSeqJitter);
                if (pi == null) {
                    return false;
                }
                lPi.add(pi);
                sPktHdr = QdsToDas23.xmlDocToStr(pi.doc);
                lHdrsToSend.add(sPktHdr);
            }
        } else {
            pi = this._makePktXferInfo(qds, dsRef, elStreamProps, rMaxSeqJitter);
            if (pi == null) {
                return false;
            }
            lPi.add(pi);
            sPktHdr = QdsToDas23.xmlDocToStr(pi.doc);
            lHdrsToSend.add(sPktHdr);
        }
        for (iPktId = 0; iPktId < lHdrsToSend.size(); ++iPktId) {
            QdsToDas23.writeHeader(os, 1, iPktId, (String)lHdrsToSend.get(iPktId));
        }
        for (QdsToD2sStream.PacketXferInfo pktinfo : lPi) {
            sPktHdr = QdsToDas23.xmlDocToStr(pktinfo.doc);
            iPktId = lHdrsToSend.indexOf(sPktHdr);
            this.writeData(os, 1, iPktId, pktinfo);
        }
        return true;
    }

    boolean _canWriteNonJoin(QDataSet qds) {
        if (qds instanceof BundleDataSet) {
            for (int i = 0; i < qds.length(0); ++i) {
                QDataSet ds = ((BundleDataSet)qds).unbundle(i);
                if (ds instanceof BundleDataSet) {
                    return false;
                }
                if (ds.rank() <= 3) continue;
                return false;
            }
            return true;
        }
        return qds.rank() <= 3;
    }

    List<QDataSet> _maybeCollapseSeprableJoin(QDataSet dsJoin) throws IOException {
        ArrayList<QDataSet> lDs = new ArrayList<QDataSet>();
        lDs.add(dsJoin);
        if (!SemanticOps.isJoin((QDataSet)dsJoin)) {
            return lDs;
        }
        if (dsJoin.length() < 2) {
            return lDs;
        }
        MutablePropertyDataSet dsBeg = DataSetOps.slice0((QDataSet)dsJoin, (int)0);
        if (dsBeg.rank() != 2) {
            return lDs;
        }
        if (dsBeg instanceof BundleDataSet) {
            return lDs;
        }
        QDataSet dsBegDep1 = (QDataSet)dsBeg.property("DEPEND_1");
        if (dsBegDep1 == null || dsBegDep1.rank() != 1) {
            return lDs;
        }
        Units units = (Units)dsBegDep1.property("UNITS");
        String sUnitsBegDep1 = units != null ? units.toString() : "";
        ArrayDataSet dsAllDep1 = ArrayDataSet.createRank2((Class)DataSetOps.getComponentType((QDataSet)dsBegDep1), (int)dsJoin.length(), (int)dsBeg.length(0));
        this.copySimpleProps((MutablePropertyDataSet)dsAllDep1, dsBegDep1);
        for (int j = 0; j < dsBegDep1.length(); ++j) {
            dsAllDep1.putValue(0, j, dsBegDep1.value(j));
        }
        int nTotalLen = dsBeg.length();
        for (int J = 1; J < dsJoin.length(); ++J) {
            String sUnits;
            MutablePropertyDataSet ds = DataSetOps.slice0((QDataSet)dsJoin, (int)J);
            if (ds.rank() != dsBeg.rank() || ds.length(0) != dsBeg.length(0)) {
                return lDs;
            }
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 == null || dep1.rank() != dsBegDep1.rank() || dep1.length() != dsAllDep1.length(0)) {
                return lDs;
            }
            units = (Units)dep1.property("UNITS");
            String string = sUnits = units != null ? units.toString() : "";
            if (!sUnitsBegDep1.equals(sUnits)) {
                return lDs;
            }
            for (int j = 0; j < dsBegDep1.length(); ++j) {
                dsAllDep1.putValue(J, j, dep1.value(j));
            }
            nTotalLen += ds.length();
        }
        SeparablePair pair = this._separable0((QDataSet)dsAllDep1, 0.05);
        if (pair == null) {
            return lDs;
        }
        pair.offset.putProperty(AXIS, (Object)"y");
        ArrayDataSet dsAll = ArrayDataSet.createRank2((Class)DataSetOps.getComponentType((QDataSet)dsBeg), (int)nTotalLen, (int)dsBeg.length(0));
        this.copySimpleProps((MutablePropertyDataSet)dsAll, (QDataSet)dsBeg);
        ArrayDataSet dsRef = ArrayDataSet.createRank1((Class)DataSetOps.getComponentType((QDataSet)pair.reference), (int)nTotalLen);
        this.copySimpleProps((MutablePropertyDataSet)dsRef, (QDataSet)pair.reference);
        ArrayDataSet dsAllDep0 = null;
        QDataSet dsDep0 = (QDataSet)dsBeg.property("DEPEND_0");
        if (dsDep0 != null) {
            dsAllDep0 = ArrayDataSet.createRank1((Class)DataSetOps.getComponentType((QDataSet)dsDep0), (int)nTotalLen);
            this.copySimpleProps((MutablePropertyDataSet)dsAllDep0, dsDep0);
        }
        int nOffset = 0;
        for (int J = 0; J < dsJoin.length(); ++J) {
            MutablePropertyDataSet ds = DataSetOps.slice0((QDataSet)dsJoin, (int)J);
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            for (int i = 0; i < ds.length(); ++i) {
                for (int j = 0; j < ds.length(0); ++j) {
                    dsAll.putValue(i + nOffset, j, ds.value(i, j));
                }
                if (dsAllDep0 != null) {
                    dsAllDep0.putValue(i + nOffset, dep0.value(i));
                }
                dsRef.putValue(i + nOffset, pair.reference.value(J));
            }
            nOffset += ds.length();
        }
        this.copySimpleProps((MutablePropertyDataSet)dsAll, (QDataSet)dsBeg);
        if (dsAllDep0 != null) {
            dsRef.putProperty("DEPEND_0", (Object)dsAllDep0);
            dsAll.putProperty("DEPEND_0", (Object)dsAllDep0);
        }
        if (dsAll.property(OFFSET_1) != null) {
            throw new IOException(String.format("dataset %s already has an offset_1, looks like we need to use planes", dsAll.toString()));
        }
        dsAll.putProperty(OFFSET_1, (Object)pair.offset);
        lDs.clear();
        lDs.add((QDataSet)dsAll);
        lDs.add((QDataSet)dsRef);
        return lDs;
    }

    SeparablePair _separable0(QDataSet ds, double rMaxJitter) {
        int j;
        int i;
        if (ds.rank() < 2) {
            return null;
        }
        double[][] aOffsets = new double[ds.length()][ds.length(0)];
        ArrayDataSet dsRef = ArrayDataSet.createRank1(Double.TYPE, (int)ds.length());
        for (i = 0; i < ds.length(); ++i) {
            for (j = 0; j < ds.length(0); ++j) {
                aOffsets[i][j] = ds.value(i, j) - ds.value(i, 0);
            }
            dsRef.putValue(i, ds.value(i, 0));
        }
        double[] aAvgOffset = new double[ds.length(0)];
        j = 0;
        while (j < ds.length(0)) {
            aAvgOffset[j] = 0.0;
            for (i = 0; i < ds.length(); ++i) {
                int n = j;
                aAvgOffset[n] = aAvgOffset[n] + aOffsets[i][j];
            }
            int n = j++;
            aAvgOffset[n] = aAvgOffset[n] / (double)ds.length();
        }
        for (i = 0; i < ds.length(); ++i) {
            for (j = 0; j < ds.length(0); ++j) {
                double rAvg = Math.abs(aAvgOffset[j] + aOffsets[i][j]) / 2.0;
                double rDelta = Math.abs(aAvgOffset[j] - aOffsets[i][j]);
                if (rDelta == 0.0) continue;
                if (rAvg == 0.0) {
                    return null;
                }
                double rJitter = rDelta / rAvg;
                if (!(rJitter > rMaxJitter)) continue;
                return null;
            }
        }
        ArrayDataSet dsOffset = ArrayDataSet.createRank1(Double.TYPE, (int)ds.length(0));
        for (j = 0; j < ds.length(0); ++j) {
            dsOffset.putValue(j, aAvgOffset[j]);
        }
        this.copySimpleProps((MutablePropertyDataSet)dsRef, ds);
        this.copySimpleProps((MutablePropertyDataSet)dsOffset, ds);
        Units units = (Units)ds.property("UNITS");
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            dsOffset.putProperty("UNITS", (Object)units.getOffsetUnits());
        }
        return new SeparablePair(dsRef, dsOffset);
    }

    Document _makeStreamHdr(QDataSet qds) {
        Document doc = this.newXmlDoc();
        Element stream = doc.createElement("stream");
        stream.setAttribute("version", "2.3/basic");
        Element props = doc.createElement("properties");
        int nProps = 0;
        nProps += this._addStrProp(null, props, qds, "TITLE", "title");
        nProps += this._addStrProp(null, props, qds, "DESCRIPTION", "summary");
        nProps += this._addStrProp(null, props, qds, "RENDER_TYPE", "renderer");
        String sAxis = QdsToDas23.getQdsAxis(qds);
        if (sAxis == null) {
            return null;
        }
        nProps += this._addSimpleProps(null, props, qds, sAxis);
        Map dUser = (Map)qds.property("USER_PROPERTIES");
        boolean bStripDot = this._stripDotProps(qds);
        if (dUser != null) {
            nProps += this._addPropsFromMap(null, props, dUser, bStripDot);
        }
        if (nProps > 0) {
            stream.appendChild(props);
        }
        doc.appendChild(stream);
        return doc;
    }

    QdsToD2sStream.PacketXferInfo _makePktXferInfo(QDataSet qds, QDataSet dsRef, Element elStreamProp, double rMaxSeqJitter) throws IOException {
        QDataSet dep1;
        MutablePropertyDataSet dsSwap;
        ArrayList<QdsToD2sStream.QdsXferInfo> lDsXfer = new ArrayList<QdsToD2sStream.QdsXferInfo>();
        Document doc = this.newXmlDoc();
        Element elPkt = doc.createElement("packet");
        doc.appendChild(elPkt);
        assert (!SemanticOps.isJoin((QDataSet)qds));
        ArrayList<QDataSet> lDsToRead = new ArrayList<QDataSet>();
        ArrayList<Object> lDsRemain = new ArrayList<Object>();
        if (qds instanceof BundleDataSet) {
            for (int i = 0; i < qds.length(0); ++i) {
                lDsToRead.add(((BundleDataSet)qds).unbundle(i));
            }
        } else {
            lDsToRead.add(qds);
        }
        for (QDataSet qDataSet : lDsToRead) {
            QDataSet dep0 = (QDataSet)qDataSet.property("DEPEND_0");
            if (dep0 != null) {
                if (lDsXfer.isEmpty()) {
                    this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "x", dep0);
                } else if (dep0 != ((QdsToD2sStream.QdsXferInfo)lDsXfer.get((int)0)).qds) {
                    this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "x", dep0);
                }
                lDsRemain.add(qDataSet);
                continue;
            }
            if (qDataSet.rank() != 1 || qDataSet.property("DEPEND_0") != null) continue;
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "x", qDataSet);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        for (QDataSet ds : lDsToRead) {
            if (SemanticOps.isRank2Waveform((QDataSet)ds)) {
                dsSwap = DataSetOps.makePropertiesMutable((QDataSet)ds);
                dep1 = (QDataSet)dsSwap.property("DEPEND_1");
                MutablePropertyDataSet dep1Swap = DataSetOps.makePropertiesMutable((QDataSet)dep1);
                dsSwap.putProperty("DEPEND_1", null);
                dep1Swap.putProperty(AXIS, (Object)"x");
                dep1Swap.putProperty(REFERENCE, dsSwap.property("DEPEND_0"));
                dsSwap.putProperty(OFFSET_1, (Object)dep1Swap);
                this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "yset", (QDataSet)dsSwap, rMaxSeqJitter);
                continue;
            }
            lDsRemain.add(ds);
        }
        if (dsRef != null) {
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "y", dsRef);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        for (QDataSet ds : lDsToRead) {
            dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 == null) {
                lDsRemain.add(ds);
                continue;
            }
            if (dep1.rank() < 2) {
                lDsRemain.add(ds);
                continue;
            }
            SeparablePair pair = this._separable0(dep1, rMaxSeqJitter * 10.0);
            if (pair != null) {
                this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "y", (QDataSet)pair.reference);
                pair.offset.putProperty(AXIS, (Object)"y");
                dsSwap = DataSetOps.makePropertiesMutable((QDataSet)ds);
                dsSwap.putProperty("DEPEND_1", null);
                if (dsSwap.property(OFFSET_1) != null) {
                    throw new IOException(String.format("dataset %s already has an offset_1, looks like we need to use planes", dsSwap.toString()));
                }
                dsSwap.putProperty(OFFSET_1, (Object)pair.offset);
                lDsRemain.add(dsSwap);
                if (!(rMaxSeqJitter < 0.02)) continue;
                rMaxSeqJitter = 0.02;
                continue;
            }
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "yset", dep1, rMaxSeqJitter);
            lDsRemain.add(ds);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        Object var16_16 = null;
        for (QDataSet ds : lDsToRead) {
            if (ds.rank() > 1) {
                lDsRemain.add(ds);
                continue;
            }
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "y", ds);
            QDataSet qDataSet = (QDataSet)ds.property("PLANE_0");
            if (qDataSet == null) continue;
            if (SemanticOps.isBundle((QDataSet)qDataSet)) {
                for (int i = 0; i < qDataSet.length(); ++i) {
                    MutablePropertyDataSet dsSubZ = DataSetOps.slice0((QDataSet)qDataSet, (int)i);
                    lDsRemain.add(dsSubZ);
                }
                continue;
            }
            lDsRemain.add(qDataSet);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        for (QDataSet ds : lDsToRead) {
            if (ds.rank() == 2) {
                this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "zset", ds, rMaxSeqJitter);
                continue;
            }
            lDsRemain.add(ds);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        for (QDataSet ds : lDsToRead) {
            QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
            if (dep2 == null) {
                lDsRemain.add(ds);
                continue;
            }
            if (dep2.rank() < 2) {
                lDsRemain.add(ds);
                continue;
            }
            SeparablePair pair = this._separable0(dep2, 1.0E-5);
            if (pair == null) continue;
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "z", (QDataSet)pair.reference);
            dsSwap = DataSetOps.makePropertiesMutable((QDataSet)ds);
            dsSwap.putProperty("DEPEND_2", null);
            if (dsSwap.property(OFFSET_2) != null) {
                throw new IOException(String.format("dataset %s already has an offset_2, looks like we need to use planes", dsSwap.toString()));
            }
            dsSwap.putProperty(OFFSET_2, (Object)pair.offset);
            pair.offset.putProperty(AXIS, (Object)"z");
            lDsRemain.add(dsSwap);
            if (!(rMaxSeqJitter < 0.02)) continue;
            rMaxSeqJitter = 0.02;
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        for (QDataSet ds : lDsToRead) {
            if (ds.rank() > 1) {
                lDsRemain.add(ds);
                continue;
            }
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "z", ds);
        }
        lDsToRead = lDsRemain;
        lDsRemain = new ArrayList();
        for (QDataSet ds : lDsToRead) {
            if (ds.rank() != 3) {
                lDsRemain.add(ds);
                continue;
            }
            this._addPhysicalDimension(elStreamProp, elPkt, lDsXfer, "wset", ds, rMaxSeqJitter);
        }
        if (!lDsRemain.isEmpty()) {
            throw new IOException("das2.3 output bug, the following dataset (and maybe more) were not output: '" + ((QDataSet)lDsRemain.get(0)).toString() + "'");
        }
        return new QdsToD2sStream.PacketXferInfo(doc, lDsXfer);
    }

    int _addPhysicalDimension(Element elStreamProps, Element elPkt, List<QdsToD2sStream.QdsXferInfo> lXfer, String sAxis, QDataSet ds) throws IOException {
        return this._addPhysicalDimension(elStreamProps, elPkt, lXfer, sAxis, ds, 0.001);
    }

    int _addPhysicalDimension(Element elParent, Element elPkt, List<QdsToD2sStream.QdsXferInfo> lXfer, String sAxis, QDataSet ds, double rMaxSeqJitter) throws IOException {
        String sAx;
        String[][] aCoordProps;
        int nArrays = 0;
        boolean bSet = sAxis.endsWith("set");
        Document doc = elPkt.getOwnerDocument();
        Element elPdim = doc.createElement(sAxis);
        elPkt.appendChild(elPdim);
        QdsToD2sStream.QdsXferInfo xfer = new QdsToD2sStream.QdsXferInfo(ds, this.bBinary, this.nSigDigit, this.nSecDigit);
        lXfer.add(xfer);
        String sPdim = this._getPhysDim(elPkt, ds, sAxis);
        elPdim.setAttribute("pdim", sPdim);
        if (bSet) {
            elPdim.setAttribute("nitems", String.format("%d", xfer.xSliceItems(0)));
        }
        Element elAry = doc.createElement("array");
        elAry.setAttribute("type", this._makeTypeFromXfer(xfer));
        Units units = (Units)ds.property("UNITS");
        elAry.setAttribute("units", units != null ? units.toString() : "");
        elAry.setAttribute("use", "center");
        elPdim.appendChild(elAry);
        ++nArrays;
        for (String sProp : aStdPlaneProps) {
            QDataSet dsStats = (QDataSet)ds.property(sProp);
            if (dsStats == null) continue;
            if (dsStats.rank() != ds.rank()) {
                throw new IOException(String.format("Statistics dataset '%s' for main dataset '%s' is not the same rank", ds.toString(), dsStats.toString()));
            }
            QdsToD2sStream.QdsXferInfo xferStats = new QdsToD2sStream.QdsXferInfo(dsStats, this.bBinary, this.nSigDigit, this.nSecDigit);
            elAry = doc.createElement("array");
            elAry.setAttribute("use", QdsToDas23._statsName(sProp));
            elAry.setAttribute("type", this._makeTypeFromXfer(xferStats));
            elPdim.appendChild(elAry);
            ++nArrays;
        }
        for (String[] aProps : aCoordProps = new String[][]{{"DEPEND_1", OFFSET_1, "y"}, {"DEPEND_2", OFFSET_2, "z"}}) {
            String sDep = aProps[0];
            String sOff = aProps[1];
            String sCoordAx = aProps[2];
            Element elCoord = null;
            Element elProps = null;
            QDataSet dsCoords = (QDataSet)ds.property(sDep);
            if (dsCoords != null) {
                if (elCoord == null) {
                    elCoord = doc.createElement(sCoordAx + "coord");
                }
                elCoord.setAttribute("pdim", this._getPhysDim(elPkt, dsCoords, sCoordAx));
                this._addValsToCoord(elCoord, dsCoords, "center", rMaxSeqJitter);
                elProps = doc.createElement("properties");
                if (this._addSimpleProps(elParent, elProps, dsCoords, sCoordAx) == 0) {
                    elProps = null;
                }
            }
            if ((dsCoords = (QDataSet)ds.property(sOff)) != null) {
                QDataSet dsRef = (QDataSet)dsCoords.property(REFERENCE);
                String sCoordName = (String)dsCoords.property(AXIS) + "coord";
                String sDim = this._getPhysDim(elPkt, dsRef, (String)dsCoords.property(AXIS));
                if (elCoord == null) {
                    elCoord = doc.createElement(sCoordName);
                }
                elCoord.setAttribute("pdim", sDim);
                this._addValsToCoord(elCoord, dsCoords, "offset", rMaxSeqJitter);
                if (elProps == null && this._addSimpleProps(elParent, elProps = doc.createElement("properties"), dsCoords, sCoordAx) == 0) {
                    elProps = null;
                }
            }
            if (elCoord != null && elProps != null) {
                elCoord.appendChild(elProps);
            }
            if (elCoord == null) continue;
            elPdim.appendChild(elCoord);
        }
        Element elProps = doc.createElement("properties");
        if (this._addSimpleProps(elParent, elProps, ds, sAx = sAxis.substring(0, 1)) != 0) {
            elPdim.appendChild(elProps);
        }
        return nArrays;
    }

    int _addValsToCoord(Element el, QDataSet ds, String sUse, double rMaxSeqJitter) throws IOException {
        String sUnits;
        Document doc = el.getOwnerDocument();
        Units units = (Units)ds.property("UNITS");
        String string = sUnits = units != null ? units.toString() : "";
        if (ds.rank() > 1) {
            throw new IOException("TODO: Handle N-D coordinates");
        }
        QdsToD2sStream.Sequence1D seq = this.getSequenceRank1(ds, rMaxSeqJitter);
        if (seq != null) {
            Element elSeq = doc.createElement("sequence");
            elSeq.setAttribute("use", sUse);
            elSeq.setAttribute("minval", seq.sMinval);
            elSeq.setAttribute("interval", seq.sInterval);
            elSeq.setAttribute("units", sUnits);
            el.appendChild(elSeq);
            return 1;
        }
        Element elVals = doc.createElement("values");
        elVals.setAttribute("use", sUse);
        elVals.setAttribute("units", sUnits);
        String sVals = this._getValueSet(ds);
        elVals.setTextContent(sVals);
        el.appendChild(elVals);
        return 1;
    }

    String _getPhysDim(Element elPkt, QDataSet ds, String sAxis) throws IOException {
        String sName = (String)ds.property("NAME");
        if (sName != null) {
            return sName;
        }
        Units units = (Units)ds.property("UNITS");
        sName = this.makeNameFromUnits(units);
        if (sName.length() >= 0) {
            return sName;
        }
        if (sAxis == null || sAxis.length() == 0) {
            throw new IOException("Can't find physical dimension name by axis search, no axis specified");
        }
        int n = elPkt.getElementsByTagName(sAxis).getLength();
        return String.format("%s_%d", sAxis.toUpperCase(), n);
    }

    String _makeTypeFromXfer(QdsToD2sStream.QdsXferInfo xfer) throws IOException {
        String sName = xfer.name();
        int nSz = xfer.size();
        String sReal = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little_endian_real" : "big_endian_real";
        String sInt = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little_endian_int" : "big_endian_int";
        switch (sName) {
            case "double": {
                return String.format("%s8", sReal);
            }
            case "float": {
                return String.format("%s4", sReal);
            }
            case "ascii": {
                return String.format("ascii%d", nSz);
            }
            case "time": {
                return String.format("time%d", nSz);
            }
            case "char": {
                return String.format("char%d", nSz);
            }
            case "int": {
                return String.format("%s4", sInt);
            }
            case "long": {
                return String.format("%s8", sInt);
            }
        }
        throw new IOException(String.format("das2.3 streams cannot transmit data values of type %s%d", sName, nSz));
    }

    static String _statsName(String sProp) {
        switch (sProp) {
            case "BIN_MIN": {
                return "min";
            }
            case "BIN_MAX": {
                return "max";
            }
            case "BIN_MINUS": {
                return "min";
            }
            case "BIN_PLUS": {
                return "max";
            }
            case "DELTA_MINUS": {
                return "min_error";
            }
            case "DELTA_PLUS": {
                return "max_error";
            }
            case "WEIGHTS": {
                return "count";
            }
        }
        return "unknown";
    }

    String _getValueSet(QDataSet ds) {
        String sFmt = String.format("%%.%de", this.nSigDigit);
        StringBuilder sb = new StringBuilder();
        String sNL = "\n            ";
        sb.append(sNL);
        sb.append(String.format(sFmt, ds.value(0)));
        for (int i = 1; i < ds.length(); ++i) {
            sb.append(",");
            if (i % 8 == 0) {
                sb.append(sNL);
            } else {
                sb.append(" ");
            }
            sb.append(String.format(sFmt, ds.value(i)));
        }
        sb.append("\n        ");
        return sb.toString();
    }

    int _addBoolProp(Element parent, Element props, String sName, Object oValue) {
        String sValue = (Boolean)oValue != false ? "true" : "false";
        return this._addChildProp(parent, props, sName, "boolean", sValue);
    }

    int _addStrProp(Element parent, Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this._addStrProp(parent, props, d2key, oProp);
        }
        return 0;
    }

    int _addStrProp(Element parent, Element props, String sName, Object oValue) {
        String sInput = (String)oValue;
        Pattern p = Pattern.compile("%\\{ *USER_PROPERTIES\\.");
        Matcher m = p.matcher(sInput);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "%{");
        }
        m.appendTail(sb);
        String sOutput = sb.toString();
        return this._addChildProp(parent, props, sName, null, sOutput);
    }

    int _addRealProp(Element parent, Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this._addRealProp(parent, props, d2key, oProp);
        }
        return 0;
    }

    int _addRealProp(Element parent, Element props, String sName, Object oValue) {
        Number num = (Number)oValue;
        String sVal = String.format("%.6e", num.doubleValue());
        return this._addChildProp(parent, props, sName, "double", sVal);
    }

    int _addDatumProp(Element parent, Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this._addDatumProp(parent, props, d2key, oProp);
        }
        return 0;
    }

    int _addDatumProp(Element parent, Element props, String sName, Object oValue) {
        Datum datum = (Datum)oValue;
        return this._addChildProp(parent, props, sName, "Datum", datum.toString());
    }

    int _addRngProp(Element parent, Element props, QDataSet qds, String sMinKey, String sMaxKey, String sUnitsKey, String d2key) {
        Object oMin = qds.property(sMinKey);
        Object oMax = qds.property(sMaxKey);
        Object oUnits = qds.property(sUnitsKey);
        if (oMin == null || oMax == null) {
            return 0;
        }
        double rMin = ((Number)oMin).doubleValue();
        double rMax = ((Number)oMax).doubleValue();
        DatumRange dr = oUnits != null ? new DatumRange(rMin, rMax, (Units)oUnits) : new DatumRange(rMin, rMax, Units.dimensionless);
        return this._addChildProp(parent, props, d2key, "DatumRange", dr.toString());
    }

    int _addRngProp(Element parent, Element props, String sName, Object oValue) {
        String sOutput;
        DatumRange rng = (DatumRange)oValue;
        Units units = rng.getUnits();
        if (units instanceof TimeLocationUnits) {
            Datum dmMin = rng.min();
            Datum dmMax = rng.max();
            sOutput = String.format("%s to %s UTC", dmMin.toString().replaceAll("Z", ""), dmMax.toString().replaceAll("Z", ""));
        } else {
            sOutput = rng.toString();
        }
        return this._addChildProp(parent, props, sName, "DatumRange", sOutput);
    }

    int _addChildProp(Element parent, Element props, String sName, String sType, String sVal) {
        if (parent != null) {
            NodeList nl = parent.getElementsByTagName("p");
            for (int i = 0; i < nl.getLength(); ++i) {
                String sParVal;
                Element elParProp = (Element)nl.item(i);
                String sParName = elParProp.getAttribute("name");
                if (!sParName.equals(sName) || !(sParVal = elParProp.getTextContent()).equals(sVal)) continue;
                return 0;
            }
        }
        Document doc = props.getOwnerDocument();
        Element prop = doc.createElement("p");
        prop.setAttribute("name", sName);
        if (sType != null) {
            prop.setAttribute("type", sType);
        }
        Text text = doc.createTextNode(sVal);
        prop.appendChild(text);
        props.appendChild(prop);
        return 1;
    }

    int _addSimpleProps(Element parent, Element props, QDataSet qds, String sAxis) {
        int nProps = 0;
        nProps += this._addStrProp(parent, props, qds, "FORMAT", sAxis + "Format");
        nProps += this._addStrProp(parent, props, qds, "SCALE_TYPE", sAxis + "ScaleType");
        nProps += this._addStrProp(parent, props, qds, "LABEL", sAxis + "Label");
        nProps += this._addStrProp(parent, props, qds, "DESCRIPTION", sAxis + "Summary");
        nProps += this._addRealProp(parent, props, qds, "FILL_VALUE", sAxis + "Fill");
        nProps += this._addRealProp(parent, props, qds, "VALID_MIN", sAxis + "ValidMin");
        nProps += this._addRealProp(parent, props, qds, "VALID_MAX", sAxis + "ValidMax");
        nProps += this._addRngProp(parent, props, qds, "TYPICAL_MIN", "TYPICAL_MAX", "UNITS", sAxis + "Range");
        Object obj = qds.property("CADENCE");
        if (obj != null) {
            QDataSet dsTmp = (QDataSet)obj;
            Units units = (Units)dsTmp.property("UNITS");
            if (units == null) {
                units = Units.dimensionless;
            }
            Datum dtm = Datum.create((double)dsTmp.value(), (Units)units);
            nProps += this._addChildProp(parent, props, sAxis + "TagWidth", "Datum", dtm.toString());
        }
        return nProps;
    }

    int _addPropsFromMap(Element parent, Element props, Map<String, Object> dMap, boolean bStripDot) {
        if (dMap == null) {
            return 0;
        }
        int nAdded = 0;
        for (Map.Entry<String, Object> ent : dMap.entrySet()) {
            String sKey = ent.getKey();
            if (bStripDot && sKey.contains(".")) continue;
            NodeList nl = props.getElementsByTagName("p");
            boolean bHasItAlready = false;
            for (int i = 0; i < nl.getLength(); ++i) {
                String sName;
                Element el = (Element)nl.item(i);
                if (!el.hasAttribute("name") || !sKey.equals(sName = el.getAttribute("name"))) continue;
                bHasItAlready = true;
                break;
            }
            if (bHasItAlready) continue;
            Object oVal = ent.getValue();
            if (oVal instanceof Boolean) {
                nAdded += this._addBoolProp(parent, props, sKey, oVal);
                continue;
            }
            if (oVal instanceof String) {
                nAdded += this._addStrProp(parent, props, sKey, oVal);
                continue;
            }
            if (oVal instanceof Number) {
                nAdded += this._addRealProp(parent, props, sKey, oVal);
                continue;
            }
            if (oVal instanceof Datum) {
                nAdded += this._addDatumProp(parent, props, sKey, oVal);
                continue;
            }
            if (!(oVal instanceof DatumRange)) continue;
            nAdded += this._addRngProp(parent, props, sKey, oVal);
        }
        return nAdded;
    }

    static class SeparablePair {
        ArrayDataSet reference;
        ArrayDataSet offset;

        SeparablePair(ArrayDataSet dsRef, ArrayDataSet dsOffset) {
            this.reference = dsRef;
            this.offset = dsOffset;
            this.offset.putProperty(QdsToDas23.REFERENCE, (Object)dsRef);
        }
    }
}

