/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qstream.AsciiTransferType;
import org.das2.qstream.Descriptor;
import org.das2.qstream.DescriptorFactory;
import org.das2.qstream.DescriptorRegistry;
import org.das2.qstream.EnumerationUnitDescriptor;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.TransferType;
import org.das2.qstream.Util;
import org.das2.util.ByteBufferInputStream;
import org.das2.util.LoggerManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StreamTool {
    private static final int PACKET_LENGTH_LIMIT = 1000000;
    private static final Logger logger = LoggerManager.getLogger((String)"qstream");

    public static byte[] advanceTo(InputStream in, byte[] delim) throws IOException, DelimeterNotFoundException {
        byte[] data = new byte[4096];
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int bytesMatched = 0;
        int index = 0;
        boolean notDone = true;
        int totalBytesRead = 0;
        int offset = 0;
        while (notDone) {
            int byteRead = in.read();
            ++totalBytesRead;
            if (byteRead == -1) {
                notDone = false;
            } else {
                data[offset] = (byte)byteRead;
                bytesMatched = delim[bytesMatched] == byteRead ? ++bytesMatched : 0;
                if (bytesMatched == delim.length) {
                    notDone = false;
                    index = totalBytesRead - delim.length;
                }
            }
            if (!notDone || ++offset != 4096) continue;
            list.add(data);
            offset = 0;
            data = new byte[4096];
        }
        if (bytesMatched != delim.length) {
            throw new DelimeterNotFoundException();
        }
        byte[] result = new byte[index];
        for (int i = 0; i < list.size(); ++i) {
            System.arraycopy(list.get(i), 0, result, i * 4096, 4096);
        }
        System.arraycopy(data, 0, result, list.size() * 4096, index - list.size() * 4096);
        return result;
    }

    public static byte[] readXML(PushbackInputStream in) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(in);
        byte[] back = new byte[4096];
        ByteBuffer buffer = ByteBuffer.wrap(back);
        channel.read(buffer);
        buffer.flip();
        ByteBuffer xml = StreamTool.readXML(buffer);
        byte[] bytes = new byte[xml.remaining()];
        xml.get(bytes);
        return bytes;
    }

    private static void eatWhiteSpace(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            char c = (char)(0xFF & buffer.get());
            if (Character.isWhitespace(c)) continue;
            buffer.position(buffer.position() - 1);
            return;
        }
    }

    public static ByteBuffer readXML(ByteBuffer input) throws IOException {
        int gtCount = 0;
        int tagCount = 0;
        boolean bufidx = false;
        boolean inQuotes = false;
        boolean inTag = false;
        boolean tagContainsSlash = false;
        ByteBuffer buffer = input.duplicate();
        buffer.mark();
        StreamTool.eatWhiteSpace(buffer);
        int b = 0xFF & buffer.get();
        if ((char)b != '<') {
            throw new IOException("found '" + (char)b + "', expected '<' at offset=" + buffer.position() + ".\n");
        }
        ++gtCount;
        tagContainsSlash = false;
        while (buffer.hasRemaining() && (gtCount > 0 || tagCount > 0)) {
            char lastChar = (char)b;
            b = 0xFF & buffer.get();
            if (inQuotes && (char)b == '\"' && lastChar != '\\') {
                inQuotes = false;
                continue;
            }
            if ((char)b == '<') {
                ++gtCount;
                inTag = true;
                tagContainsSlash = false;
                continue;
            }
            if (b == 62) {
                --gtCount;
                inTag = false;
                if (lastChar == '/') continue;
                if (tagContainsSlash) {
                    --tagCount;
                    continue;
                }
                ++tagCount;
                continue;
            }
            if (b == 47) {
                if (lastChar != '<') continue;
                tagContainsSlash = true;
                continue;
            }
            if ((char)b != '\"' || !inTag) continue;
            inQuotes = true;
        }
        StreamTool.eatWhiteSpace(buffer);
        int limit = buffer.limit();
        buffer.limit(buffer.position());
        buffer.reset();
        ByteBuffer result = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(limit);
        return result;
    }

    public static void readStream(ReadableByteChannel stream, StreamHandler handler) throws StreamException {
        ReadStreamStructure struct = new ReadStreamStructure(stream, handler);
        try {
            int bytesRead;
            while ((bytesRead = stream.read(struct.bigBuffer)) >= 0) {
                if (bytesRead == -1) {
                    logger.fine("handling remaining data in the buffer.");
                }
                ReadStreamStructure readStreamStructure = struct;
                readStreamStructure.byteOffset = readStreamStructure.byteOffset + struct.bigBuffer.position();
                struct.bigBuffer.flip();
                while (StreamTool.getChunk(struct)) {
                }
                struct.bigBuffer.compact();
            }
            if (struct.bigBuffer.position() != 0) {
                throw new StreamException("Stream ends with partial packet");
            }
            handler.streamClosed(struct.sd);
        }
        catch (StreamException se) {
            handler.streamException(se);
            throw se;
        }
        catch (IOException ioe) {
            StreamException se = new StreamException(ioe);
            handler.streamException(se);
            throw se;
        }
    }

    private static StreamDescriptor getStreamDescriptor(ReadStreamStructure struct, int contentLength) throws StreamException, IOException {
        if (StreamTool.isStreamDescriptorHeader(struct.four)) {
            try {
                Document doc = StreamTool.getXMLDocument(struct.bigBuffer, contentLength);
                Element root = doc.getDocumentElement();
                if (root.getTagName().equals("stream")) {
                    NodeList props;
                    StreamDescriptor sd = new StreamDescriptor(doc.getDocumentElement());
                    sd.setDomElement(doc.getDocumentElement());
                    sd.setSizeBytes(contentLength);
                    String b = root.getAttribute("byte_order");
                    if (b != null && !b.equals("")) {
                        sd.setByteOrder(b.equals("little_endian") ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                        struct.bigBuffer.order(sd.getByteOrder());
                    }
                    if ((props = root.getElementsByTagName("properties")).getLength() > 0 && root.getAttribute("dataset_id").length() == 0) {
                        throw new StreamException("stream appears to be a das2stream, not a qstream");
                    }
                    return sd;
                }
                if (root.getTagName().equals("exception")) {
                    throw StreamTool.exception(root);
                }
                throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + root.getTagName());
            }
            catch (SAXException ex) {
                String msg = StreamTool.getSAXParseExceptionMessage(ex, struct, contentLength);
                throw new StreamException(msg);
            }
        }
        String s = StreamTool.readMore(struct);
        throw new StreamException("Expecting stream descriptor header, found: '" + StreamTool.getIdString(struct.four) + "' beginning \n'" + s + "'");
    }

    private static String readMore(ReadStreamStructure struct) throws IOException {
        struct.bigBuffer.position(0);
        struct.bigBuffer.limit(10);
        byte[] bytes10 = new byte[10];
        struct.bigBuffer.get(bytes10);
        String s = new String(bytes10);
        struct.bigBuffer.limit(1000);
        struct.bigBuffer.position(0);
        while (struct.bigBuffer.hasRemaining() && struct.stream.read(struct.bigBuffer) != -1) {
        }
        int p = struct.bigBuffer.position();
        byte[] bytes = new byte[p];
        struct.bigBuffer.flip();
        struct.bigBuffer.get(bytes);
        s = s + new String(bytes);
        return s;
    }

    private static String getSAXParseExceptionMessage(SAXException ex, ReadStreamStructure struct, int contentLength) {
        String loc = null;
        if (ex instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)ex;
            loc = "Relative to packet start, line number is " + spe.getLineNumber() + ", column is " + spe.getColumnNumber();
        }
        int bufOffset = struct.byteOffset - struct.bigBuffer.limit();
        String msg = "xml parser fails with the message: \"" + ex.getMessage() + "\" within the packet ending at byte offset " + (bufOffset + struct.bigBuffer.position()) + ".";
        if (ex.getMessage().contains("trailing")) {
            int bpos;
            int i;
            msg = msg + "\nNon-whitespace data found after xml closing tag, probably caused by content length error.";
            for (i = bufOffset + struct.bigBuffer.position() - 1; i > 0; --i) {
                bpos = i - bufOffset;
                if (struct.bigBuffer.get(bpos) == 62) break;
            }
            while (i < bufOffset + struct.bigBuffer.position()) {
                bpos = i - bufOffset;
                if (struct.bigBuffer.get(bpos) == 91 || struct.bigBuffer.get(bpos) == 58) break;
                ++i;
            }
            if (i > 0) {
                int error = i - (struct.bigBuffer.position() + bufOffset);
                DecimalFormat nf = new DecimalFormat("000000");
                msg = msg + "\nContent length was " + nf.format(contentLength) + ", maybe it should have been " + nf.format(contentLength + error) + ".";
            }
        }
        if (loc != null) {
            msg = msg + "  " + loc;
        }
        return msg;
    }

    private static StreamException exception(Element exception) {
        String type = exception.getAttribute("type");
        String message = exception.getAttribute("message");
        if (type.equals("NoDataInInterval")) {
            NoDataInIntervalException ex = new NoDataInIntervalException(message);
            StreamException se = new StreamException((Exception)ex);
            return se;
        }
        if (type.equals("EmptyResponseFromReader")) {
            StreamException se = new StreamException("Empty response from reader\n" + message);
            return se;
        }
        return new StreamException(message);
    }

    private static void interpretPlanes(ReadStreamStructure struct, PacketDescriptor pd) throws StreamException {
        try {
            Element e = pd.getDomElement();
            pd.setValuesInDescriptor(false);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("/packet/qdataset");
            Object o = expr.evaluate(e, XPathConstants.NODESET);
            NodeList nodes = (NodeList)o;
            for (int i = 0; i < nodes.getLength(); ++i) {
                int rank;
                Element n = (Element)nodes.item(i);
                String name = n.getAttribute("id");
                if (name.trim().length() == 0) {
                    throw new StreamException(String.format("id is not specified for qdataset", new Object[0]));
                }
                String srank = n.getAttribute("rank");
                if (srank.trim().length() == 0) {
                    throw new StreamException(String.format("rank not specified for qdataset \"" + name + "\"", new Object[0]));
                }
                try {
                    rank = Integer.parseInt(srank);
                }
                catch (NumberFormatException ex) {
                    throw new StreamException(String.format("rank is parsable as an integer in qdataset \"" + name + "\"", new Object[0]));
                }
                int[] dims = null;
                String ttype = null;
                String joinChildren = null;
                boolean isInline = false;
                boolean isBundle = false;
                NodeList values = (NodeList)xpath.evaluate("values", n, XPathConstants.NODESET);
                NodeList bundles = null;
                String[] sbundles = null;
                if (values.getLength() == 0) {
                    bundles = (NodeList)xpath.evaluate("bundle", n, XPathConstants.NODESET);
                    if (bundles.getLength() == 0) {
                        throw new IllegalArgumentException("no values node in " + n.getNodeName() + " " + n.getAttribute("id"));
                    }
                    sbundles = new String[bundles.getLength()];
                    for (int j = 0; j < bundles.getLength(); ++j) {
                        sbundles[j] = ((Element)bundles.item(j)).getAttribute("id");
                    }
                }
                if (bundles != null) {
                    dims = new int[]{};
                    isInline = true;
                    pd.valuesInDescriptor = true;
                } else {
                    for (int iv = 0; iv < values.getLength(); ++iv) {
                        Element vn = (Element)values.item(iv);
                        if (vn.hasAttribute("values")) {
                            isInline = true;
                            pd.valuesInDescriptor = true;
                        } else if (vn.hasAttribute("inline")) {
                            isInline = true;
                            pd.valuesInDescriptor = true;
                        } else if (vn.hasAttribute("bundle")) {
                            isInline = true;
                            pd.valuesInDescriptor = true;
                            isBundle = true;
                            sbundles = vn.getAttribute("bundle").split(",");
                        }
                        String sdims = xpath.evaluate("@length", vn);
                        ttype = xpath.evaluate("@encoding", vn);
                        joinChildren = xpath.evaluate("@join", vn);
                        dims = sdims == null ? new int[]{} : Util.decodeArray(sdims);
                    }
                    assert (dims != null);
                }
                PlaneDescriptor planeDescriptor = new PlaneDescriptor();
                planeDescriptor.setRank(rank);
                planeDescriptor.setQube(dims);
                boolean isStream = rank > dims.length;
                pd.setStream(isStream);
                pd.setStreamRank(rank - dims.length);
                String sunits = null;
                Units units = null;
                NodeList odims = (NodeList)xpath.evaluate("properties[not(@index)]/property", n, XPathConstants.NODESET);
                for (int ii = 0; sunits == null && ii < odims.getLength(); ++ii) {
                    Node nn = odims.item(ii);
                    if (!nn.getAttributes().getNamedItem("name").getNodeValue().equals("UNITS")) continue;
                    sunits = nn.getAttributes().getNamedItem("value").getNodeValue();
                    String stype = nn.getAttributes().getNamedItem("type").getNodeValue();
                    if (stype.equals("unit")) {
                        stype = "units";
                    }
                    SerializeDelegate delegate = stype.equals("enumerationUnit") ? (struct.handler instanceof QDataSetStreamHandler ? ((QDataSetStreamHandler)((ReadStreamStructure)struct).handler).enumerationUnitsSerializeDelegate : SerializeRegistry.getByName(stype)) : SerializeRegistry.getByName(stype);
                    if (delegate == null) {
                        throw new StreamException("unable to parse UNITS, because unable to identify parser for " + stype);
                    }
                    try {
                        units = (Units)delegate.parse(stype, sunits);
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                        throw ex;
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    logger.log(Level.FINER, "units found: {0}", units);
                    struct.units.put(units.getId(), units);
                }
                NodeList oen = (NodeList)xpath.evaluate("enumerationUnit", n, XPathConstants.NODESET);
                for (int ii = 0; ii < oen.getLength(); ++ii) {
                    Node nn = oen.item(ii);
                    if (!(units instanceof EnumerationUnits)) continue;
                    EnumerationUnits eu = (EnumerationUnits)units;
                    int value = Integer.decode(nn.getAttributes().getNamedItem("value").getNodeValue());
                    int icolor = Integer.decode(nn.getAttributes().getNamedItem("color").getNodeValue());
                    String label = nn.getAttributes().getNamedItem("label").getNodeValue();
                    eu.createDatum(value, (Object)label, icolor);
                }
                planeDescriptor.setUnits(units);
                if (sbundles != null) {
                    planeDescriptor.setBundles(sbundles);
                    planeDescriptor.setType(new AsciiTransferType(10, true));
                } else {
                    TransferType tt = TransferType.getForName(ttype, Collections.singletonMap("UNITS", units));
                    if (tt == null && isInline) {
                        tt = new AsciiTransferType(10, true);
                    }
                    if (tt == null && joinChildren != null && joinChildren.length() > 0) {
                        tt = new AsciiTransferType(10, true);
                    }
                    if (tt == null) {
                        if ("".equals(ttype)) {
                            throw new IllegalArgumentException(String.format("either encoding or in-line values attribute is needed in [%02d]", pd.getPacketId()));
                        }
                        throw new IllegalArgumentException("unrecognized transfer type: " + ttype);
                    }
                    planeDescriptor.setType(tt);
                }
                planeDescriptor.setName(name);
                pd.addPlane(planeDescriptor);
            }
        }
        catch (XPathExpressionException ex) {
            throw new StreamException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getChunk(ReadStreamStructure struct) throws StreamException, IOException {
        struct.bigBuffer.mark();
        if (struct.bigBuffer.remaining() < 4) {
            return false;
        }
        struct.bigBuffer.get(struct.four);
        if (StreamTool.isPacketDescriptorHeader(struct.four)) {
            logger.log(Level.FINER, "packet descriptor {0} ending at {1}", new Object[]{new String(struct.four), struct.getCarotPosition()});
            if (struct.bigBuffer.remaining() < 6) {
                struct.bigBuffer.reset();
                return false;
            }
            int contentLength = StreamTool.getContentLength(struct.bigBuffer);
            logger.log(Level.FINEST, "packet descriptor content length is {0}", new Object[]{contentLength});
            if (contentLength == 0) {
                throw new StreamException("packetDescriptor content length is 0.");
            }
            if (struct.bigBuffer.capacity() < contentLength) {
                struct.bigBuffer.reset();
                ByteBuffer temp = ByteBuffer.allocate(8 + contentLength + contentLength / 10);
                temp.put(struct.bigBuffer);
                temp.flip();
                struct.bigBuffer = temp;
                return false;
            }
            if (struct.bigBuffer.remaining() < contentLength) {
                struct.bigBuffer.reset();
                return false;
            }
            if (StreamTool.isStreamDescriptorHeader(struct.four)) {
                StreamDescriptor sd = StreamTool.getStreamDescriptor(struct, contentLength);
                struct.sd = sd;
                struct.handler.streamDescriptor(sd);
                struct.descriptorCount++;
                return true;
            }
            try {
                Document doc = StreamTool.getXMLDocument(struct.bigBuffer, contentLength);
                Element root = doc.getDocumentElement();
                DescriptorFactory factory = DescriptorRegistry.get(root.getTagName());
                if (factory == null) {
                    if (!root.getTagName().equals("stream")) throw new StreamException("Unrecognized tag name \"" + root.getTagName() + "\"");
                    logger.fine("ignoring second stream descriptor");
                    return true;
                }
                Element ele = doc.getDocumentElement();
                Descriptor pd = factory.create(ele);
                if (pd instanceof PacketDescriptor) {
                    int id = -1;
                    try {
                        id = Integer.parseInt(StreamTool.getIdString(struct.four));
                    }
                    catch (NumberFormatException ex) {
                        throw new StreamException("packet descriptor id must be an integer from 1-99");
                    }
                    ((PacketDescriptor)pd).setPacketId(id);
                    StreamTool.interpretPlanes(struct, (PacketDescriptor)pd);
                    if (struct.sd == null) {
                        throw new StreamException("Stream must start with a StreamDescriptor (for now)");
                    }
                    if (struct.sd.hasDescriptor(pd, id)) {
                        logger.fine("found repeat packetDescriptor");
                    }
                    struct.descriptors.put(StreamTool.getIdString(struct.four), pd);
                    struct.sd.addDescriptor((PacketDescriptor)pd, id);
                    struct.handler.packetDescriptor((PacketDescriptor)pd);
                } else if (pd instanceof EnumerationUnitDescriptor) {
                    EnumerationUnitDescriptor eud = (EnumerationUnitDescriptor)pd;
                    EnumerationUnits eu = (EnumerationUnits)struct.units.get(eud.getName());
                    eu.createDatum((int)eud.getValue(), (Object)eud.getLabel());
                    logger.log(Level.FINER, "adding nominal datum to {0} {1}: {2}->{3}", new Object[]{eu, eu.hashCode(), eud.getValue(), eud.getLabel()});
                } else {
                    if (root.getTagName().equals("exception")) {
                        throw StreamTool.exception(root);
                    }
                    if (!(pd instanceof StreamComment)) throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + root.getTagName());
                    struct.handler.streamComment((StreamComment)pd);
                }
                struct.descriptorCount++;
                return true;
            }
            catch (SAXException ex) {
                String msg = StreamTool.getSAXParseExceptionMessage(ex, struct, contentLength);
                throw new StreamException(msg);
            }
        }
        if (StreamTool.isPacketHeader(struct.four)) {
            String key = StreamTool.getIdString(struct.four);
            PacketDescriptor pd = (PacketDescriptor)struct.descriptors.get(key);
            logger.log(Level.FINEST, "packet {0} at {1}", new Object[]{new String(struct.four), struct.getCarotPosition()});
            if (pd == null) {
                throw new StreamException(String.format("No packet found for key \"%s\"", key));
            }
            int contentLength = pd.sizeBytes();
            if (contentLength == 0 && pd.isValuesInDescriptor()) {
                throw new IllegalArgumentException("values cannot be both in the packet descriptor and in the packets.");
            }
            if (contentLength > 1000000) {
                throw new IllegalStateException("stream packet length is too long (" + contentLength + ">" + 1000000 + "bytes). (bug 0000348: streams with long packet lengths).");
            }
            if (struct.bigBuffer.remaining() < contentLength) {
                struct.bigBuffer.reset();
                return false;
            }
            int oldLimit = struct.bigBuffer.limit();
            struct.bigBuffer.limit(struct.bigBuffer.position() + contentLength);
            ByteBuffer packet = struct.bigBuffer.slice();
            packet.order(struct.bigBuffer.order());
            struct.bigBuffer.position(struct.bigBuffer.position() + contentLength);
            struct.bigBuffer.limit(oldLimit);
            struct.handler.packet(pd, packet);
            struct.packetCount++;
            return true;
        } else {
            String msg = "Expected four-byte header like ':01:' or '[01]', but instead found '";
            String s = new String(struct.four);
            s = s.replaceAll("\n", "\\\\n");
            msg = msg + s;
            msg = msg + "' at byteOffset=" + (struct.getCarotPosition() - 4L - 10L);
            msg = msg + " after reading " + struct.descriptorCount + " descriptors and " + struct.packetCount + " packets.";
            logger.log(Level.FINE, msg);
            throw new StreamException(msg);
        }
    }

    private static String getIdString(byte[] bytes) {
        try {
            return new String(bytes, 1, 2, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private static boolean isStreamDescriptorHeader(byte[] four) {
        return four[0] == 91 && four[1] == 48 && four[2] == 48 && four[3] == 93;
    }

    private static boolean isPacketDescriptorHeader(byte[] four) {
        return four[0] == 91 && four[3] == 93 && (Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]) || (char)four[1] == 'x' && (char)four[2] == 'x');
    }

    private static boolean isPacketHeader(byte[] four) {
        return four[0] == 58 && four[3] == 58 && Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]);
    }

    private static boolean isDescriptor(byte[] four) {
        return four[0] == 58 && four[3] == 58 && (Character.isDigit((char)four[1]) && Character.isDigit((char)four[2]) || four[1] == 120 && four[2] == 120);
    }

    private static Document getXMLDocument(ByteBuffer buffer, int contentLength) throws StreamException, IOException, SAXException {
        ByteBuffer xml = buffer.duplicate();
        xml.limit(xml.position() + contentLength);
        buffer.position(buffer.position() + contentLength);
        boolean DEBUG = false;
        ByteBufferInputStream bbin = new ByteBufferInputStream(xml);
        InputStreamReader isr = new InputStreamReader((InputStream)bbin);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(isr);
            Document document = builder.parse(source);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int getContentLength(ByteBuffer buffer) throws StreamException {
        int contentLength = 0;
        for (int i = 0; i < 6; ++i) {
            char c = (char)(0xFF & buffer.get());
            if (c == ' ') continue;
            if (!Character.isDigit(c)) {
                throw new StreamException("Invalid character in contentLength: '" + c + "'");
            }
            int digit = Character.digit(c, 10);
            contentLength = contentLength * 10 + digit;
        }
        return contentLength;
    }

    public static void formatHeader(Document document, Writer writer) throws StreamException {
        DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        LSOutput output = ls.createLSOutput();
        output.setCharacterStream(writer);
        LSSerializer serializer = ls.createLSSerializer();
        try {
            if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
        }
        catch (Error e) {
            logger.log(Level.SEVERE, "formatHeader", e);
        }
        serializer.write(document, output);
    }

    private static class ReadStreamStructure {
        private final ReadableByteChannel stream;
        private ByteBuffer bigBuffer = ByteBuffer.allocate(1000000);
        private final byte[] four = new byte[4];
        private final StreamHandler handler;
        private final Map descriptors = new HashMap();
        private final Map<String, Units> units = new HashMap<String, Units>();
        private StreamDescriptor sd;
        private int byteOffset = 0;
        private int descriptorCount = 0;
        private int packetCount = 0;

        private ReadStreamStructure(ReadableByteChannel stream, StreamHandler handler) {
            this.stream = stream;
            this.handler = handler;
        }

        protected long getCarotPosition() {
            return this.byteOffset - this.bigBuffer.limit() + this.bigBuffer.position();
        }

        public String toString() {
            return "\ndescriptorCount=" + this.descriptorCount + "\npacketCount=" + this.packetCount + "\nbyteOffset=" + this.byteOffset + "\ncarotPos=" + this.getCarotPosition() + "\nbuffer=" + String.valueOf(this.bigBuffer);
        }
    }

    public static class DelimeterNotFoundException
    extends Exception {
    }
}

