/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.netCDF.NetCDFDataSource;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class NetCDFDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.netcdf");

    public DataSource getDataSource(URI uri) throws IOException {
        return new NetCDFDataSource(uri);
    }

    public Map<String, CompletionContext> getParams(URI ncFile, ProgressMonitor mon) throws IOException {
        File file = DataSetURI.getFile((URI)ncFile, (ProgressMonitor)mon);
        NetcdfDataset dataset = this.getDataSet(file.toURI().toURL());
        ImmutableList vars = dataset.getVariables();
        LinkedHashMap<String, CompletionContext> result = new LinkedHashMap<String, CompletionContext>();
        for (int j = 0; j < vars.size(); ++j) {
            boolean isFormattedTime;
            Variable v = (Variable)vars.get(j);
            if (v.getDimensions().isEmpty()) continue;
            if (v instanceof Structure) {
                for (Variable v2 : ((Structure)v).getVariables()) {
                    if (!v2.getDataType().isNumeric()) continue;
                    StringBuilder description = new StringBuilder(v2.getName() + "[");
                    for (int k = 0; k < v2.getDimensions().size(); ++k) {
                        Dimension d = v2.getDimension(k);
                        if (k > 0) {
                            description.append(",");
                        }
                        String n = d.getName();
                        if (n != null && !n.equals(v2.getName())) {
                            description.append(d.getName()).append("=");
                        }
                        description.append(d.getLength());
                        continue;
                    }
                    description.append("]");
                    result.put(v2.getName(), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, v2.getName(), (DataSourceFactory)this, "arg_0", v2.getNameAndDimensions(), v2.getDescription(), true));
                }
                continue;
            }
            boolean bl = isFormattedTime = v.getDataType() == DataType.CHAR && v.getRank() == 2 && v.getShape(1) >= 14 && v.getShape(1) <= 30;
            if (!isFormattedTime && !v.getDataType().isNumeric()) continue;
            result.put(v.getName(), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, v.getName(), (DataSourceFactory)this, "arg_0", v.getNameAndDimensions(), v.getDescription(), true));
        }
        dataset.close();
        return result;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException {
        ArrayList<CompletionContext> result;
        block12: {
            String paramName;
            block13: {
                block11: {
                    result = new ArrayList<CompletionContext>();
                    if (cc.context != CompletionContext.CONTEXT_PARAMETER_NAME) break block11;
                    Map<String, CompletionContext> result1 = this.getParams(cc.resourceURI, mon);
                    for (Map.Entry<String, CompletionContext> r : result1.entrySet()) {
                        result.add(r.getValue());
                    }
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "x=", "specify the x variable"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "y=", "specify the y variable"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "units=", "override the file units"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "xunits=", "override the units for x"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "where=", "add constraint by another field's value"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMin=", "values less than this value are treated as fill."));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMax=", "values greater than this value are treated as fill."));
                    break block12;
                }
                if (cc.context != CompletionContext.CONTEXT_PARAMETER_VALUE) break block12;
                paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
                if (paramName.equals("fill")) {
                    return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
                }
                if (paramName.equals("validMin")) {
                    return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
                }
                if (paramName.equals("validMax")) {
                    return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
                }
                if (paramName.equals("where")) {
                    if (cc.completable.contains(".")) {
                        int i = cc.completable.lastIndexOf(".");
                        String s = cc.completable.substring(0, i);
                        if (s.length() > 0) {
                            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".eq(0)"));
                            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".ne(0)"));
                            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".gt(0)"));
                            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".lt(0)"));
                            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".within(0+to+10)"));
                        }
                    } else {
                        Map<String, CompletionContext> result1 = this.getParams(cc.resourceURI, mon);
                        for (Map.Entry<String, CompletionContext> r : result1.entrySet()) {
                            String s = r.getKey();
                            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".eq(0)", "where parameter is equal to zero"));
                        }
                    }
                    return result;
                }
                if (!paramName.equals("x")) break block13;
                Map<String, CompletionContext> result1 = this.getParams(cc.resourceURI, mon);
                for (Map.Entry<String, CompletionContext> r : result1.entrySet()) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, r.getValue().completable));
                }
                break block12;
            }
            if (!paramName.equals("y")) break block12;
            Map<String, CompletionContext> result1 = this.getParams(cc.resourceURI, mon);
            for (Map.Entry<String, CompletionContext> r : result1.entrySet()) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, r.getValue().completable));
            }
        }
        return result;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    protected static void checkMatlab(String resource) throws IOException {
        if (resource.startsWith("file:/")) {
            try (BufferedReader r = new BufferedReader(new FileReader(new URL(resource).getFile()));){
                String magic = r.readLine();
                if (magic != null && magic.contains("MATLAB") && !magic.contains("HDF5")) {
                    throw new IllegalArgumentException("Matlab file is not an HDF5 file.  Use Matlab 7.3 or greater, and save with -v7.3");
                }
            }
        }
    }

    private NetcdfDataset getDataSet(URL resourceURL) throws IOException {
        String resource;
        if (resourceURL.getProtocol().equals("file")) {
            try {
                resource = new File(resourceURL.toURI()).toString();
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, null, ex);
                resource = resourceURL.toString();
            }
        } else {
            resource = resourceURL.toString();
        }
        if (resource.endsWith(".ncml")) {
            return NcMLReader.readNcML((String)resource, null);
        }
        NetCDFDataSourceFactory.checkMatlab(resource);
        NetcdfFile f = NetcdfFile.open((String)resource);
        NetcdfDataset dataset = new NetcdfDataset(f);
        return dataset;
    }

    public int getNumberOfRecords(String surl, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        File file = DataSetURI.getFile((String)surl, (ProgressMonitor)mon);
        String svariable = (String)params.get("arg_0");
        NetcdfDataset dataset = this.getDataSet(file.toURI().toURL());
        for (Variable v : dataset.getVariables()) {
            if (!v.getName().replaceAll(" ", "+").equals(svariable)) continue;
            return v.getDimension(0).getLength();
        }
        throw new IllegalArgumentException("variable name must be specified");
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        try {
            URISplit split = URISplit.parse((String)surl);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            File file = DataSetURI.getFile((String)surl, (ProgressMonitor)mon);
            NetcdfDataset dataset = this.getDataSet(file.toURI().toURL());
            boolean depCount = false;
            ImmutableList vars = dataset.getVariables();
            HashSet<Variable> coordVars = new HashSet<Variable>();
            for (Variable var : vars) {
                if (!var.isCoordinateVariable()) continue;
                coordVars.add(var);
            }
            String svariable = (String)params.get("arg_0");
            if (svariable == null) {
                svariable = (String)params.get("Y");
            }
            if (svariable != null) {
                int ic = svariable.indexOf("[");
                if (ic > -1) {
                    svariable = svariable.substring(0, ic);
                }
                if (svariable != null) {
                    svariable = svariable.replaceAll(" ", "+");
                }
            }
            boolean haveIt = false;
            for (int j = 0; j < vars.size(); ++j) {
                Variable v = (Variable)vars.get(j);
                if (v.getDimensions().isEmpty()) continue;
                if (v instanceof Structure) {
                    for (Variable v2 : ((Structure)v).getVariables()) {
                        if (!v2.getDataType().isNumeric() || !v2.getFullName().replaceAll(" ", "+").equals(svariable)) continue;
                        haveIt = true;
                    }
                    continue;
                }
                if (!v.getFullName().replaceAll(" ", "+").equals(svariable)) continue;
                haveIt = true;
            }
            dataset.close();
            if (depCount) {
                return false;
            }
            return !haveIt;
        }
        catch (HtmlResponseIOException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }
}

