/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsyntaxpane.DefaultSyntaxKit;
import org.autoplot.jythonsupport.StaticCodeAnalysis;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.RefactorRenameVariable;

public class ClipboardEditorPanel
extends JPanel {
    EditorTextPane edit;
    private JButton copyClipButton;
    private JPanel editorPanel;
    private JButton renameVariableButton;

    public ClipboardEditorPanel() {
        this.initComponents();
        this.edit = new EditorTextPane();
        DefaultSyntaxKit.initKit();
        this.edit.setContentType("text/python");
        this.edit.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClipboardEditorPanel.this.copyClipButton.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClipboardEditorPanel.this.copyClipButton.setEnabled(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClipboardEditorPanel.this.copyClipButton.setEnabled(true);
            }
        });
        JScrollPane pane = new JScrollPane(this.edit);
        this.editorPanel.add((Component)pane, "Center");
        this.editorPanel.revalidate();
        AbstractAction renameAction = new AbstractAction("Rename Variable"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String script = ClipboardEditorPanel.this.edit.getText();
                try {
                    StaticCodeAnalysis.showUsage(script, "x");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(ClipboardEditorPanel.this.editorPanel, "Script must be Jython syntax without errors");
                    return;
                }
                RefactorRenameVariable rrv = new RefactorRenameVariable(ClipboardEditorPanel.this.edit);
                if (0 == JOptionPane.showConfirmDialog(ClipboardEditorPanel.this.editorPanel, rrv, "Rename Variable", 2)) {
                    rrv.refactorVarRename();
                }
            }
        };
        this.renameVariableButton.setAction(renameAction);
    }

    public void setText(String text) {
        this.edit.setText(text);
        this.copyClipButton.setEnabled(true);
    }

    public String getText() {
        return this.edit.getText();
    }

    public void setTextFromClipboard() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String text = clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor).toString();
            this.setText(text);
            this.copyClipButton.setEnabled(false);
        }
        catch (UnsupportedFlavorException ex) {
            Logger.getLogger(ClipboardEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ClipboardEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.copyClipButton = new JButton();
        this.renameVariableButton = new JButton();
        this.editorPanel.setLayout(new BorderLayout());
        this.copyClipButton.setText("Copy back into Clipboard");
        this.copyClipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipboardEditorPanel.this.copyClipButtonActionPerformed(evt);
            }
        });
        this.renameVariableButton.setText("Rename Variable...");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap(15, Short.MAX_VALUE).addComponent(this.renameVariableButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyClipButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorPanel, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyClipButton).addComponent(this.renameVariableButton))));
    }

    private void copyClipButtonActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = new StringSelection(this.edit.getText());
        clipboard.setContents(selection, null);
        this.copyClipButton.setEnabled(false);
    }
}

