/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import jsyntaxpane.DefaultSyntaxKit;

public class MathematicaJythonConverter
extends JPanel {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JEditorPane jythonEditorPane;
    private JEditorPane mathematicaEditorPane;

    public MathematicaJythonConverter(JEditorPane editor) {
        this.initComponents();
        DefaultSyntaxKit.initKit();
        this.mathematicaEditorPane.setContentType("text/java");
        DefaultSyntaxKit.initKit();
        this.jythonEditorPane.setContentType("text/python");
        if (editor != null) {
            this.mathematicaEditorPane.setBackground(editor.getBackground());
            this.mathematicaEditorPane.setForeground(editor.getForeground());
            this.mathematicaEditorPane.setFont(editor.getFont());
            this.jythonEditorPane.setBackground(editor.getBackground());
            this.jythonEditorPane.setForeground(editor.getForeground());
            this.jythonEditorPane.setFont(editor.getFont());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.mathematicaEditorPane = new JEditorPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jythonEditorPane = new JEditorPane();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton1.setText("Convert Mathematica to Jython -->");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MathematicaJythonConverter.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Copy Jython to Clipboard");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MathematicaJythonConverter.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(318, 318, 318).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 344, Short.MAX_VALUE).addComponent(this.jButton2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)));
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jLabel1.setText("Mathematica Code");
        this.jScrollPane1.setViewportView(this.mathematicaEditorPane);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 442, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jScrollPane1, -1, 641, Short.MAX_VALUE)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 24, -2).addGap(0, 648, Short.MAX_VALUE))));
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jScrollPane2.setViewportView(this.jythonEditorPane);
        this.jLabel2.setText("Jython Code");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 609, Short.MAX_VALUE)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 694, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 657, Short.MAX_VALUE)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jScrollPane2, -1, 643, Short.MAX_VALUE))));
        this.jSplitPane1.setRightComponent(this.jPanel4);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        this.jLabel3.setFont(new Font("Dialog", 2, 12));
        this.jLabel3.setText("This is an experimental tool for converting Mathematica code into Jython code.  Please verify results before using this in production code.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jLabel3).addGap(1, 1, 1).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String m = this.mathematicaEditorPane.getText();
        String jython = MathematicaJythonConverter.convertMathematicaToJython(m);
        this.jythonEditorPane.setText(jython);
    }

    private static boolean checkPop(StringBuilder sb, Stack<String> stack, String t) {
        if (!stack.empty()) {
            String s = stack.peek();
            if (t.equals("]")) {
                LinkedList<String> ss = new LinkedList<String>();
                ss.add(t);
                while (!stack.isEmpty() && !s.equals("[")) {
                    s = stack.pop();
                    ss.add(0, s);
                }
                if (!s.equals("[")) {
                    throw new IllegalArgumentException("opening bracket ([) not found");
                }
                if (ss.size() == 3 && ((String)ss.get(1)).equals("Sqrt")) {
                    sb.append("sqrt");
                } else {
                    block5: for (String ss1 : ss) {
                        char c = ss1.charAt(0);
                        switch (c) {
                            case '[': {
                                sb.append('(');
                                continue block5;
                            }
                            case ']': {
                                sb.append(')');
                                continue block5;
                            }
                        }
                        sb.append(ss1);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static String convertMathematicaToJython(String m) {
        int assign = m.indexOf("->");
        if (assign > -1) {
            m = m.substring(0, assign) + "=" + m.substring(assign + 2);
        }
        m = m.replaceAll("\\\\\\[", "[");
        StringTokenizer st = new StringTokenizer(m, "{-> (/[]+-^=)}", true);
        Stack<String> stack = new Stack<String>();
        StringBuilder sb = new StringBuilder();
        boolean lastNameOrConstant = false;
        String lastToken = "";
        Pattern intPattern = Pattern.compile("\\d+");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (MathematicaJythonConverter.checkPop(sb, stack, t)) continue;
            if (!stack.isEmpty()) {
                stack.add(t);
                continue;
            }
            if (t.equals(" ")) {
                if (!lastNameOrConstant) {
                    sb.append(t);
                }
            } else if (t.equals("\n")) {
                sb.append(t);
            } else if (!t.equals("{") && !t.equals("}")) {
                if (t.equals("=")) {
                    sb.append("=");
                    lastNameOrConstant = false;
                } else if (t.equals("[")) {
                    stack.push(t);
                } else if (t.equals("]")) {
                    String lastt = stack.pop();
                    if (!stack.isEmpty() && stack.peek().equals("[")) {
                        stack.pop();
                        if (lastNameOrConstant) {
                            sb.append(" * ");
                        }
                        if (lastt.equals("Sqrt")) {
                            sb.append("sqrt");
                            lastNameOrConstant = false;
                        } else {
                            sb.append('(').append(lastt).append(')');
                            lastNameOrConstant = true;
                        }
                    } else {
                        sb.append(")");
                    }
                } else if (t.equals("(")) {
                    if (lastToken.equals(")")) {
                        sb.append(" * ");
                    } else if (lastToken.equals("[")) {
                        sb.append("(");
                    } else if (lastNameOrConstant) {
                        sb.append("* ");
                    }
                    sb.append(t);
                    lastNameOrConstant = false;
                } else if (t.equals(")")) {
                    sb.append(t);
                    lastNameOrConstant = true;
                } else if (t.equals("^")) {
                    sb.append("**");
                    lastNameOrConstant = false;
                } else if (t.equals("+")) {
                    sb.append(" ").append(t).append(" ");
                    lastNameOrConstant = false;
                } else if (t.equals("-")) {
                    if (lastNameOrConstant) {
                        sb.append(" ").append(t);
                    } else {
                        sb.append(t);
                    }
                    lastNameOrConstant = false;
                } else if (t.equals("/")) {
                    sb.append(t);
                    lastNameOrConstant = false;
                } else if (intPattern.matcher(t).matches()) {
                    if (!stack.isEmpty()) {
                        stack.push(t);
                    } else {
                        if (lastNameOrConstant) {
                            sb.append("*");
                        }
                        if (lastToken.equals("/")) {
                            sb.append(t).append(".");
                        } else {
                            sb.append(t);
                        }
                        lastNameOrConstant = true;
                    }
                } else if (!stack.isEmpty()) {
                    stack.push(t);
                } else {
                    boolean isFunctionName = false;
                    if (t.equals("Sqrt")) {
                        t = "sqrt";
                        isFunctionName = true;
                    }
                    if (lastNameOrConstant) {
                        sb.append("*");
                    }
                    sb.append(t);
                    lastNameOrConstant = !isFunctionName;
                }
            }
            lastToken = t;
        }
        String jython = sb.toString();
        return jython;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(this.jythonEditorPane.getText());
        clipboard.setContents(ss, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public static void main(String[] args) throws IOException {
        MathematicaJythonConverter cc = new MathematicaJythonConverter(null);
        String src1 = "{flh -> (1/(\n   6 Sqrt[102]))(\\[Sqrt](1836 fce^2 + 1836 fci^2 +\n       1837 fpe^2 - \\[Sqrt](3370896 fce^4 - 6741792 fce^2 fci^2 +\n          3370896 fci^4 + 6738120 fce^2 fpe^2 - 6738120 fci^2 fpe^2 +\n          3374569 fpe^4)))}";
        String src2 = "fl -> 1/306 (102 (fce + fci) - (17^(\n         2/3) (612 fce^2 - 612 fce fci + 612 fci^2 +\n           1837 fpe^2))/(-62424 fce^3 + 93636 fce^2 fci +\n         93636 fce fci^2 - 62424 fci^3 - 280602 fce fpe^2 +\n         561663 fci fpe^2 +\n         Sqrt[17] \\[Sqrt](-(612 fce^2 - 612 fce fci + 612 fci^2 +\n                1837 fpe^2)^3 +\n             1377 (408 fce^3 - 612 fce^2 fci - 612 fce fci^2 +\n                408 fci^3 + 1834 fce fpe^2 - 3671 fci fpe^2)^2))^(\n       1/3) - 17^(\n       1/3) (-62424 fce^3 + 93636 fce^2 fci + 93636 fce fci^2 -\n         62424 fci^3 - 280602 fce fpe^2 + 561663 fci fpe^2 +\n         Sqrt[17] \\[Sqrt](-(612 fce^2 - 612 fce fci + 612 fci^2 +\n                1837 fpe^2)^3 +\n             1377 (408 fce^3 - 612 fce^2 fci - 612 fce fci^2 +\n                408 fci^3 + 1834 fce fpe^2 - 3671 fci fpe^2)^2))^(\n       1/3))}";
        String src3 = "{fpe->(6 Sqrt[51])/Sqrt[(-(1836/(fce-fr))+1/(fci+fr))/fr]}";
        String src = src2;
        cc.mathematicaEditorPane.setText(src);
        JDialog dia = new JDialog();
        dia.setContentPane(cc);
        dia.pack();
        dia.setVisible(true);
    }

    public void setJavaSource(String doThis) {
        this.mathematicaEditorPane.setText(doThis);
    }
}

