/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import jsyntaxpane.components.Markers;
import org.autoplot.jythonsupport.ui.DeletePainter;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.SquigglePainter;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.util.PythonInterpreter;

public class EditorAnnotationsSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.jython");
    public static final String ANNO_ERROR = "error";
    public static final String ANNO_MAYBE_ERROR = "maybe_error";
    public static final String ANNO_PROGRAM_COUNTER = "programCounter";
    public static final String ANNO_WARNING = "warning";
    public static final String ANNO_CODE_HINT = "codeHint";
    public static final String ANNO_USAGE = "usage";
    public static final String ANNO_INSERT = "insert";
    public static final String ANNO_DELETE = "delete";
    public static final String ANNO_CHANGE = "change";
    private final JEditorPane editorPanel;
    SortedMap<Integer, Annotation> annotations = new TreeMap<Integer, Annotation>();
    private static ExpressionLookup expressionLookup;

    public static String getSymbolAt(EditorTextPane editor, int position) {
        int i = position;
        String s = editor.getText();
        if (i > 0 && i < s.length() && !Character.isJavaIdentifierPart(s.charAt(i)) && Character.isJavaIdentifierPart(s.charAt(i - 1))) {
            --i;
        }
        if (i > 0 && i == s.length() && Character.isJavaIdentifierPart(s.charAt(i - 1))) {
            --i;
        }
        while (i > 0 && i < s.length() && Character.isJavaIdentifierPart(s.charAt(i))) {
            --i;
        }
        if (i >= s.length()) {
            return "";
        }
        if (!Character.isJavaIdentifierPart(s.charAt(i))) {
            ++i;
        }
        int i0 = i;
        while (i < s.length() && Character.isJavaIdentifierPart(s.charAt(i))) {
            ++i;
        }
        if (s.length() >= i) {
            return s.substring(i0, i);
        }
        return "";
    }

    EditorAnnotationsSupport(JEditorPane editorPanel) {
        this.editorPanel = editorPanel;
        DocumentListener annoList = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }
        };
        editorPanel.getDocument().addDocumentListener(annoList);
        this.editorPanel.addPropertyChangeListener("document", evt -> {
            if (evt.getOldValue() != null) {
                ((Document)evt.getOldValue()).removeDocumentListener(annoList);
            }
            ((Document)evt.getNewValue()).addDocumentListener(annoList);
        });
        editorPanel.setToolTipText("this will contain annotations");
    }

    public void clearAnnotations() {
        if (SwingUtilities.isEventDispatchThread()) {
            Markers.removeMarkers((JTextComponent)this.editorPanel);
            this.editorPanel.getHighlighter().removeAllHighlights();
            this.annotations = new TreeMap<Integer, Annotation>();
        } else {
            SwingUtilities.invokeLater(() -> {
                Markers.removeMarkers((JTextComponent)this.editorPanel);
                this.editorPanel.getHighlighter().removeAllHighlights();
                this.annotations = new TreeMap<Integer, Annotation>();
            });
        }
    }

    public void clearAnnotations(int pos) {
        Annotation ann = this.annotationAt(pos);
        if (ann != null) {
            SwingUtilities.invokeLater(() -> {
                Markers.removeMarkers((JTextComponent)this.editorPanel, (Markers.SimpleMarker)ann.marker);
                this.annotations.remove(ann.offset);
                if (ann.highlightInfo != null) {
                    this.editorPanel.getHighlighter().removeHighlight(ann.highlightInfo);
                }
            });
        }
    }

    public void scrollToOffset(int offset) throws BadLocationException {
        int h;
        Rectangle r = this.editorPanel.modelToView(offset);
        int fontHeight = 14;
        if (r.y > fontHeight * 3) {
            r.y -= fontHeight * 3;
            r.height += fontHeight * 5;
        }
        if (r.y + r.height > (h = this.editorPanel.getHeight())) {
            r.y = h - r.height;
        }
        SwingUtilities.invokeLater(() -> this.editorPanel.scrollRectToVisible(r));
    }

    private Annotation annotationAt(int offset) {
        SortedMap<Integer, Annotation> head = this.annotations.headMap(offset);
        if (head.isEmpty()) {
            return null;
        }
        int annoOffset = head.lastKey();
        Annotation ann = (Annotation)this.annotations.get(annoOffset);
        if (ann.len > offset - ann.offset) {
            return ann;
        }
        return null;
    }

    public void annotateError(PyException ex, int offset) throws BadLocationException {
        if (ex instanceof PySyntaxError) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            int lineno = offset + ((PyInteger)ex.value.__getitem__(1).__getitem__(1)).getValue();
            this.annotateLine(lineno, ANNO_ERROR, ex.toString());
        } else {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.annotateLine(offset + ex.traceback.tb_lineno, ANNO_ERROR, ex.toString());
        }
    }

    public void annotateLine(int line, String name, String text) throws BadLocationException {
        this.annotateLine(line, name, text, null);
    }

    public void annotateLine(int lline, String name, String ltext, PythonInterpreter interp) {
        if (lline < 1) {
            new IllegalArgumentException("no such line: " + lline).printStackTrace();
            lline = 1;
            ltext = ltext + "\n(line number was " + lline + ", see stderr)";
        }
        int line = lline;
        String text = ltext;
        Element root = this.editorPanel.getDocument().getDefaultRootElement();
        if (line > root.getElementCount() + 1) {
            System.err.println("*** can't annotate line: " + lline);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            int i1;
            int i0;
            Document doc = this.editorPanel.getDocument();
            Element root1 = this.editorPanel.getDocument().getDefaultRootElement();
            if (root1.getElementCount() == 1) {
                return;
            }
            if (line > root1.getElementCount() + 1) {
                throw new IllegalArgumentException("no such line: " + line);
            }
            if (line <= root1.getElementCount()) {
                i0 = root1.getElement(line - 1).getStartOffset();
                i1 = root1.getElement(line - 1).getEndOffset();
            } else {
                i0 = Math.max(0, doc.getLength() - 2);
                i1 = doc.getLength();
            }
            this.annotateChars(i0, i1, name, text, interp);
            try {
                this.scrollToOffset(i0);
            }
            catch (BadLocationException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        });
    }

    public int[] getLinePosition(int line) {
        int i1;
        int i0;
        if (line < 1) {
            throw new IllegalArgumentException("Line number must be one or more");
        }
        Document doc = this.editorPanel.getDocument();
        Element root = this.editorPanel.getDocument().getDefaultRootElement();
        if (root.getElementCount() == 1) {
            return new int[]{0, 0};
        }
        if (line > root.getElementCount() + 1) {
            throw new IllegalArgumentException("no such line: " + line);
        }
        if (line <= root.getElementCount()) {
            i0 = root.getElement(line - 1).getStartOffset();
            i1 = root.getElement(line - 1).getEndOffset();
        } else {
            i0 = Math.max(0, doc.getLength() - 2);
            i1 = doc.getLength();
        }
        return new int[]{i0, i1};
    }

    public void annotateChars(int line, int i0, int i1, String name, String text, PythonInterpreter interp) {
        SwingUtilities.invokeLater(() -> {
            Document doc = this.editorPanel.getDocument();
            Element root = this.editorPanel.getDocument().getDefaultRootElement();
            if (root.getElementCount() == 1) {
                return;
            }
            if (line > root.getElementCount() + 1) {
                throw new IllegalArgumentException("no such line: " + line);
            }
            int lineStart = line <= root.getElementCount() ? root.getElement(line - 1).getStartOffset() : Math.max(0, doc.getLength() - 2);
            this.annotateChars(lineStart + i0 - 1, lineStart + i1 - 1, name, text, interp);
        });
    }

    public void annotateChars(int i0, int i1, String name, String text, PythonInterpreter interp) {
        SwingUtilities.invokeLater(() -> {
            Markers.SimpleMarker mark;
            boolean lightBackground = (this.editorPanel.getBackground().getRed() + this.editorPanel.getBackground().getGreen() + this.editorPanel.getBackground().getBlue()) / 3 > 100;
            Object highlightInfo = null;
            switch (name) {
                case "warning": {
                    mark = new Markers.SimpleMarker(lightBackground ? Color.YELLOW : new Color(120, 120, 0));
                    break;
                }
                case "codeHint": {
                    mark = new Markers.SimpleMarker(lightBackground ? new Color(255, 255, 0, 80) : new Color(255, 255, 0, 80));
                    break;
                }
                case "usage": {
                    mark = new Markers.SimpleMarker(lightBackground ? Color.GREEN.brighter() : new Color(0, 100, 0));
                    break;
                }
                case "error": {
                    mark = new Markers.SimpleMarker(lightBackground ? Color.PINK : new Color(120, 80, 80));
                    break;
                }
                case "maybe_error": {
                    mark = new Markers.SimpleMarker(lightBackground ? ColorUtil.PURPLE : ColorUtil.PURPLE);
                    break;
                }
                case "programCounter": {
                    mark = new Markers.SimpleMarker(lightBackground ? new Color(0, 255, 0, 80) : new Color(0, 200, 0, 80));
                    break;
                }
                case "insert": {
                    mark = new Markers.SimpleMarker(lightBackground ? new Color(100, 255, 100, 80) : new Color(0, 100, 0, 80));
                    break;
                }
                case "delete": {
                    mark = new Markers.SimpleMarker(lightBackground ? Color.PINK : new Color(120, 80, 80));
                    break;
                }
                case "change": {
                    mark = new Markers.SimpleMarker(lightBackground ? new Color(100, 100, 255, 80) : new Color(0, 0, 100, 80));
                    break;
                }
                default: {
                    mark = new Markers.SimpleMarker(Color.GRAY);
                }
            }
            switch (name) {
                case "error": {
                    SquigglePainter red = new SquigglePainter(Color.RED);
                    try {
                        highlightInfo = this.editorPanel.getHighlighter().addHighlight(i0, i1, red);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(EditorAnnotationsSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case "maybe_error": {
                    SquigglePainter red = new SquigglePainter(mark.getColor());
                    try {
                        highlightInfo = this.editorPanel.getHighlighter().addHighlight(i0, i1, red);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(EditorAnnotationsSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case "delete": {
                    DeletePainter red = new DeletePainter(Color.RED);
                    try {
                        highlightInfo = this.editorPanel.getHighlighter().addHighlight(i0, i1, red);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(EditorAnnotationsSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                default: {
                    Markers.markText((JTextComponent)this.editorPanel, (int)i0, (int)i1, (Markers.SimpleMarker)mark);
                }
            }
            Annotation ann = new Annotation();
            ann.len = i1 - i0;
            ann.offset = i0;
            ann.text = text;
            ann.marker = mark;
            ann.highlightInfo = highlightInfo;
            this.annotations.put(ann.offset, ann);
        });
    }

    private String htmlify(String text) {
        StringBuilder buff = new StringBuilder();
        buff.append("<html>");
        String[] ss = text.split("\n", -2);
        for (int i = 0; i < ss.length - 1; ++i) {
            buff.append(ss[i]).append("<br>");
        }
        buff.append(ss[ss.length - 1]);
        buff.append("</html>");
        return buff.toString();
    }

    public static void setExpressionLookup(ExpressionLookup l) {
        expressionLookup = l;
    }

    public static ExpressionLookup getExpressionLookup() {
        return expressionLookup;
    }

    public ExpressionLookup getForInterp(PythonInterpreter interp) {
        return expr -> {
            if (expr == null) {
                return new PyString("<html>highlite an expression");
            }
            try {
                PyObject po = interp.eval(expr);
                return po;
            }
            catch (Exception e) {
                int i;
                String msg = e.getMessage();
                if (msg == null && (i = (msg = e.toString()).lastIndexOf("?\n")) > -1) {
                    msg = msg.substring(i + 2).trim();
                }
                msg = msg.replaceAll("\n", "<br>\n");
                return new PyString("<html>highlite an expression:<br>" + msg);
            }
        };
    }

    public String getToolTipText(MouseEvent me) {
        int offset = this.editorPanel.viewToModel(me.getPoint());
        if (this.editorPanel.getSelectionStart() <= offset && offset <= this.editorPanel.getSelectionEnd()) {
            String expr = this.editorPanel.getSelectedText();
            if (expressionLookup != null) {
                if (expr != null) {
                    PyObject po = expressionLookup.lookup(expr);
                    String peek = String.valueOf(po.__str__());
                    if (peek.startsWith("<html>")) {
                        return peek;
                    }
                    if (po instanceof PyJavaInstance) {
                        try {
                            return "<html>" + expr + "=" + peek + "<br>" + ((PyJavaInstance)po).instclass.safeRepr();
                        }
                        catch (PyIgnoreMethodTag ex) {
                            return "<html>" + expr + "=" + peek + "<br>" + po.getType();
                        }
                    }
                    return "<html>" + expr + "=" + peek + "<br>" + po.getType();
                }
            } else {
                return "Interpreter is not active";
            }
        }
        if (offset > 0) {
            Annotation ann = this.annotationAt(offset);
            if (ann != null) {
                return this.htmlify(ann.text);
            }
            return null;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 250);
    }

    public static interface ExpressionLookup {
        public PyObject lookup(String var1);
    }

    private static class Annotation {
        String text;
        int offset;
        int len;
        Markers.SimpleMarker marker;
        Object highlightInfo;

        private Annotation() {
        }
    }
}

