/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.autoplot.jythonsupport.JythonToJavaConverter;
import org.das2.jythoncompletion.DefaultCompletionItem;
import org.das2.jythoncompletion.Utilities;
import org.das2.jythoncompletion.ui.CompletionImpl;

public class ClassImportCompletionItem
extends DefaultCompletionItem {
    String pkg;
    String name;

    public ClassImportCompletionItem(String text, int offset, String complete, String label, String link, int sortPriority, ImageIcon icon, String pkg, String name) {
        super(text, offset, complete, label, link, sortPriority, icon);
        this.pkg = pkg;
        this.name = name;
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        try {
            int pos = jTextComponent.getCaretPosition();
            Document d = jTextComponent.getDocument();
            int lineEnd = Utilities.getRowEnd(jTextComponent, pos);
            String restOfLine = d.getText(pos, lineEnd - pos);
            if (!restOfLine.startsWith(this.complete.substring(this.offset))) {
                d.insertString(pos, this.complete.substring(this.offset), null);
            }
            JythonToJavaConverter.addImport(d, this.pkg, this.name, lineEnd);
            CompletionImpl.get().hideCompletion(false);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ClassImportCompletionItem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }
}

