/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.jython.JythonDataSource;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;

public class JythonDataSourceTimeSeriesBrowse
implements TimeSeriesBrowse {
    private static final Logger logger = Logger.getLogger("apdss.jyds");
    DatumRange timeRange;
    String uri;
    JythonDataSource jds;

    JythonDataSourceTimeSeriesBrowse(String uri) {
        this.uri = uri;
    }

    protected void setJythonDataSource(JythonDataSource jds) {
        this.jds = jds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeRange(DatumRange dr) {
        if (!(this.jds == null || this.timeRange != null && this.timeRange.equals((Object)dr))) {
            JythonDataSource jythonDataSource = this.jds;
            synchronized (jythonDataSource) {
                if (this.jds.interp != null) {
                    logger.fine("TSB resetting interpretter and caching");
                    this.jds.interp = null;
                }
            }
        }
        this.timeRange = dr;
        URISplit split = URISplit.parse((String)this.uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        params.put("timerange", dr.toString());
        split.params = URISplit.formatParams((Map)params);
        this.uri = URISplit.format((URISplit)split);
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeResolution(Datum d) {
    }

    public Datum getTimeResolution() {
        return null;
    }

    public String getURI() {
        return this.uri;
    }

    public String blurURI() {
        URISplit split = URISplit.parse((String)this.uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        params.remove("timerange");
        split.params = URISplit.formatParams((Map)params);
        return URISplit.format((URISplit)split);
    }

    public void setURI(String suri) throws ParseException {
        this.uri = suri;
        DatumRange tr = URISplit.parseTimeRange((String)this.uri);
        if (tr != null) {
            this.timeRange = tr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JythonDataSourceTimeSeriesBrowse checkForTimeSeriesBrowse(String uri, File jythonScript) throws IOException, ParseException {
        JythonDataSourceTimeSeriesBrowse tsb1 = null;
        try (BufferedReader reader = null;){
            reader = new LineNumberReader(new FileReader(jythonScript));
            String line = reader.readLine();
            String timeRangeRegex = "\\'([^']*)?\\'";
            Pattern s = Pattern.compile(".*getParam\\(\\s*\\'timerange\\',\\s*" + timeRangeRegex + "\\s*(,\\s*\\'.*\\')?\\s*\\).*");
            while (line != null) {
                String[] ss = Util.guardedSplit((String)line, (char)'#', (char)'\'', (char)'\"');
                Matcher m = s.matcher(line = ss[0]);
                if (m.matches()) {
                    tsb1 = new JythonDataSourceTimeSeriesBrowse(uri);
                    String str = m.group(1);
                    URISplit split = URISplit.parse((String)uri);
                    LinkedHashMap params = URISplit.parseParams((String)split.params);
                    String stimerange = (String)params.get("timerange");
                    if (stimerange != null && stimerange.length() > 0 && (str = (String)params.get("timerange")).startsWith("'") && str.endsWith("'") && str.length() > 1) {
                        str = str.substring(1, str.length() - 1);
                    }
                    DatumRange tr = DatumRangeUtil.parseTimeRange((String)str);
                    tsb1.setTimeRange(tr);
                } else if (!line.contains("timerange") || line.contains("getParam(")) {
                    // empty if block
                }
                line = reader.readLine();
            }
        }
        return tsb1;
    }
}

