/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.awt.Window;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.jython.JythonEditorPanel;
import org.autoplot.datasource.jython.JythonExtensionDataSourceFactory;
import org.das2.util.monitor.ProgressMonitor;

public class JythonExtensionDataSourceEditorPanel
implements DataSourceEditorPanel {
    JythonEditorPanel edit;
    String uri;

    public boolean reject(String uri) throws Exception {
        this.edit = new JythonEditorPanel();
        String jydsUri = JythonExtensionDataSourceFactory.getJydsUri(DataSetURI.getURI((String)uri));
        return this.edit.reject(jydsUri);
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        String jydsUri = JythonExtensionDataSourceFactory.getJydsUri(DataSetURI.getURI((String)uri));
        return this.edit.prepare(jydsUri, parent, mon);
    }

    public void setURI(String uri) {
        try {
            this.uri = uri;
            String jydsUri = JythonExtensionDataSourceFactory.getJydsUri(DataSetURI.getURI((String)uri));
            this.edit.setURI(jydsUri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void markProblems(List<String> problems) {
    }

    public JPanel getPanel() {
        return this.edit.getPanel();
    }

    public String getURI() {
        String jydsUri = this.edit.getURI();
        URISplit split = URISplit.parse((String)jydsUri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        params.remove("script");
        split.params = URISplit.formatParams((Map)params);
        URISplit mySplit = URISplit.parse((String)this.uri);
        split.vapScheme = mySplit.vapScheme;
        return URISplit.format((URISplit)split);
    }
}

