/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.inline;

import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.inline.InlineDataSourceFactory;
import org.autoplot.inline.InlineTimeSeriesBrowse;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;

public class InlineDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.inline");
    PythonInterpreter interp;
    TimeSeriesBrowse tsb = null;

    public InlineDataSource(URI uri) {
        super(uri, false);
        ArrayList<String> script = new ArrayList<String>();
        String timerange = InlineDataSourceFactory.getScript(uri.toString(), script);
        if (timerange != null) {
            try {
                this.tsb = InlineTimeSeriesBrowse.create(uri.toString(), timerange);
                this.addCapability(TimeSeriesBrowse.class, this.tsb);
            }
            catch (ParseException ex) {
                logger.warning(ex.toString());
            }
        }
    }

    private MutablePropertyDataSet handleJythonExpression(String c) throws Exception {
        QDataSet res;
        logger.finest(c);
        PyObject result = InlineDataSource.evalCommand(this.interp, c);
        if (result instanceof PyList) {
            res = JythonOps.dataset((PyObject)((PyList)result));
        } else if (result instanceof PyTuple && ((PyTuple)result).size() < 3) {
            PyTuple tres = (PyTuple)result;
            switch (tres.size()) {
                case 2: {
                    res = Ops.link((QDataSet)((QDataSet)tres.get(0)), (QDataSet)((QDataSet)tres.get(1)));
                    break;
                }
                case 3: {
                    res = Ops.link((QDataSet)((QDataSet)tres.get(0)), (QDataSet)((QDataSet)tres.get(1)), (QDataSet)((QDataSet)tres.get(2)));
                    break;
                }
                case 1: {
                    res = (QDataSet)tres.get(0);
                    break;
                }
                default: {
                    throw new ParseException("unable to parse command: " + c, 0);
                }
            }
        } else {
            res = (QDataSet)result.__tojava__(QDataSet.class);
            if (res == null) {
                throw new IllegalArgumentException("expression is not a QDataSet: " + c);
            }
        }
        return DataSetOps.makePropertiesMutable((QDataSet)res);
    }

    private MutablePropertyDataSet parseInlineDsSimple(String s) {
        logger.log(Level.FINEST, "parseInlineDsSimple {0}", s);
        Units u = Units.dimensionless;
        TimeLocationUnits tu = Units.us2000;
        EnumerationUnits eu = EnumerationUnits.create((Object)"default");
        String[] ss2 = s.split(",");
        DDataSet result = DDataSet.createRank1((int)ss2.length);
        boolean isTime = false;
        boolean isEnum = false;
        for (String ss21 : ss2) {
            try {
                if (isTime || isEnum) continue;
                try {
                    u.parse(ss21);
                }
                catch (InconvertibleUnitsException ex3) {
                    Datum d = DatumUtil.lookupDatum((String)ss21);
                    u = d.getUnits();
                }
            }
            catch (ParseException e) {
                isTime = true;
                if (isEnum) continue;
                try {
                    tu.parse(ss21);
                }
                catch (ParseException ex) {
                    try {
                        Datum d = DatumUtil.lookupDatum((String)ss21);
                        u = d.getUnits();
                        isTime = false;
                    }
                    catch (ParseException ex2) {
                        isEnum = true;
                    }
                }
            }
        }
        try {
            for (int j = 0; j < ss2.length; ++j) {
                String ss = ss2[j];
                if (isEnum) {
                    if (ss.startsWith("'") && ss.endsWith("'")) {
                        ss = ss.substring(1, ss.length() - 1);
                    }
                    result.putValue(j, eu.createDatum((Object)ss).doubleValue((Units)eu));
                    if (j != 0) continue;
                    result.putProperty("UNITS", (Object)eu);
                    continue;
                }
                if (isTime) {
                    result.putValue(j, tu.parse(ss).doubleValue((Units)tu));
                    if (j != 0) continue;
                    result.putProperty("UNITS", (Object)tu);
                    continue;
                }
                result.putValue(j, u.parse(ss).value());
                if (j != 0 || u == Units.dimensionless) continue;
                result.putProperty("UNITS", (Object)u);
            }
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        if (ss2.length == 1) {
            return Ops.copy((QDataSet)result.slice(0));
        }
        return result;
    }

    private MutablePropertyDataSet parseInlineDs(String s) throws Exception {
        logger.log(Level.FINEST, "parseInlineDs {0}", s);
        if (s.equals("None") || s.equals("null") || s.equals("")) {
            return null;
        }
        String linkCommand = null;
        try {
            PyObject result;
            if (Ops.isSafeName((String)s)) {
                result = InlineDataSource.evalCommand(this.interp, s);
            } else {
                linkCommand = "link( " + s + ")";
                result = InlineDataSource.evalCommand(this.interp, linkCommand);
            }
            QDataSet res = (QDataSet)result.__tojava__(QDataSet.class);
            return DataSetOps.makePropertiesMutable((QDataSet)res);
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "failed to execute: {0}", linkCommand != null ? linkCommand : s);
            logger.log(Level.FINE, ex.getMessage(), ex);
            try {
                return this.handleJythonExpression(s);
            }
            catch (Exception ex2) {
                boolean isNotList;
                boolean bl = isNotList = s.length() > 0 && (s.charAt(0) >= 'a' && s.charAt(0) <= 'z' || s.charAt(0) == '(');
                if (isNotList) {
                    throw new IllegalArgumentException("inline jython code raises exception: " + ex2, ex2);
                }
                String[] ss = s.split(";", -2);
                if (ss.length > 1) {
                    BundleDataSet bds = BundleDataSet.createRank1Bundle();
                    String[] ss2 = ss[0].split(",");
                    int nds = ss2.length;
                    int nrec = ss.length;
                    for (int j = 0; j < nds; ++j) {
                        DataSetBuilder b = new DataSetBuilder(1, ss.length);
                        for (int i = 0; i < nrec; ++i) {
                            ss2 = ss[i].split(",");
                            if (j == 0 && ss2[j].trim().length() == 0 && i < nrec) {
                                nrec = i;
                                continue;
                            }
                            MutablePropertyDataSet result = this.parseInlineDsSimple(ss2[j]);
                            b.putValue(-1, result.value());
                            b.putProperty("UNITS", result.property("UNITS"));
                            b.nextRecord();
                        }
                        bds.bundle((QDataSet)b.getDataSet());
                    }
                    return bds;
                }
                MutablePropertyDataSet result = this.parseInlineDsSimple(ss[0]);
                return result;
            }
        }
    }

    protected static String[] guardedSplit(String s, char delim, char exclude1, char exclude2) {
        return Util.guardedSplit((String)s, (char)delim, (char)exclude1, (char)exclude2);
    }

    private boolean isPropName(String n) {
        return DataSetUtil.getPropertyType((String)n) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        MutablePropertyDataSet bundle1;
        MutablePropertyDataSet ds;
        block60: {
            MutablePropertyDataSet[] depn;
            block59: {
                MutablePropertyDataSet zz;
                MutablePropertyDataSet xx;
                block62: {
                    block61: {
                        String propValue;
                        String s = this.tsb == null ? this.getURI() : this.tsb.getURI();
                        logger.log(Level.FINE, "getDataSet {0}", s);
                        logger.log(Level.FINER, "create interpreter");
                        this.interp = JythonUtil.createInterpreter((boolean)true);
                        if (!Util.isLegacyImports()) {
                            logger.log(Level.FINER, "import the stuff we don't import automatically anymore");
                            try (InputStream in = Util.class.getResource("imports2023.py").openStream();){
                                this.interp.execfile(in, "imports2023.py");
                            }
                        }
                        ArrayList<String> script = new ArrayList<String>();
                        String timerange = InlineDataSourceFactory.getScript(s, script);
                        String[] ss = script.toArray(new String[script.size()]);
                        if (timerange != null) {
                            this.interp.set("timerange", (Object)timerange);
                        }
                        ds = null;
                        bundle1 = null;
                        depn = new MutablePropertyDataSet[4];
                        Map[] deppropn = new Map[4];
                        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
                        if (ss.length == 1 && ss[0].equals("None")) {
                            logger.info("vap+inline:None is useful for testing");
                            return null;
                        }
                        mon.setTaskSize((long)ss.length);
                        mon.started();
                        try {
                            Pattern depPat = Pattern.compile("DEPEND_(\\d+)(\\.([A-Z]+))?");
                            for (int i = 0; i < ss.length; ++i) {
                                mon.setTaskProgress((long)i);
                                mon.setProgressMessage(ss[i]);
                                String arg = ss[i];
                                if (arg.length() == 0) continue;
                                String propName = null;
                                int ieq = arg.indexOf(61);
                                if (ieq > -1 && this.isPropName(arg.substring(0, ieq).trim())) {
                                    propName = arg.substring(0, ieq).trim();
                                }
                                if (propName != null) {
                                    propValue = arg.substring(ieq + 1).trim();
                                    Matcher m = depPat.matcher(propName);
                                    if (m.matches()) {
                                        int idep = Integer.parseInt(m.group(1));
                                        if (m.group(3) != null) {
                                            HashMap<String, String> map = deppropn[idep];
                                            if (map == null) {
                                                deppropn[idep] = map = new HashMap<String, String>();
                                            }
                                            map.put(m.group(3), propValue);
                                            continue;
                                        }
                                        depn[idep] = this.parseInlineDs(propValue);
                                        continue;
                                    }
                                    if (propName.startsWith("BUNDLE_1")) {
                                        if (propValue.equals("") || propValue.equals("None") || propValue.equals("null")) {
                                            p.put(propName, propValue);
                                            continue;
                                        }
                                        bundle1 = this.parseInlineDs(propValue);
                                        continue;
                                    }
                                    if (DataSetUtil.isDimensionProperty((String)propName) || propName.equals("RENDER_TYPE") || propName.equals("DELTA_PLUS") || propName.equals("DELTA_MINUS")) {
                                        p.put(propName, propValue);
                                        continue;
                                    }
                                    this.interp.set("monitor", (Object)mon.getSubtaskMonitor(arg));
                                    InlineDataSource.execCommand(this.interp, arg);
                                    continue;
                                }
                                if (this.isAssignment(arg)) {
                                    logger.log(Level.FINER, "assignment {0}", arg);
                                    this.interp.set("monitor", (Object)mon.getSubtaskMonitor(arg));
                                    arg = URISplit.uriDecode((String)arg);
                                    if (arg.startsWith("timerange=")) continue;
                                    try {
                                        InlineDataSource.execCommand(this.interp, arg);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        if (ex instanceof PyException) {
                                            Object o = ((PyException)((Object)ex)).value.__tojava__(Exception.class);
                                            if (o == Py.NoConversion) {
                                                throw ex;
                                            }
                                            Exception ex2 = (Exception)o;
                                            throw ex2;
                                        }
                                        throw ex;
                                    }
                                }
                                ds = this.parseInlineDs(arg);
                            }
                        }
                        finally {
                            mon.finished();
                        }
                        if (ds == null) {
                            throw new IllegalArgumentException("URI don't contain anything to plot");
                        }
                        for (int idep = 0; idep < 4; ++idep) {
                            Map depp = deppropn[idep];
                            if (depp == null) continue;
                            block32: for (Map.Entry ent : depp.entrySet()) {
                                String prop = (String)ent.getKey();
                                MutablePropertyDataSet dep0 = depn[idep];
                                if (dep0 == null) {
                                    throw new IllegalArgumentException("DEPEND_" + idep + "." + prop + " specified, but no DEPEND_" + idep + " ds");
                                }
                                propValue = (String)ent.getValue();
                                switch (prop) {
                                    case "UNITS": {
                                        dep0.putProperty(prop, (Object)Units.lookupUnits((String)propValue));
                                        continue block32;
                                    }
                                    case "FILL_VALUE": 
                                    case "VALID_MIN": 
                                    case "VALID_MAX": 
                                    case "TYPICAL_MIN": 
                                    case "TYPICAL_MAX": {
                                        dep0.putProperty(prop, (Object)Double.parseDouble(propValue));
                                        continue block32;
                                    }
                                    case "MONOTONIC": {
                                        dep0.putProperty(prop, (Object)Boolean.parseBoolean(propValue));
                                        continue block32;
                                    }
                                }
                                dep0.putProperty(prop, (Object)propValue);
                            }
                        }
                        for (Map.Entry e : p.entrySet()) {
                            String prop = (String)e.getKey();
                            String propValue2 = (String)e.getValue();
                            ds = Ops.putProperty(ds, (String)prop, (Object)propValue2);
                        }
                        if (depn[0] != null) break block59;
                        if (bundle1 != null || ds.rank() != 2 || ds.length(1) != 2) break block60;
                        if (!Ops.isBundle((QDataSet)ds)) break block61;
                        xx = (MutablePropertyDataSet)DataSetOps.unbundle((QDataSet)ds, (int)0);
                        zz = (MutablePropertyDataSet)DataSetOps.unbundle((QDataSet)ds, (int)1);
                        zz.putProperty("DEPEND_0", (Object)xx);
                        ds = zz;
                        break block60;
                    }
                    if (!(ds instanceof BundleDataSet)) break block62;
                    BundleDataSet bds = (BundleDataSet)ds;
                    MutablePropertyDataSet xx2 = (MutablePropertyDataSet)bds.unbundle(0);
                    MutablePropertyDataSet zz2 = (MutablePropertyDataSet)bds.unbundle(ds.length(0) - 1);
                    if (ds.property("RENDER_TYPE") != null) {
                        zz2.putProperty("RENDER_TYPE", ds.property("RENDER_TYPE"));
                    }
                    zz2.putProperty("DEPEND_0", (Object)xx2);
                    ds = zz2;
                    break block60;
                }
                if (Schemes.isBoundingBox((QDataSet)ds)) break block60;
                xx = DDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)ds, (int)0));
                zz = DDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)ds, (int)(ds.length(0) - 1)));
                DataSetUtil.copyDimensionProperties((QDataSet)ds, (MutablePropertyDataSet)zz);
                if (ds.property("RENDER_TYPE") != null) {
                    zz.putProperty("RENDER_TYPE", ds.property("RENDER_TYPE"));
                }
                zz.putProperty("DEPEND_0", (Object)xx);
                ds = zz;
                break block60;
            }
            for (int idep = 0; idep < 4; ++idep) {
                ds.putProperty("DEPEND_" + idep, (Object)depn[idep]);
            }
        }
        if (bundle1 != null) {
            ds.putProperty("BUNDLE_1", bundle1);
        }
        return ds;
    }

    private static void execCommand(PythonInterpreter interp, String arg) {
        if (arg.contains("execfile")) {
            throw new IllegalArgumentException("inline commands cannot contain execfile");
        }
        if (arg.contains("__import__")) {
            throw new IllegalArgumentException("inline commands cannot contain __import__");
        }
        interp.exec(arg);
    }

    private static PyObject evalCommand(PythonInterpreter interp, String arg) {
        if (arg.contains("execfile")) {
            throw new IllegalArgumentException("inline commands cannot contain execfile");
        }
        if (arg.contains("__import__")) {
            throw new IllegalArgumentException("inline commands cannot contain __import__");
        }
        return interp.eval(arg);
    }

    private boolean isAssignment(String arg) {
        int i = arg.indexOf("=");
        if (i == -1) {
            return false;
        }
        String varNames = arg.substring(0, i);
        Pattern p = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*\\s*");
        if (p.matcher(varNames).matches()) {
            return true;
        }
        Pattern p2 = Pattern.compile("\\(([a-zA-Z_][a-zA-Z_0-9]*)(\\,[a-zA-Z_][a-zA-Z_0-9]*)*\\)");
        return p2.matcher(varNames).matches();
    }
}

