/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.inline;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.inline.InlineDataSourceFactory;
import org.autoplot.jythonsupport.Util;
import org.autoplot.jythonsupport.ui.DataMashUp;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.LoggerManager;

public class InlineTimeSeriesBrowse
implements TimeSeriesBrowse {
    public String uri;
    DatumRange timeRange;
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.util");

    protected InlineTimeSeriesBrowse() {
    }

    public static TimeSeriesBrowse create(String uri, String timerange) throws ParseException {
        InlineTimeSeriesBrowse tsb = new InlineTimeSeriesBrowse();
        tsb.setURI(uri);
        if (timerange != null) {
            tsb.setTimeRange(DatumRangeUtil.parseTimeRange((String)timerange));
        }
        return tsb;
    }

    public void setURI(String suri) throws ParseException {
        logger.log(Level.FINE, "setURI {0}", suri);
        ArrayList<String> script = new ArrayList<String>();
        String tr = InlineDataSourceFactory.getScript(suri, script);
        if (tr != null) {
            this.timeRange = DatumRangeUtil.parseTimeRange((String)tr.replaceAll("\\+", " "));
        }
        this.uri = suri;
    }

    public String getURI() {
        if (this.uri == null) {
            throw new NullPointerException("uri has not been set");
        }
        return this.uri;
    }

    public void setTimeRange(DatumRange dr) {
        logger.log(Level.FINE, "setTimeRange {0}", dr);
        if (this.uri != null) {
            String uri1;
            String[] ascript = Util.guardedSplit((String)this.uri, (char)'&', (char)'\'', (char)'\"');
            ArrayList<String> script = new ArrayList<String>(Arrays.asList(ascript));
            boolean modified = false;
            for (int i = 0; i < script.size(); ++i) {
                String line = (String)script.get(i);
                if (line.startsWith("timerange")) {
                    line = "timerange=" + dr.toString().replaceAll(" ", "+");
                    modified = true;
                }
                script.set(i, line);
            }
            if (DataMashUp.isDataMashupJythonInline((String)this.uri) && !modified) {
                script.add("timerange=" + dr.toString().replaceAll(" ", "+"));
            }
            this.uri = uri1 = DataSourceUtil.strjoin(script, (String)"&");
        }
        this.timeRange = dr;
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeResolution(Datum d) {
    }

    public Datum getTimeResolution() {
        return null;
    }

    public static boolean reject(Map map, List<String> problems) {
        if (!map.containsKey("timerange")) {
            problems.add("no timerange provided");
            return true;
        }
        String timeRange = (String)map.get("timerange");
        if ((timeRange = timeRange.replaceAll("\\+", " ")).length() < 3) {
            problems.add("no timerange provided");
            return true;
        }
        try {
            DatumRange dr = DatumRangeUtil.parseTimeRange((String)timeRange);
            logger.log(Level.FINEST, "timeRange parses to {0}", dr);
        }
        catch (ParseException ex) {
            problems.add("parse error in timeRange");
            return true;
        }
        return false;
    }

    public String blurURI() {
        if (this.uri == null) {
            throw new NullPointerException("uri has not been set");
        }
        String[] ascript = Util.guardedSplit((String)this.uri, (char)'&', (char)'\'', (char)'\"');
        ArrayList<String> script = new ArrayList<String>(Arrays.asList(ascript));
        int itr = -1;
        for (int i = 0; i < script.size(); ++i) {
            String line = (String)script.get(i);
            if (!line.startsWith("timerange")) continue;
            itr = i;
        }
        String uri1 = DataSourceUtil.strjoin(script, (String)"&");
        return uri1;
    }
}

