/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.complex;

import ProGAL.geom3d.Triangle;
import ProGAL.geom3d.complex.CEdge;
import ProGAL.geom3d.complex.CTetrahedron;
import ProGAL.geom3d.complex.CVertex;

public class CTriangle
extends Triangle {
    private CTetrahedron[] adjacentTetrahedra = new CTetrahedron[2];
    private CEdge[] edges = new CEdge[3];

    public CTriangle(CVertex p0, CVertex p1, CVertex p2, CTetrahedron t1, CTetrahedron t2) {
        super(p0, p1, p2);
        this.orderPoints(p0, p1, p2);
        this.adjacentTetrahedra[0] = t1;
        this.adjacentTetrahedra[1] = t2;
    }

    public void setNeighbour(int index, CTetrahedron t) {
        this.adjacentTetrahedra[index] = t;
    }

    public CTetrahedron getAdjacentTetrahedron(int index) {
        return this.adjacentTetrahedra[index];
    }

    public CEdge getEdge(int i) {
        return this.edges[i];
    }

    public void setEdge(int i, CEdge e) {
        this.edges[i] = e;
    }

    public CVertex oppositeVertex(CEdge e) {
        if (!e.containsPoint(this.p1)) {
            return (CVertex)this.p1;
        }
        if (!e.containsPoint(this.p2)) {
            return (CVertex)this.p2;
        }
        return (CVertex)this.p3;
    }

    private void orderPoints(CVertex a, CVertex b, CVertex c) {
        CVertex[] p = new CVertex[3];
        if (a.dominates(b) && a.dominates(c)) {
            p[0] = a;
            if (b.dominates(c)) {
                p[1] = b;
                p[2] = c;
            } else {
                p[1] = c;
                p[2] = b;
            }
        } else if (b.dominates(a) && b.dominates(c)) {
            p[0] = b;
            if (a.dominates(c)) {
                p[1] = a;
                p[2] = c;
            } else {
                p[1] = c;
                p[2] = a;
            }
        } else {
            p[0] = c;
            if (a.dominates(b)) {
                p[1] = a;
                p[2] = b;
            } else {
                p[1] = b;
                p[2] = a;
            }
        }
        this.p1 = p[0];
        this.p2 = p[1];
        this.p3 = p[2];
    }

    public boolean equals(Object o) {
        if (!(o instanceof CTriangle)) {
            return false;
        }
        return ((CTriangle)o).p1 == this.p1 && ((CTriangle)o).p2 == this.p2 && ((CTriangle)o).p3 == this.p3;
    }

    public int hashCode() {
        return this.p1.hashCode() ^ this.p2.hashCode() ^ this.p3.hashCode();
    }

    public boolean containsPoint(CVertex point) {
        return this.p1 == point || this.p2 == point || this.p3 == point;
    }

    public boolean containsBigPoint() {
        return ((CVertex)this.p1).isBigpoint() || ((CVertex)this.p2).isBigpoint() || ((CVertex)this.p3).isBigpoint();
    }
}

