/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.math.Constants;
import ProGAL.math.Matrix;
import ProGAL.math.Polynomial;

public class Torus {
    protected Point center;
    protected Vector normal;
    protected double R;
    protected double r;

    public Torus(Point center, Vector normal, double majorRadius, double minorRadius) {
        this.center = center;
        this.normal = normal;
        this.R = majorRadius;
        this.r = minorRadius;
    }

    public boolean contains(Point q) {
        double RR = this.R * this.R;
        Vector vp = new Vector(this.center, q);
        return Math.pow(q.distanceSquared(this.center) + RR - this.r * this.r, 2.0) - 4.0 * RR * vp.cross(this.normal).getLengthSquared() < 0.0;
    }

    public Circle getMainCircle() {
        return new Circle(this.center, this.R, this.normal);
    }

    public Plane getMainPlane() {
        return new Plane(this.center, this.normal);
    }

    public Circle getPoloidalCircle() {
        return null;
    }

    public Circle getSweepingCircle() {
        Vector v = this.normal.getOrthonormal();
        return new Circle(this.center.add(v.scaleToLength(this.R)), this.r, this.normal.cross(v));
    }

    public Sphere getSweepingSphere() {
        Vector v = this.normal.getOrthonormal();
        return new Sphere(this.center.add(v.scaleToLength(this.R)), this.r);
    }

    public double getSurfaceArea() {
        return 39.47841760435743 * this.R * this.r;
    }

    public Circle getToroidalCircle() {
        return new Circle(this.center, this.R, this.normal);
    }

    public double getVolume() {
        return 19.739208802178716 * this.R * this.r * this.r;
    }

    public Circle[] getVillarceauCircles() {
        return null;
    }

    public double getMajorRadius() {
        return this.R;
    }

    public double getMinorRadius() {
        return this.r;
    }

    public Vector getNormal() {
        return this.normal;
    }

    public Point getCenter() {
        return this.center;
    }

    public Point[] getIntersectionCircle(Circle C) {
        Polynomial func;
        int tmpDeg;
        Matrix E;
        double nz;
        Vector b_;
        Vector a_;
        double ny;
        Vector e3 = new Vector(0.0, 0.0, 1.0);
        Vector rotAxis = this.normal.cross(e3);
        if (!rotAxis.equals(new Vector(0.0, 0.0, 0.0))) {
            rotAxis.normalizeThis();
        }
        double angle = this.normal.angle(e3);
        Matrix rotMatrix = Matrix.createRotationMatrix(angle, rotAxis);
        Vector translate = new Vector(-this.center.x(), -this.center.y(), -this.center.z());
        Vector newCircleNormal = rotMatrix.multiply(C.getNormal()).normalizeThis();
        Point CC0 = C.getCenter().add(translate);
        Point newCircleCenter = (Point)rotMatrix.multiplyIn(CC0);
        Point[] intersections = new Point[4];
        double nx = newCircleNormal.get(0);
        if (nx * nx + (ny = newCircleNormal.get(1)) * ny == 0.0) {
            double ax = 1.0;
            double ay = 0.0;
            double az = 0.0;
            a_ = new Vector(ax, ay, az);
            double bx = 0.0;
            double by = 1.0;
            double bz = 0.0;
            b_ = new Vector(bx, by, bz);
            nx = 0.0;
            ny = 0.0;
            nz = 1.0;
        } else {
            nz = newCircleNormal.get(2);
            a_ = newCircleNormal.getOrthogonal().normalizeThis();
            b_ = a_.cross(newCircleNormal).normalizeThis();
        }
        double[] m1 = new double[]{a_.get(0), b_.get(0), nx};
        double[] m2 = new double[]{a_.get(1), b_.get(1), ny};
        double[] m3 = new double[]{a_.get(2), b_.get(2), nz};
        double[][] mlist = new double[][]{m1, m2, m3};
        double alph = newCircleCenter.dot(newCircleCenter);
        double gam = newCircleCenter.dot(a_);
        double del = newCircleCenter.dot(b_);
        double eps = alph + C.getRadius() * C.getRadius() + this.R * this.R - this.r * this.r;
        double a = 4.0 * gam * gam - 4.0 * this.R * this.R * (a_.get(0) * a_.get(0) + a_.get(1) * a_.get(1));
        double b = 4.0 * del * del - 4.0 * this.R * this.R * (b_.get(0) * b_.get(0) + b_.get(1) * b_.get(1));
        double f = 4.0 * gam * del - 4.0 * this.R * this.R * (a_.get(0) * b_.get(0) + a_.get(1) * b_.get(1));
        double l = 2.0 * gam * eps - 4.0 * this.R * this.R * (newCircleCenter.x() * a_.get(0) + newCircleCenter.y() * a_.get(1));
        double m = 2.0 * del * eps - 4.0 * this.R * this.R * (newCircleCenter.x() * b_.get(0) + newCircleCenter.y() * b_.get(1));
        double d = eps * eps - 4.0 * this.R * this.R * (newCircleCenter.x() * newCircleCenter.x() + newCircleCenter.y() * newCircleCenter.y());
        double[] er0 = new double[]{a, f, l};
        double[] er1 = new double[]{f, b, m};
        double[] er2 = new double[]{l, m, d};
        double[][] emat = new double[][]{er0, er1, er2};
        Matrix ENew = E = new Matrix(emat);
        double[] pars = new double[5];
        pars[4] = ENew.get(0, 0) * C.getRadius() * C.getRadius() - 2.0 * ENew.get(2, 0) * C.getRadius() + ENew.get(2, 2);
        pars[3] = -4.0 * ENew.get(1, 0) * C.getRadius() * C.getRadius() + 4.0 * ENew.get(1, 2) * C.getRadius();
        pars[2] = -2.0 * ENew.get(0, 0) * C.getRadius() * C.getRadius() + 4.0 * ENew.get(1, 1) * C.getRadius() * C.getRadius() + 2.0 * ENew.get(2, 2);
        pars[1] = 4.0 * ENew.get(0, 1) * C.getRadius() * C.getRadius() + 4.0 * ENew.get(1, 2) * C.getRadius();
        pars[0] = ENew.get(0, 0) * C.getRadius() * C.getRadius() + 2.0 * ENew.get(0, 2) * C.getRadius() + ENew.get(2, 2);
        for (int z = 0; z < 5; ++z) {
            if (!(Math.abs(pars[z]) <= Constants.EPSILON)) continue;
            pars[z] = 0.0;
        }
        for (tmpDeg = 4; tmpDeg != 0 && pars[tmpDeg] == 0.0; --tmpDeg) {
        }
        if (tmpDeg != 4) {
            double[] coeffs = new double[tmpDeg + 1];
            for (int i = 0; i <= tmpDeg; ++i) {
                coeffs[i] = pars[i];
            }
            func = new Polynomial(coeffs);
        } else {
            func = new Polynomial(pars);
        }
        Double[] roots = Polynomial.solveQuartic(func.coeff);
        if (roots == null) {
            return null;
        }
        if (roots.length == 0) {
            return null;
        }
        for (int k = 0; k < roots.length; ++k) {
            double root = roots[k];
            double[] parameters = new double[]{(newCircleCenter.x() - C.getRadius() * a_.get(0)) * root * root + 2.0 * C.getRadius() * b_.get(0) * root + newCircleCenter.x() + C.getRadius() * a_.get(0), (newCircleCenter.y() - C.getRadius() * a_.get(1)) * root * root + 2.0 * C.getRadius() * b_.get(1) * root + newCircleCenter.y() + C.getRadius() * a_.get(1), (newCircleCenter.z() - C.getRadius() * a_.get(2)) * root * root + 2.0 * C.getRadius() * b_.get(2) * root + newCircleCenter.z() + C.getRadius() * a_.get(2), root * root + 1.0};
            Point pk = new Point(parameters[0] / parameters[3], parameters[1] / parameters[3], parameters[2] / parameters[3]);
            Point rotPoint = (Point)rotMatrix.invert().multiplyIn(pk);
            intersections[k] = rotPoint.subtractThis(translate);
        }
        return intersections;
    }
}

