/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.QDataSet;

public final class IndexGenDataSet
extends AbstractDataSet {
    int length;

    public IndexGenDataSet(int length) {
        this.length = length;
        this.properties.put("MONOTONIC", Boolean.TRUE);
        this.properties.put("FORMAT", "%d");
    }

    @Override
    public int rank() {
        return 1;
    }

    @Override
    public double value(int i) {
        return i;
    }

    @Override
    public int length() {
        return this.length;
    }

    public static QDataSet lastindex(final QDataSet src) {
        if (src.rank() == 1) {
            return new IndexGenDataSet(src.length());
        }
        if (src.rank() == 0) {
            return new IndexGenDataSet(1);
        }
        boolean rank2 = false;
        int firstLength = src.length(0);
        for (int i = 1; i < src.length(); ++i) {
            if (src.length(i) == firstLength) continue;
            rank2 = true;
        }
        if (!rank2) {
            return new IndexGenDataSet(src.length());
        }
        AbstractDataSet result = new AbstractDataSet(){

            @Override
            public int rank() {
                return src.rank();
            }

            @Override
            public double value(int i0) {
                return i0;
            }

            @Override
            public double value(int i0, int i1) {
                return i1;
            }

            @Override
            public int length() {
                return src.length();
            }

            @Override
            public int length(int i) {
                return src.length(i);
            }
        };
        result.putProperty("FORMAT", "%d");
        return result;
    }
}

