/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.Slice1DataSet;

public final class Slice2DataSet
extends AbstractDataSet {
    QDataSet ds;
    int index;

    public Slice2DataSet(QDataSet ds, int index) {
        this(ds, index, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Slice2DataSet(QDataSet ds, int index, boolean addContext) {
        String[] props;
        String prop;
        QDataSet qDataSet;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        if (ds.rank() < 3) {
            throw new IllegalArgumentException("rank limit < 3");
        }
        if (ds.length() == 0) {
            int[] qube = DataSetUtil.qubeDims(ds);
            if (qube == null) throw new IndexOutOfBoundsException("dataset is empty and slice2 index is out of bounds");
            if (index >= qube[2]) {
                throw new IndexOutOfBoundsException("slice2 index is out of bounds");
            }
        } else if (index >= ds.length(0, 0)) {
            throw new IndexOutOfBoundsException("slice2 index is out of bounds");
        }
        this.ds = ds;
        this.index = index;
        if (addContext) {
            QDataSet bundle = (QDataSet)ds.property("BUNDLE_2");
            QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
            if (bundle != null && dep2 == null) {
                if (addContext) {
                    QDataSet qDataSet2 = DataSetOps.getContextForUnbundle(bundle, index);
                    DataSetUtil.addContext(this, qDataSet2);
                    this.putProperty("NAME", bundle.property("NAME", index));
                }
            } else if (dep2 != null) {
                switch (dep2.rank()) {
                    case 1: {
                        DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep2, index, false));
                        break;
                    }
                    case 2: {
                        DataSetUtil.addContext(this, (QDataSet)new Slice1DataSet(dep2, index, false));
                        break;
                    }
                    default: {
                        System.err.println("slice on non-qube, dep3 has rank=" + dep2.rank());
                        break;
                    }
                }
            } else {
                DRank0DataSet dRank0DataSet = DataSetUtil.asDataSet(index);
                dRank0DataSet.putProperty("NAME", "slice2");
                DataSetUtil.addContext(this, (QDataSet)dRank0DataSet);
            }
        }
        this.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        this.putProperty("DEPEND_1", ds.property("DEPEND_1"));
        this.putProperty("DEPEND_2", ds.property("DEPEND_3"));
        this.putProperty("BUNDLE_0", ds.property("BUNDLE_0"));
        this.putProperty("BUNDLE_1", ds.property("BUNDLE_1"));
        this.putProperty("BINS_0", ds.property("BINS_0"));
        this.putProperty("BINS_1", ds.property("BINS_1"));
        for (int i = 0; i < 50 && (qDataSet = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (qDataSet.rank() < 3) {
                this.putProperty(prop, qDataSet);
                continue;
            }
            this.putProperty(prop, new Slice2DataSet(qDataSet, index));
        }
        for (String prop2 : props = DataSetUtil.correlativeProperties()) {
            QDataSet s = (QDataSet)ds.property(prop2);
            if (s == null) continue;
            if (s.rank() < 3) {
                this.putProperty(prop2, s);
                continue;
            }
            this.putProperty(prop2, new Slice2DataSet(s, index, addContext));
        }
        this.putProperty("WEIGHTS", null);
        DataSetUtil.copyDimensionProperties(ds, this);
        DataSetUtil.maybeCopyRenderType(ds, this);
    }

    @Override
    public int rank() {
        return this.ds.rank() - 1;
    }

    @Override
    public double value(int i0, int i1) {
        return this.ds.value(i0, i1, this.index);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, i1, this.index, i2);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    @Override
    public int length() {
        return this.ds.length();
    }

    @Override
    public int length(int i) {
        return this.ds.length(i);
    }

    @Override
    public int length(int i0, int i1) {
        return this.ds.length(i0, i1, this.index);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice2DataSet) {
            Slice2DataSet that = (Slice2DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

