/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.Slice1DataSet;

public final class Slice3DataSet
extends AbstractDataSet {
    QDataSet ds;
    int index;

    public Slice3DataSet(QDataSet ds, int index) {
        this(ds, index, true);
    }

    Slice3DataSet(QDataSet ds, int index, boolean addContext) {
        String[] props;
        String prop;
        QDataSet plane0;
        int[] qube;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        if (ds.rank() < 4) {
            throw new IllegalArgumentException("rank limit < 4");
        }
        this.ds = ds;
        this.index = index;
        if (ds.length() == 0 ? (qube = DataSetUtil.qubeDims(ds)) != null && index >= qube[3] : index >= ds.length(0, 0, 0)) {
            throw new IndexOutOfBoundsException("slice3 index is out of bounds");
        }
        if (addContext) {
            QDataSet context;
            QDataSet bundle = (QDataSet)ds.property("BUNDLE_3");
            QDataSet dep3 = (QDataSet)ds.property("DEPEND_3");
            if (bundle != null && dep3 == null) {
                context = null;
                if (addContext) {
                    context = DataSetOps.getContextForUnbundle(bundle, index);
                    DataSetUtil.addContext(this, context);
                    this.putProperty("NAME", bundle.property("NAME", index));
                }
            } else if (dep3 != null) {
                if (dep3.rank() == 1) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep3, index, false));
                } else if (dep3.rank() == 2) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice1DataSet(dep3, index, false));
                } else {
                    System.err.println("slice on non-qube, dep3 has rank=" + dep3.rank());
                }
            } else {
                context = DataSetUtil.asDataSet(index);
                context.putProperty("NAME", "slice3");
                DataSetUtil.addContext(this, context);
            }
        }
        this.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        this.putProperty("DEPEND_1", ds.property("DEPEND_1"));
        this.putProperty("DEPEND_2", ds.property("DEPEND_2"));
        this.putProperty("DEPEND_3", null);
        this.putProperty("BUNDLE_0", ds.property("BUNDLE_0"));
        this.putProperty("BUNDLE_1", ds.property("BUNDLE_1"));
        this.putProperty("BUNDLE_2", ds.property("BUNDLE_2"));
        this.putProperty("BINS_0", ds.property("BINS_0"));
        this.putProperty("BINS_1", ds.property("BINS_1"));
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 4) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new Slice3DataSet(plane0, index));
        }
        for (String prop2 : props = DataSetUtil.correlativeProperties()) {
            QDataSet s = (QDataSet)ds.property(prop2);
            if (s == null) continue;
            if (s.rank() < 4) {
                this.putProperty(prop2, s);
                continue;
            }
            this.putProperty(prop2, new Slice3DataSet(s, index, addContext));
        }
        this.putProperty("WEIGHTS", null);
        DataSetUtil.copyDimensionProperties(ds, this);
        DataSetUtil.maybeCopyRenderType(ds, this);
    }

    @Override
    public int rank() {
        return this.ds.rank() - 1;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, i1, i2, this.index);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    @Override
    public int length() {
        return this.ds.length();
    }

    @Override
    public int length(int i) {
        return this.ds.length(i);
    }

    @Override
    public int length(int i0, int i1) {
        return this.ds.length(i0, i1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice3DataSet) {
            Slice3DataSet that = (Slice3DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

