/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class CleanDataFilterEditorPanel
extends AbstractFilterEditorPanel {
    public static final String PROP_REGEX = "\\|cleanData\\(([-\\d]*)(\\,([\\d\\.]+))?\\)";
    public JCheckBox boxCarTextField;
    public JCheckBox jCheckBox1;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JTextField nsigmaTF;
    public JTextField sizeTF;
    private BindingGroup bindingGroup;

    public CleanDataFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jCheckBox1 = new JCheckBox();
        this.sizeTF = new JTextField();
        this.boxCarTextField = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.nsigmaTF = new JTextField();
        this.jCheckBox1.setText("jCheckBox1");
        this.sizeTF.setText("3");
        this.sizeTF.setPreferredSize(new Dimension(50, 27));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.boxCarTextField, (Property)ELProperty.create((String)"${selected}"), (Object)this.sizeTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.boxCarTextField.setText("Use sliding boxcar of length:");
        this.jLabel2.setText("Clean data by removing points which are N stddevs away from the mean");
        this.jLabel1.setText("Number of stddevs:");
        this.nsigmaTF.setText("3.0");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.boxCarTextField).addPreferredGap(0).add((Component)this.sizeTF, -2, -1, -2).add(30, 30, 30).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.nsigmaTF, -2, 49, -2)).add((Component)this.jLabel2)).addContainerGap(54, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.nsigmaTF, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.sizeTF, -2, -1, -2).add((Component)this.boxCarTextField).add((Component)this.jLabel1))).addContainerGap()));
        layout.linkSize(new Component[]{this.nsigmaTF, this.sizeTF}, 2);
        this.bindingGroup.bind();
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile(PROP_REGEX);
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            String size = m.group(1);
            if (size.trim().length() > 0) {
                this.sizeTF.setText(m.group(1));
                this.boxCarTextField.setSelected(true);
            } else {
                this.sizeTF.setText("-1");
                this.boxCarTextField.setSelected(false);
            }
            if (m.group(3) != null) {
                String nsigma = m.group(3).trim();
                if (nsigma.length() == 0) {
                    this.nsigmaTF.setText("3.");
                } else {
                    this.nsigmaTF.setText(nsigma);
                }
            } else {
                this.nsigmaTF.setText("3.");
            }
        }
    }

    @Override
    public String getFilter() {
        double nsigma = 3.0;
        try {
            nsigma = Double.parseDouble(this.nsigmaTF.getText());
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, "unable to parse as double: {0}", this.nsigmaTF.getText());
        }
        if (this.boxCarTextField.isSelected()) {
            if (nsigma == 3.0) {
                return "|cleanData(" + this.sizeTF.getText() + ")";
            }
            return "|cleanData(" + this.sizeTF.getText() + "," + this.nsigmaTF.getText() + ")";
        }
        if (nsigma == 3.0) {
            return "|cleanData()";
        }
        return "|cleanData(-1," + this.nsigmaTF.getText() + ")";
    }
}

