/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.ops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.das2.datum.LoggerManager;
import org.das2.datum.UnitsConverter;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.CoerceUtil;
import org.das2.qds.ops.Ops;

public class OpsParl {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.ops");
    private static final String CLASSNAME = OpsParl.class.getCanonicalName();
    private static final String[] _dependProperties = new String[]{"DEPEND_0", "DEPEND_1", "DEPEND_2", "DEPEND_3", "BINS_0", "BINS_1"};

    private OpsParl() {
    }

    public static MutablePropertyDataSet applyBinaryOp(QDataSet ds1, QDataSet ds2, BinaryOp op) {
        String[] ss;
        boolean resultIsQube;
        if (ds1.rank() == ds2.rank() && ds1.rank() > 0 && ds1.length() != ds2.length()) {
            throw new IllegalArgumentException("binary operation on datasets of different lengths: " + ds1 + " " + ds2);
        }
        QDataSet[] operands = new QDataSet[2];
        WritableDataSet result = CoerceUtil.coerce(ds1, ds2, true, operands);
        QubeDataSetIterator it1 = new QubeDataSetIterator(operands[0]);
        QubeDataSetIterator it2 = new QubeDataSetIterator(operands[1]);
        QDataSet w1 = DataSetUtil.weightsDataSet(operands[0]);
        QDataSet w2 = DataSetUtil.weightsDataSet(operands[1]);
        double fill = -1.0E38;
        while (it1.hasNext()) {
            it1.next();
            it2.next();
            double d1 = it1.getValue(operands[0]);
            double d2 = it2.getValue(operands[1]);
            double w = it1.getValue(w1) * it2.getValue(w2);
            it1.putValue(result, w == 0.0 ? fill : op.op(d1, d2));
        }
        Map<String, Object> m1 = DataSetUtil.getProperties(operands[0], _dependProperties, null);
        Map<String, Object> m2 = DataSetUtil.getProperties(operands[1], _dependProperties, null);
        boolean bl = resultIsQube = Boolean.TRUE.equals(m1.get("QUBE")) || Boolean.TRUE.equals(m2.get("QUBE"));
        if (m1.size() == 1) {
            m1.remove("QUBE");
        }
        if (m2.size() == 1) {
            m2.remove("QUBE");
        }
        if (m2.isEmpty() && !m1.isEmpty() || ds2.rank() == 0) {
            m2.put("DEPEND_0", m1.get("DEPEND_0"));
            m2.put("DEPEND_1", m1.get("DEPEND_1"));
            m2.put("DEPEND_2", m1.get("DEPEND_2"));
            m2.put("DEPEND_3", m1.get("DEPEND_3"));
            m2.put("CONTEXT_0", m1.get("CONTEXT_0"));
            m2.put("BINS_0", m1.get("BINS_0"));
            m2.put("BINS_1", m1.get("BINS_1"));
        }
        if (m1.isEmpty() && !m2.isEmpty() || ds1.rank() == 0) {
            m1.put("DEPEND_0", m2.get("DEPEND_0"));
            m1.put("DEPEND_1", m2.get("DEPEND_1"));
            m1.put("DEPEND_2", m2.get("DEPEND_2"));
            m1.put("DEPEND_3", m2.get("DEPEND_3"));
            m1.put("CONTEXT_0", m2.get("CONTEXT_0"));
            m1.put("BINS_0", m2.get("BINS_0"));
            m1.put("BINS_1", m2.get("BINS_1"));
        }
        HashMap<String, Object> m3 = Ops.equalProperties(m1, m2);
        if (resultIsQube) {
            m3.put("QUBE", Boolean.TRUE);
        }
        for (String s : ss = DataSetUtil.dimensionProperties()) {
            m3.remove(s);
        }
        m3.remove("BUNDLE_1");
        DataSetUtil.putProperties(m3, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet eq(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return OpsParl.applyBinaryOp(ds1, ds2, new BinaryOp(){

            @Override
            public double op(double d1, double d2) {
                return uc.convert(d1) == d2 ? 1.0 : 0.0;
            }
        });
    }

    public static MutablePropertyDataSet applyBinaryOpNoIter(QDataSet ds1, QDataSet ds2, BinaryOp op) {
        String[] ss;
        boolean resultIsQube;
        if (ds1.rank() == ds2.rank() && ds1.rank() > 0 && ds1.length() != ds2.length()) {
            throw new IllegalArgumentException("binary operation on datasets of different lengths: " + ds1 + " " + ds2);
        }
        QDataSet[] operands = new QDataSet[2];
        WritableDataSet result = CoerceUtil.coerce(ds1, ds2, true, operands);
        QDataSet w1 = DataSetUtil.weightsDataSet(operands[0]);
        QDataSet w2 = DataSetUtil.weightsDataSet(operands[1]);
        double fill = -1.0E38;
        if (w1.rank() == 1) {
            int n = w1.length();
            QDataSet op1 = operands[0];
            QDataSet op2 = operands[1];
            for (int i = 0; i < n; ++i) {
                double d1 = op1.value(i);
                double d2 = op2.value(i);
                double w = w1.value(i) * w2.value(i);
                result.putValue(i, w == 0.0 ? fill : op.op(d1, d2));
            }
        } else {
            QubeDataSetIterator it1 = new QubeDataSetIterator(operands[0]);
            QubeDataSetIterator it2 = new QubeDataSetIterator(operands[1]);
            while (it1.hasNext()) {
                it1.next();
                it2.next();
                double d1 = it1.getValue(operands[0]);
                double d2 = it2.getValue(operands[1]);
                double w = it1.getValue(w1) * it2.getValue(w2);
                it1.putValue(result, w == 0.0 ? fill : op.op(d1, d2));
            }
        }
        Map<String, Object> m1 = DataSetUtil.getProperties(operands[0], _dependProperties, null);
        Map<String, Object> m2 = DataSetUtil.getProperties(operands[1], _dependProperties, null);
        boolean bl = resultIsQube = Boolean.TRUE.equals(m1.get("QUBE")) || Boolean.TRUE.equals(m2.get("QUBE"));
        if (m1.size() == 1) {
            m1.remove("QUBE");
        }
        if (m2.size() == 1) {
            m2.remove("QUBE");
        }
        if (m2.isEmpty() && !m1.isEmpty() || ds2.rank() == 0) {
            m2.put("DEPEND_0", m1.get("DEPEND_0"));
            m2.put("DEPEND_1", m1.get("DEPEND_1"));
            m2.put("DEPEND_2", m1.get("DEPEND_2"));
            m2.put("DEPEND_3", m1.get("DEPEND_3"));
            m2.put("CONTEXT_0", m1.get("CONTEXT_0"));
            m2.put("BINS_0", m1.get("BINS_0"));
            m2.put("BINS_1", m1.get("BINS_1"));
        }
        if (m1.isEmpty() && !m2.isEmpty() || ds1.rank() == 0) {
            m1.put("DEPEND_0", m2.get("DEPEND_0"));
            m1.put("DEPEND_1", m2.get("DEPEND_1"));
            m1.put("DEPEND_2", m2.get("DEPEND_2"));
            m1.put("DEPEND_3", m2.get("DEPEND_3"));
            m1.put("CONTEXT_0", m2.get("CONTEXT_0"));
            m1.put("BINS_0", m2.get("BINS_0"));
            m1.put("BINS_1", m2.get("BINS_1"));
        }
        HashMap<String, Object> m3 = Ops.equalProperties(m1, m2);
        if (resultIsQube) {
            m3.put("QUBE", Boolean.TRUE);
        }
        for (String s : ss = DataSetUtil.dimensionProperties()) {
            m3.remove(s);
        }
        m3.remove("BUNDLE_1");
        DataSetUtil.putProperties(m3, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet eq_noiter(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return OpsParl.applyBinaryOpNoIter(ds1, ds2, new BinaryOp(){

            @Override
            public double op(double d1, double d2) {
                return uc.convert(d1) == d2 ? 1.0 : 0.0;
            }
        });
    }

    public static MutablePropertyDataSet applyBinaryOpParl(QDataSet ds1, QDataSet ds2, final BinaryOp op) {
        String[] ss;
        boolean resultIsQube;
        if (ds1.rank() == ds2.rank() && ds1.rank() > 0 && ds1.length() != ds2.length()) {
            throw new IllegalArgumentException("binary operation on datasets of different lengths: " + ds1 + " " + ds2);
        }
        QDataSet[] operands = new QDataSet[2];
        final WritableDataSet result = CoerceUtil.coerce(ds1, ds2, true, operands);
        final QDataSet w1 = DataSetUtil.weightsDataSet(operands[0]);
        final QDataSet w2 = DataSetUtil.weightsDataSet(operands[1]);
        double fill = -1.0E38;
        if (w1.rank() == 1) {
            boolean allDone;
            List futures;
            int nthread = 4;
            final int n = w1.length();
            final QDataSet op1 = operands[0];
            final QDataSet op2 = operands[1];
            ArrayList<3> callables = new ArrayList<3>(4);
            for (int i = 0; i < 4; ++i) {
                final int istart = i;
                Callable<Object> r = new Callable<Object>(){

                    @Override
                    public Object call() {
                        for (int i = istart; i < n; i += 4) {
                            double d1 = op1.value(i);
                            double d2 = op2.value(i);
                            double w = w1.value(i) * w2.value(i);
                            result.putValue(i, w == 0.0 ? -1.0E38 : op.op(d1, d2));
                        }
                        return null;
                    }
                };
                callables.add(i, r);
            }
            ExecutorService executor = Executors.newCachedThreadPool();
            ArrayList<3> tasks = callables;
            try {
                futures = executor.invokeAll(tasks);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            block3: do {
                allDone = true;
                for (Future f : futures) {
                    if (f.isDone()) continue;
                    allDone = false;
                    continue block3;
                }
            } while (!allDone);
        } else {
            QubeDataSetIterator it1 = new QubeDataSetIterator(operands[0]);
            QubeDataSetIterator it2 = new QubeDataSetIterator(operands[1]);
            while (it1.hasNext()) {
                it1.next();
                it2.next();
                double d1 = it1.getValue(operands[0]);
                double d2 = it2.getValue(operands[1]);
                double w = it1.getValue(w1) * it2.getValue(w2);
                it1.putValue(result, w == 0.0 ? -1.0E38 : op.op(d1, d2));
            }
        }
        Map<String, Object> m1 = DataSetUtil.getProperties(operands[0], _dependProperties, null);
        Map<String, Object> m2 = DataSetUtil.getProperties(operands[1], _dependProperties, null);
        boolean bl = resultIsQube = Boolean.TRUE.equals(m1.get("QUBE")) || Boolean.TRUE.equals(m2.get("QUBE"));
        if (m1.size() == 1) {
            m1.remove("QUBE");
        }
        if (m2.size() == 1) {
            m2.remove("QUBE");
        }
        if (m2.isEmpty() && !m1.isEmpty() || ds2.rank() == 0) {
            m2.put("DEPEND_0", m1.get("DEPEND_0"));
            m2.put("DEPEND_1", m1.get("DEPEND_1"));
            m2.put("DEPEND_2", m1.get("DEPEND_2"));
            m2.put("DEPEND_3", m1.get("DEPEND_3"));
            m2.put("CONTEXT_0", m1.get("CONTEXT_0"));
            m2.put("BINS_0", m1.get("BINS_0"));
            m2.put("BINS_1", m1.get("BINS_1"));
        }
        if (m1.isEmpty() && !m2.isEmpty() || ds1.rank() == 0) {
            m1.put("DEPEND_0", m2.get("DEPEND_0"));
            m1.put("DEPEND_1", m2.get("DEPEND_1"));
            m1.put("DEPEND_2", m2.get("DEPEND_2"));
            m1.put("DEPEND_3", m2.get("DEPEND_3"));
            m1.put("CONTEXT_0", m2.get("CONTEXT_0"));
            m1.put("BINS_0", m2.get("BINS_0"));
            m1.put("BINS_1", m2.get("BINS_1"));
        }
        HashMap<String, Object> m3 = Ops.equalProperties(m1, m2);
        if (resultIsQube) {
            m3.put("QUBE", Boolean.TRUE);
        }
        for (String s : ss = DataSetUtil.dimensionProperties()) {
            m3.remove(s);
        }
        m3.remove("BUNDLE_1");
        DataSetUtil.putProperties(m3, result);
        result.putProperty("FILL_VALUE", -1.0E38);
        return result;
    }

    public static QDataSet eq_parl(QDataSet ds1, QDataSet ds2) {
        final UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return OpsParl.applyBinaryOpParl(ds1, ds2, new BinaryOp(){

            @Override
            public double op(double d1, double d2) {
                return uc.convert(d1) == d2 ? 1.0 : 0.0;
            }
        });
    }

    public static interface BinaryOp {
        public double op(double var1, double var3);
    }
}

