/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamComment;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamScalarDescriptor;
import org.das2.stream.StreamYDescriptor;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.stream.StreamZDescriptor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class QDataSetStreamHandler
implements StreamHandler {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.dataTransfer");
    private Map<Integer, DataSetBuilder> xbuilders;
    private Map<Integer, DataSetBuilder[]> builders;
    private QDataSet jds = null;
    private Map<Integer, String> schemes;
    private PacketDescriptor currentPd = null;
    private DataSetBuilder[] currentBuilders;
    private DataSetBuilder currentXBuilder;
    private String streamTitle;
    private Map streamProperties;
    private QDataSet ds = null;
    private final Object collectionMode = MODE_SPLIT_BY_NEW_PACKET_DESCRIPTOR;
    private ProgressMonitor monitor = new NullProgressMonitor();
    private static final String SCHEME_XYZSCATTER = "xyzScatter";
    private static final String SCHEME_PEAKS_AND_AVERAGES = "peaksAndAverages";
    private final Pattern ptrn = Pattern.compile("(%\\{)(.+?)(\\})");
    public static final Object MODE_SPLIT_BY_PACKET_DESCRIPTOR = "splitByPacketDescriptor";
    public static final Object MODE_SPLIT_BY_NEW_PACKET_DESCRIPTOR = "splitByNewPacketDescriptor";

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        logger.log(Level.FINE, "streamDescriptor: {0}", sd);
        this.xbuilders = new LinkedHashMap<Integer, DataSetBuilder>();
        this.builders = new LinkedHashMap<Integer, DataSetBuilder[]>();
        this.schemes = new LinkedHashMap<Integer, String>();
        String t = (String)sd.getProperty("title");
        this.streamTitle = t != null ? this.adaptUserProperty(t) : null;
        this.streamProperties = sd.getProperties();
        Object o = sd.getProperty("taskSize");
        if (o != null) {
            this.monitor.setTaskSize((long)((Integer)o).intValue());
            this.monitor.started();
        } else {
            o = sd.getProperty("packetCount");
            if (o != null) {
                this.monitor.setTaskSize((long)((Integer)o).intValue());
                this.monitor.started();
            }
        }
    }

    private void putProperty(DataSetBuilder builder, String name, Object value) {
        if (value instanceof Datum) {
            logger.warning("kludge to fix Datum property values");
            value = ((Datum)value).doubleValue(((Datum)value).getUnits());
        }
        if (SemanticOps.checkPropertyType((String)name, (Object)value, (boolean)false)) {
            builder.putProperty(name, value);
        } else {
            logger.log(Level.WARNING, "property \"{0}\" should be type \"{1}\"", new Object[]{name, SemanticOps.getPropertyType((String)name)});
        }
    }

    private String adaptUserProperty(String s) {
        Matcher m = this.ptrn.matcher(s);
        while (m.find()) {
            if (m.group(2).contains("USER_PROPERTIES")) continue;
            s = String.format("%sUSER_PROPERTIES.%s%s", s.substring(0, m.end(1)), s.substring(m.start(2), m.end(2)), s.substring(m.start(3), s.length()));
            m = this.ptrn.matcher(s);
        }
        return s;
    }

    private Object findProperty(StreamYScanDescriptor sd, String d2sName) {
        Object o = sd.getProperty(d2sName);
        if (o == null) {
            String n = sd.getName();
            o = this.streamProperties.get(n + "." + d2sName);
        }
        if (o == null) {
            o = this.streamProperties.get(d2sName);
        }
        if (o instanceof String) {
            o = this.adaptUserProperty((String)o);
        }
        return o;
    }

    private Object findProperty(StreamScalarDescriptor sd, String d2sName) {
        Object o = sd.getProperty(d2sName);
        if (o == null) {
            String n = sd.getName();
            o = this.streamProperties.get(n + "." + d2sName);
        }
        if (o == null) {
            o = this.streamProperties.get(d2sName);
        }
        return o;
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        logger.log(Level.FINE, "packetDescriptor: {0}", pd);
        this.createBuilders(pd);
    }

    @Override
    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        if (pd != this.currentPd) {
            if (this.currentPd != null && this.collectionMode == MODE_SPLIT_BY_PACKET_DESCRIPTOR) {
                this.collectDataSet();
                this.createBuilders(this.currentPd);
            }
            logger.log(Level.FINE, "packet type changed: {0}", pd.getYDescriptor(0).getSizeBytes());
            this.currentXBuilder = this.xbuilders.get(pd.getId());
            this.currentBuilders = this.builders.get(pd.getId());
            this.currentPd = pd;
        }
        this.currentXBuilder.nextRecord(xTag);
        for (int i = 0; i < pd.getYCount(); ++i) {
            if (this.currentBuilders[i].rank() == 1) {
                this.currentBuilders[i].nextRecord(vectors[i].get(0));
                continue;
            }
            this.currentBuilders[i].nextRecord(vectors[i]);
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        logger.finest("got streamClosed");
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        logger.finest("got streamException");
    }

    @Override
    public void streamComment(StreamComment sc) throws StreamException {
        logger.log(Level.FINEST, "got stream comment: {0}", sc);
        if (sc.getType().equals("taskSize")) {
            if (!this.monitor.isCancelled()) {
                this.monitor.setTaskSize((long)Integer.parseInt(sc.getValue()));
                this.monitor.started();
            }
            return;
        }
        if (sc.getType().equals("taskProgress")) {
            if (this.monitor.getTaskSize() != -1L && !this.monitor.isCancelled()) {
                this.monitor.setTaskProgress(Long.parseLong(sc.getValue()));
            }
            return;
        }
        if (sc.getType().matches("log:(.*)")) {
            String level = sc.getType().substring(4);
            Level l = Level.parse(level.toUpperCase());
            if (l.intValue() > Level.FINE.intValue()) {
                logger.log(Level.FINE, sc.getValue());
            } else {
                logger.log(l, sc.getValue());
            }
            this.monitor.setProgressMessage(sc.getValue());
        }
    }

    public void createBuilders(PacketDescriptor pd) {
        DataSetBuilder[] lbuilders = new DataSetBuilder[pd.getYCount()];
        for (int i = 0; i < pd.getYCount(); ++i) {
            StreamScalarDescriptor multiy;
            DatumRange zRange;
            DataSetBuilder builder;
            SkeletonDescriptor sd = pd.getYDescriptor(i);
            logger.log(Level.FINER, "got packet: {0}", sd);
            if (sd instanceof StreamYScanDescriptor) {
                StreamYScanDescriptor yscan = (StreamYScanDescriptor)sd;
                builder = new DataSetBuilder(2, 1000, yscan.getNItems());
                this.putProperty(builder, "UNITS", yscan.getZUnits());
                this.putProperty(builder, "NAME", yscan.getName());
                this.putProperty(builder, "LABEL", this.findProperty(yscan, "zLabel"));
                this.putProperty(builder, "TITLE", this.findProperty(yscan, "zSummary"));
                this.putProperty(builder, "VALID_MIN", this.findProperty(yscan, "zValidMin"));
                this.putProperty(builder, "VALID_MAX", this.findProperty(yscan, "zValidMax"));
                zRange = (DatumRange)this.findProperty(yscan, "zRange");
                if (zRange != null) {
                    this.putProperty(builder, "TYPICAL_MIN", zRange.min().doubleValue(zRange.getUnits()));
                    this.putProperty(builder, "TYPICAL_MAX", zRange.max().doubleValue(zRange.getUnits()));
                }
                this.putProperty(builder, "FILL_VALUE", this.findProperty(yscan, "zFill"));
                this.putProperty(builder, "SCALE_TYPE", this.findProperty(yscan, "zScaleType"));
                DDataSet ytags = DDataSet.wrap((double[])yscan.getYTags());
                ytags.putProperty("UNITS", (Object)yscan.getYUnits());
                ytags.putProperty("SCALE_TYPE", this.findProperty(yscan, "yScaleType"));
                DatumRange yRange = (DatumRange)this.findProperty(yscan, "yRange");
                if (yRange != null) {
                    ytags.putProperty("TYPICAL_MIN", (Object)yRange.min().doubleValue(yRange.getUnits()));
                    ytags.putProperty("TYPICAL_MAX", (Object)yRange.max().doubleValue(yRange.getUnits()));
                }
                ytags.putProperty("LABEL", this.findProperty(yscan, "yLabel"));
                ytags.putProperty("TITLE", this.findProperty(yscan, "ySummary"));
                Object o = this.findProperty(yscan, "yTagWidth");
                if (o != null) {
                    if (o instanceof Datum) {
                        o = DataSetUtil.asDataSet((Datum)((Datum)o));
                        ytags.putProperty("CADENCE", o);
                    } else {
                        logger.warning("property yTagWidth should be a Datum");
                    }
                }
                this.putProperty(builder, "DEPEND_1", ytags);
                String checkOperation = (String)yscan.getProperty("operation");
                String checkSource = (String)yscan.getProperty("source");
                if (checkSource != null && !yscan.getName().equals(checkSource)) {
                    if (checkOperation.equals("BIN_MAX")) {
                        this.putProperty(builder, "NAME", checkSource + ".max");
                    } else if (checkOperation.equals("BIN_AVG")) {
                        this.putProperty(builder, "NAME", checkSource + ".avg");
                    } else if (checkOperation.equals("BIN_MIN")) {
                        this.putProperty(builder, "NAME", checkSource + ".min");
                    }
                }
            } else if (sd instanceof StreamYDescriptor) {
                multiy = (StreamScalarDescriptor)sd;
                builder = new DataSetBuilder(1, 1000);
                this.putProperty(builder, "UNITS", multiy.getUnits());
                this.putProperty(builder, "NAME", multiy.getName());
                this.putProperty(builder, "LABEL", this.findProperty(multiy, "yLabel"));
                this.putProperty(builder, "FORMAT", this.findProperty(multiy, "yFormat"));
                this.putProperty(builder, "TITLE", this.findProperty(multiy, "ySummary"));
                this.putProperty(builder, "VALID_MIN", this.findProperty(multiy, "yValidMin"));
                this.putProperty(builder, "VALID_MAX", this.findProperty(multiy, "yValidMax"));
                DatumRange yRange = (DatumRange)this.findProperty(multiy, "yRange");
                if (yRange != null) {
                    this.putProperty(builder, "TYPICAL_MIN", yRange.min().doubleValue(yRange.getUnits()));
                    this.putProperty(builder, "TYPICAL_MAX", yRange.max().doubleValue(yRange.getUnits()));
                }
                this.putProperty(builder, "SCALE_TYPE", this.findProperty(multiy, "yScaleType"));
                this.putProperty(builder, "FILL_VALUE", this.findProperty(multiy, "yFill"));
            } else if (sd instanceof StreamZDescriptor) {
                multiy = (StreamScalarDescriptor)sd;
                builder = new DataSetBuilder(1, 1000);
                this.putProperty(builder, "UNITS", multiy.getUnits());
                this.putProperty(builder, "NAME", multiy.getName());
                this.putProperty(builder, "LABEL", this.findProperty(multiy, "zLabel"));
                this.putProperty(builder, "FORMAT", this.findProperty(multiy, "zFormat"));
                this.putProperty(builder, "TITLE", this.findProperty(multiy, "zSummary"));
                this.putProperty(builder, "VALID_MIN", this.findProperty(multiy, "zValidMin"));
                this.putProperty(builder, "VALID_MAX", this.findProperty(multiy, "zValidMax"));
                zRange = (DatumRange)this.findProperty(multiy, "zRange");
                if (zRange != null) {
                    this.putProperty(builder, "TYPICAL_MIN", zRange.min().doubleValue(zRange.getUnits()));
                    this.putProperty(builder, "TYPICAL_MAX", zRange.max().doubleValue(zRange.getUnits()));
                }
                this.putProperty(builder, "SCALE_TYPE", this.findProperty(multiy, "zScaleType"));
                this.putProperty(builder, "FILL_VALUE", this.findProperty(multiy, "zFill"));
            } else {
                throw new IllegalArgumentException("not supported: " + sd);
            }
            lbuilders[i] = builder;
        }
        if (pd.getYCount() == 2 && pd.getYDescriptor(0) instanceof StreamYDescriptor && pd.getYDescriptor(1) instanceof StreamZDescriptor) {
            this.schemes.put(pd.getId(), SCHEME_XYZSCATTER);
        } else {
            this.schemes.put(pd.getId(), "");
        }
        DataSetBuilder xbuilder = new DataSetBuilder(1, 1000);
        xbuilder.putProperty("UNITS", (Object)pd.getXDescriptor().getUnits());
        Object o = pd.getProperty("xLabel");
        if (o == null) {
            o = this.streamProperties.get("xLabel");
        }
        xbuilder.putProperty("LABEL", o);
        o = pd.getProperty("xTagWidth");
        if (o == null) {
            o = this.streamProperties.get("xTagWidth");
        }
        if (o != null) {
            if (o instanceof Datum) {
                xbuilder.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)((Datum)o)));
            } else {
                logger.warning("property xTagWidth should be a Datum");
            }
        }
        if ((o = pd.getProperty("monotonicXTags")) == null) {
            o = this.streamProperties.get("monotonicXTags");
        }
        if ("true".equals(o)) {
            xbuilder.putProperty("MONOTONIC", (Object)Boolean.TRUE);
        }
        DataSetBuilder retirex = this.xbuilders.put(pd.getId(), xbuilder);
        DataSetBuilder[] retireb = this.builders.put(pd.getId(), lbuilders);
        if (retirex != null) {
            this.jds = Ops.join((QDataSet)this.jds, (QDataSet)QDataSetStreamHandler.collectDataSet(retirex, retireb));
        }
    }

    private static QDataSet collectDataSet(DataSetBuilder currentXBuilder, DataSetBuilder[] currentBuilders) {
        DDataSet ds1;
        DDataSet xds1 = currentXBuilder.getDataSet();
        if (currentBuilders.length == 1) {
            ds1 = currentBuilders[0].getDataSet();
        } else {
            ds1 = null;
            for (DataSetBuilder currentBuilder : currentBuilders) {
                DDataSet ds = currentBuilder.getDataSet();
                ds1 = Ops.bundle((QDataSet)ds1, (QDataSet)ds);
            }
            if (currentBuilders.length == 2) {
                String prefix = (String)Ops.unbundle((QDataSet)ds1, (int)0).property("NAME");
                String name1 = (String)Ops.unbundle((QDataSet)ds1, (int)1).property("NAME");
                if (name1.equals(prefix + ".max") || prefix.equals("") && name1.equals("peaks")) {
                    QDataSet max = Ops.unbundle((QDataSet)ds1, (int)1);
                    max = Ops.putProperty((QDataSet)max, (String)"NAME", (Object)name1.replaceAll("\\.", "_"));
                    max = Ops.putProperty((QDataSet)max, (String)"BUNDLE_1", null);
                    max = Ops.link((QDataSet)xds1, (QDataSet)max);
                    ds1 = Ops.unbundle((QDataSet)ds1, (int)0);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BIN_MAX", (Object)max);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BUNDLE_1", null);
                } else if (name1.equals(prefix + ".min")) {
                    QDataSet min = Ops.unbundle((QDataSet)ds1, (int)1);
                    min = Ops.putProperty((QDataSet)min, (String)"NAME", (Object)name1.replaceAll("\\.", "_"));
                    min = Ops.putProperty((QDataSet)min, (String)"BUNDLE_1", null);
                    min = Ops.link((QDataSet)xds1, (QDataSet)min);
                    ds1 = Ops.unbundle((QDataSet)ds1, (int)0);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BIN_MIN", (Object)min);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BUNDLE_1", null);
                }
            }
        }
        if (ds1 instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)ds1).isImmutable()) {
            ((MutablePropertyDataSet)ds1).putProperty("DEPEND_0", (Object)xds1);
        } else {
            ds1 = Ops.link((QDataSet)xds1, (QDataSet)ds1);
        }
        return ds1;
    }

    public void collectDataSet() {
        DDataSet ds1;
        DDataSet xds1 = this.currentXBuilder.getDataSet();
        if (this.currentBuilders.length == 1) {
            ds1 = this.currentBuilders[0].getDataSet();
        } else {
            ds1 = null;
            for (DataSetBuilder currentBuilder : this.currentBuilders) {
                ds1 = Ops.bundle((QDataSet)ds1, (QDataSet)currentBuilder.getDataSet());
            }
            if (this.currentBuilders.length == 2) {
                String name0 = (String)Ops.unbundle((QDataSet)ds1, (int)0).property("NAME");
                String name1 = (String)Ops.unbundle((QDataSet)ds1, (int)1).property("NAME");
                int ip = name0.lastIndexOf(46);
                String prefix = ip > -1 ? name0.substring(0, ip) : name0;
                if (ds1.rank() == 3 && (name0.equals(prefix + ".avg") && name1.equals(prefix + ".max") || name0.equals(prefix) && name1.equals(prefix + ".max") || prefix.equals("") && name1.equals("peaks"))) {
                    QDataSet max = Ops.unbundle((QDataSet)ds1, (int)1);
                    max = Ops.putProperty((QDataSet)max, (String)"NAME", (Object)name1.replaceAll("\\.", "_"));
                    max = Ops.putProperty((QDataSet)max, (String)"BUNDLE_1", null);
                    max = Ops.link((QDataSet)xds1, (QDataSet)max);
                    ds1 = Ops.unbundle((QDataSet)ds1, (int)0);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BIN_MAX", (Object)max);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BUNDLE_1", null);
                } else if (ds1.rank() == 3 && name1.equals(prefix + ".min")) {
                    QDataSet min = Ops.unbundle((QDataSet)ds1, (int)1);
                    min = Ops.putProperty((QDataSet)min, (String)"NAME", (Object)name1.replaceAll("\\.", "_"));
                    min = Ops.putProperty((QDataSet)min, (String)"BUNDLE_1", null);
                    min = Ops.link((QDataSet)xds1, (QDataSet)min);
                    ds1 = Ops.unbundle((QDataSet)ds1, (int)0);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BIN_MIN", (Object)min);
                    ds1 = Ops.putProperty((QDataSet)ds1, (String)"BUNDLE_1", null);
                }
            }
        }
        if (ds1 instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)ds1).isImmutable()) {
            ((MutablePropertyDataSet)ds1).putProperty("DEPEND_0", (Object)xds1);
        } else {
            ds1 = Ops.link((QDataSet)xds1, (QDataSet)ds1);
        }
        this.ds = this.ds == null ? ds1 : Ops.join((QDataSet)this.ds, (QDataSet)ds1);
    }

    public QDataSet getDataSet() {
        String scheme;
        String renderer;
        if (this.collectionMode == MODE_SPLIT_BY_PACKET_DESCRIPTOR) {
            if (this.currentXBuilder == null) {
                return null;
            }
            this.collectDataSet();
        } else {
            if (this.currentXBuilder == null) {
                return null;
            }
            int nbuilders = this.builders.size();
            if (nbuilders == 1) {
                this.collectDataSet();
                if (this.jds != null) {
                    this.ds = this.ds == null ? this.jds : (this.jds = (JoinDataSet)Ops.join((QDataSet)this.jds, (QDataSet)this.ds));
                }
            } else {
                for (Map.Entry<Integer, DataSetBuilder[]> e : this.builders.entrySet()) {
                    int id = e.getKey();
                    this.currentBuilders = e.getValue();
                    this.currentXBuilder = this.xbuilders.get(id);
                    QDataSet ds1 = QDataSetStreamHandler.collectDataSet(this.currentXBuilder, this.currentBuilders);
                    this.jds = (JoinDataSet)Ops.join((QDataSet)this.jds, (QDataSet)ds1);
                }
                this.ds = this.jds;
            }
        }
        if (this.ds == null) {
            return null;
        }
        if (this.ds instanceof JoinDataSet && this.ds.length() >= 2 && this.appendable(this.ds.slice(0), this.ds.slice(1))) {
            this.ds = this.jds.slice(0);
            for (int i = 1; i < this.jds.length(); ++i) {
                this.ds = Ops.append((QDataSet)this.ds, (QDataSet)this.jds.slice(i));
            }
        }
        if (SemanticOps.isBundle((QDataSet)this.ds)) {
            QDataSet bds = (QDataSet)this.ds.property("BUNDLE_1");
            String[] planes = new String[bds.length()];
            for (int i = 0; i < bds.length(); ++i) {
                planes[i] = (String)bds.property("NAME", i);
            }
            boolean yesDoIt = true;
            String sname = planes[0];
            MutablePropertyDataSet v0 = (MutablePropertyDataSet)Ops.unbundle((QDataSet)this.ds, (int)0);
            for (int i = 1; i < bds.length(); ++i) {
                QDataSet v = Ops.unbundle((QDataSet)this.ds, (int)i);
                if (planes[i].equals(sname + ".min")) {
                    v0.putProperty("BIN_MIN", (Object)v);
                    continue;
                }
                if (planes[i].equals(sname + ".max")) {
                    v0.putProperty("BIN_MAX", (Object)v);
                    continue;
                }
                if (planes[i].equals(sname + ".stddev")) {
                    v0.putProperty("DELTA_MINUS", (Object)v);
                    v0.putProperty("DELTA_PLUS", (Object)v);
                    continue;
                }
                yesDoIt = false;
            }
            if (yesDoIt && v0.property("BIN_MAX") != null && v0.property("BIN_MIN") != null || v0.property("DELTA_MINUS") != null) {
                this.ds = v0;
            }
        }
        this.ds = Ops.putProperty((QDataSet)this.ds, (String)"TITLE", (Object)this.streamTitle);
        Object oxCacheRange = this.streamProperties.get("xCacheRange");
        if (oxCacheRange != null) {
            Object oxCacheResolution = this.streamProperties.get("xCacheResolution");
            try {
                CacheTag ct = oxCacheResolution != null ? new CacheTag((DatumRange)oxCacheRange, (Datum)oxCacheResolution) : new CacheTag((DatumRange)oxCacheRange, null);
                this.ds = Ops.putProperty((QDataSet)this.ds, (String)"CACHE_TAG", (Object)ct);
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, "unable to use properties for cacheTag", ex);
            }
        }
        if ((renderer = (String)this.streamProperties.get("renderer")) != null) {
            this.ds = Ops.putProperty((QDataSet)this.ds, (String)"RENDER_TYPE", (Object)renderer);
        }
        if (this.schemes.size() == 1 && (scheme = this.schemes.get(this.schemes.keySet().iterator().next())).equals(SCHEME_XYZSCATTER) && this.ds instanceof BundleDataSet) {
            BundleDataSet bds = (BundleDataSet)this.ds;
            QDataSet z = bds.unbundle(bds.length(0) - 1);
            QDataSet y = bds.unbundle(bds.length(0) - 2);
            QDataSet x = Ops.xtags((QDataSet)bds);
            this.ds = Ops.link((QDataSet)x, (QDataSet)y, (QDataSet)z);
        }
        this.ds = Ops.putProperty((QDataSet)this.ds, (String)"USER_PROPERTIES", (Object)this.streamProperties);
        return this.ds;
    }

    private boolean appendable(QDataSet s0, QDataSet s1) {
        return s0.rank() == s1.rank() && (s0.rank() == 1 || SemanticOps.isBundle((QDataSet)s0) && SemanticOps.isBundle((QDataSet)s1) && s0.length(0) == s1.length(0));
    }
}

