/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.das2.components.propertyeditor.Enumeration;

public class EnumerationEditor
implements PropertyEditor,
TableCellEditor {
    private JComboBox editor;
    private Model model;
    private Object selected;
    private Class type;
    private PropertyChangeSupport pcSupport;
    private EventListenerList listeners = new EventListenerList();
    private Map valueMap;
    private Map nameMap;
    private Map toStringMap;
    private static final int PUBLIC_STATIC_FINAL = 25;
    private ChangeEvent evt;

    public EnumerationEditor() {
        this.pcSupport = new PropertyChangeSupport(this);
    }

    public EnumerationEditor(Class c) {
        this();
        this.setClass(c);
    }

    public EnumerationEditor(Object o) {
        this();
        this.setClass(o.getClass());
        this.setValue(o);
    }

    private void initEditor() {
        if (this.editor == null) {
            this.model = new Model();
            this.editor = new JComboBox(this.model){

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    Dimension preferred = this.getPreferredSize();
                    super.setBounds(x, y, width, preferred.height);
                }
            };
            this.editor.setRenderer(new Renderer());
            this.editor.setSelectedItem(this.selected);
        }
    }

    private void setClass(Class c) {
        this.type = c;
        HashMap<Object, String> valueM = new HashMap<Object, String>();
        IdentityHashMap<String, Object> nameM = new IdentityHashMap<String, Object>();
        HashMap<String, Object> toStringM = new HashMap<String, Object>();
        if (c.isEnum()) {
            T[] vals;
            for (Object o : vals = c.getEnumConstants()) {
                Enum e = (Enum)o;
                nameM.put(e.name(), e);
                toStringM.put(e.toString(), e);
                valueM.put(e, e.name());
            }
        } else {
            Field[] fields = this.type.getDeclaredFields();
            HashSet<Field> psf = new HashSet<Field>();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers = fields[i].getModifiers();
                if ((modifiers & 0x19) != 25) continue;
                psf.add(fields[i]);
            }
            Iterator i = psf.iterator();
            while (i.hasNext()) {
                try {
                    Field f = (Field)i.next();
                    String name = f.getName();
                    Object value = f.get(null);
                    nameM.put(name, value);
                    toStringM.put(value.toString(), value);
                    valueM.put(value, name);
                }
                catch (IllegalAccessException iae) {
                    IllegalAccessError err = new IllegalAccessError(iae.getMessage());
                    err.initCause(iae);
                    throw err;
                }
            }
        }
        this.nameMap = nameM;
        this.valueMap = valueM;
        this.toStringMap = toStringM;
    }

    public void removeItem(Object j) {
        Field[] fields;
        for (Field f : fields = this.type.getDeclaredFields()) {
            try {
                if (!f.get(this.selected).equals(j)) continue;
                this.nameMap.remove(f.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (this.editor != null) {
            this.model = new Model();
            this.editor.setModel(this.model);
        }
    }

    @Override
    public String getAsText() {
        return this.selected.toString();
    }

    @Override
    public Object getValue() {
        return this.selected;
    }

    @Override
    public void setAsText(String str) throws IllegalArgumentException {
        Object value = this.nameMap.get(str);
        if (value == null) {
            value = this.toStringMap.get(str);
        }
        if (value == null) {
            throw new IllegalArgumentException(str);
        }
        if (this.selected != value) {
            Object oldValue = this.selected;
            this.selected = value;
            if (this.editor != null) {
                this.editor.setSelectedItem(this.selected);
                this.editor.repaint();
            }
            this.pcSupport.firePropertyChange("value", oldValue, this.selected);
        }
    }

    @Override
    public void setValue(Object obj) {
        Class c = this.getTypeClass(obj);
        if (this.type != c) {
            int size = 0;
            if (this.model != null) {
                size = this.model.getSize();
            }
            this.setClass(c);
            if (this.model != null) {
                this.model.fireIntervalRemoved(this.model, 0, size - 1);
                this.model.fireIntervalAdded(this.model, 0, this.model.getSize() - 1);
            }
        }
        Object oldValue = this.selected;
        this.selected = obj;
        if (oldValue != obj) {
            this.pcSupport.firePropertyChange("value", oldValue, this.selected);
            if (this.editor != null) {
                this.editor.setSelectedItem(this.selected);
                this.editor.repaint();
            }
        }
    }

    private Class getTypeClass(Object obj) {
        Class<?> c = obj.getClass();
        String name = c.getName();
        if (name.matches(".+?\\$\\d+")) {
            c = c.getSuperclass();
        }
        return c;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        this.initEditor();
        return this.editor;
    }

    @Override
    public String getJavaInitializationString() {
        return "???";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics g, Rectangle r) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcSupport.removePropertyChangeListener(l);
    }

    @Override
    public Object getCellEditorValue() {
        return this.selected;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.initEditor();
        this.editor.setForeground(table.getForeground());
        this.editor.setBackground(table.getBackground());
        this.setValue(value);
        return this.editor;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject evt) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.add(CellEditorListener.class, l);
    }

    private void fireEditingStopped() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingCanceled(this.evt);
        }
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private List list;

        private Model() {
            this.list = new ArrayList(EnumerationEditor.this.nameMap.keySet());
            Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
        }

        @Override
        public Object getSelectedItem() {
            return EnumerationEditor.this.selected;
        }

        @Override
        public void setSelectedItem(Object o) {
            EnumerationEditor.this.setValue(o);
            EnumerationEditor.this.stopCellEditing();
        }

        @Override
        public Object getElementAt(int index) {
            return EnumerationEditor.this.nameMap.get(this.list.get(index));
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            super.fireIntervalRemoved(source, index0, index1);
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            super.fireIntervalAdded(source, index0, index1);
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            String s = (String)EnumerationEditor.this.valueMap.get(value);
            super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, hasFocus);
            if (value instanceof Enumeration) {
                this.setText(value.toString());
                this.setIcon(((Enumeration)value).getListIcon());
            }
            return this;
        }
    }
}

