/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import org.das2.util.StringSchemeEditor;

public class StringWithSchemeEditor
extends AbstractCellEditor
implements PropertyEditor,
TableCellEditor {
    private String value;
    private StringSchemeEditor ssEditor = null;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = (String)value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public String getAsText() {
        return this.value;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.value = text;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    public void setCustomEditor(StringSchemeEditor edit) {
        this.ssEditor = edit;
    }

    @Override
    public Component getCustomEditor() {
        if (this.ssEditor != null) {
            return this.ssEditor.getComponent();
        }
        return new JTextField();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        final JTextField f = new JTextField();
        f.setText(value.toString());
        f.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    StringWithSchemeEditor.this.setValue(e.getDocument().getText(0, e.getDocument().getLength()));
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(StringWithSchemeEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    StringWithSchemeEditor.this.setValue(e.getDocument().getText(0, e.getDocument().getLength()));
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(StringWithSchemeEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    StringWithSchemeEditor.this.setValue(e.getDocument().getText(0, e.getDocument().getLength()));
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(StringWithSchemeEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)f, "Center");
        final String propName = table.getValueAt(row, 0).toString();
        JButton extraButton = new JButton(new AbstractAction("?"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String svalue = (String)StringWithSchemeEditor.this.getValue();
                StringWithSchemeEditor.this.ssEditor.setValue(svalue);
                Component c = StringWithSchemeEditor.this.ssEditor.getComponent();
                if (0 == JOptionPane.showConfirmDialog(table, c, "Edit " + propName, 2)) {
                    f.setText(((StringSchemeEditor)c).getValue());
                    ((Component)e.getSource()).getParent().repaint();
                }
            }
        });
        extraButton.setPreferredSize(new Dimension(16, 16));
        extraButton.setMaximumSize(new Dimension(16, 16));
        extraButton.setToolTipText("Edit with " + this.ssEditor.getLabel());
        p.add((Component)extraButton, "East");
        return p;
    }
}

