/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.DefaultComponentDnDSupport;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.ListOption;
import org.das2.dasml.ParsedExpressionException;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormList
extends JList
implements Editable,
FormComponent {
    private String delimiter = " ";
    protected DnDSupport dndSupport;
    private String dasName;
    private boolean editable;

    public FormList(String name) {
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
    }

    FormList(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParsedExpressionException {
        super(new OptionListModel());
        String name = element.getAttribute("name");
        String selectionMode = element.getAttribute("selectionMode");
        if (selectionMode.equals("single")) {
            this.setSelectionMode(0);
        } else if (selectionMode.equals("multiple")) {
            this.setSelectionMode(2);
        }
        this.setDelimiter(element.getAttribute("delimiter"));
        this.setEnabled(element.getAttribute("enabled").equals("true"));
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("option")) continue;
            this.processOptionElement((Element)node);
        }
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
    }

    private void processOptionElement(Element element) {
        ListOption option = new ListOption(element);
        ((OptionListModel)this.getModel()).list.add(option);
        boolean selected = element.getAttribute("selected").equals("true");
        if (selected) {
            this.addSelectionInterval(this.getModel().getSize() - 1, this.getModel().getSize() - 1);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (l instanceof BasicListUI.MouseInputHandler) {
            l = new CtrlDownMouseInputListener((MouseInputListener)l);
        }
        super.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (l instanceof BasicListUI.MouseInputHandler) {
            l = new CtrlDownMouseInputListener((MouseInputListener)l);
        }
        super.addMouseMotionListener(l);
    }

    public void addItem(ListOption o) {
        ((OptionListModel)this.getModel()).list.add(o);
    }

    public ListOption getItem(int index) {
        return (ListOption)((OptionListModel)this.getModel()).list.get(index);
    }

    public int getItemCount() {
        return ((OptionListModel)this.getModel()).list.size();
    }

    public final void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getSelected() {
        int[] ii = this.getSelectedIndices();
        if (ii.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.getItem(ii[0]).getValue());
        for (int i = 1; i < ii.length; ++i) {
            result.append(this.delimiter).append(this.getItem(ii[i]).getValue());
        }
        return result.toString();
    }

    void setSelected(Object item, boolean b) {
        int index;
        OptionListModel model = (OptionListModel)this.getModel();
        for (index = 0; index < model.list.size() && model.list.get(index) != item; ++index) {
        }
        if (model.list.get(index) != item) {
            return;
        }
        if (b) {
            this.addSelectionInterval(index, index);
        } else {
            this.removeSelectionInterval(index, index);
        }
    }

    @Override
    public Element getDOMElement(Document document) {
        Element element = document.createElement("list");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("delimiter", this.delimiter);
        element.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        for (int index = 0; index < this.getItemCount(); ++index) {
            element.appendChild(this.getItem(0).getDOMElement(document));
        }
        return element;
    }

    @Override
    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    @Override
    public boolean getEditingMode() {
        return this.editable;
    }

    @Override
    public void setEditingMode(boolean b) {
        this.editable = b;
    }

    @Override
    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    @Override
    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    @Override
    public String getDasName() {
        return this.dasName;
    }

    @Override
    public final void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                throw new IllegalStateException(dpe);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalStateException(ite);
            }
        }
    }

    @Override
    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    @Override
    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
    }

    private static class OptionListModel
    extends AbstractListModel {
        List list = new ArrayList();

        private OptionListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }
    }

    private static class CtrlDownMouseInputListener
    extends MouseInputAdapter {
        private MouseInputListener listener;

        public CtrlDownMouseInputListener(MouseInputListener listener) {
            this.listener = listener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.listener.mousePressed(new CtrlDownMouseEvent(e));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.listener.mouseReleased(new CtrlDownMouseEvent(e));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.listener.mouseDragged(new CtrlDownMouseEvent(e));
        }
    }

    private static class CtrlDownMouseEvent
    extends MouseEvent {
        private static final int CTRL_YES = 130;
        private static final int SHIFT_NO = -66;

        public CtrlDownMouseEvent(MouseEvent e) {
            super(e.getComponent(), e.getID(), e.getWhen(), (e.getModifiers() | 0x82) & 0xFFFFFFBE, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
    }
}

